PROGRAM Cpu;

TYPE
  SysInfo = OBJECT
    FUNCTION GetCpuId: Integer;
    END;

{$F+}FUNCTION SysInfo.GetCpuId: Integer;{$F-}

BEGIN

INLINE(          {Inline assembler code to identify the CPU TYPE}

 $9C/             {  pushf           ;save Flags register       }
 $5B/             {  pop   bx        ;Store Flags in BX         }
 $81/$E3/$FF/$0F/ {  and   bx,$0fff  ;clear bits 12-15          }
 $53/             {  push  bx        ;restore to stack          }
 $9D/             {  popf            ;pop word into Flags reg   }
 $9C/             {  pushf           ;store Flags on stack      }
 $58/             {  pop   ax        ;recover Flags word        }
 $25/$00/$F0/     {  and   ax,$0f000 ;if bits 12-15 are set,    }
 $3D/$00/$F0/     {  cmp   ax,$0f000 ; the proc. is an 8086     }
 $74/$19/         {  jz    is8086                               }
 $81/$CB/$00/$F0/ {  or    bx,$0f000 ;try to set 12-15 bits     }
 $53/             {  push  bx        ;store on stack            }
 $9D/             {  popf            ;pop word into the Flags   }
 $9C/             {  pushf           ;store Flags on stack      }
 $58/             {  pop   ax        ;recover Flags word        }
 $25/$00/$F0/     {  and   ax,$0f000 ;if bits 12-15 cleared     }
 $74/$06/         {  jz    is80286   ;  the proc. is an 80286   }
                  {is80386:                                     }
 $B8/$82/$01/     {  mov   ax,386    ;else proc. is a 386 CPU   }
 $E9/$09/$00/     {  jmp   done      ;set as a 386 CPU          }
                  {is80286:                                     }
 $B8/$1E/$01/     {  mov   ax,286    ;set the 80286 indicator   }
 $E9/$03/$00/     {  jmp   done                                 }
                  {is8086:                                      }
 $B8/$56/$00/     {  mov   ax,86     ;set the 8086 indicator    }
                  {done:                                        }
 $89/$EC/         {  mov   sp,bp     ;restore sp                }
 $5D/             {  pop   bp        ;restore bp                }
 $CA/$04/$00);    {  retf  4         ;pop ptr to self           }

 END;

VAR
  CpuNbr  : Integer;
  SI : SysInfo;

BEGIN
  WriteLn('CPU Identification Routine');
  CpuNbr := SI.GetCpuId;
  Write('You are using a ');
  CASE CpuNbr OF
     86 : Write('8086');
    286 : Write('80286');
    386 : Write('80386');
    END;
  WriteLn(' Cpu');
  END.
