PROGRAM EnDeCryp;

USES Crt,FCUnit,Printer;

TYPE
  Code = (Encrypt,Decrypt);
  XlateType = ARRAY[0..255] OF Byte;
  EncryptObj = OBJECT(FileObj)
    XlateTable : XlateType;
    PROCEDURE SetCoding(CodeAction: Code);
    PROCEDURE EncryptDecryptBlock(VAR Fb: DataBlk; Size:Integer);
    PROCEDURE OutputXlate(X : XlateType);
    END;

CONST
  EncryptedMarker : String[4] = #199+#182+#182+#199;

PROCEDURE EncryptObj.SetCoding;

VAR
  Size,Ctr  : Integer;
  IdBytes   : String[4];
  TempTable : XlateType;
  R         : Byte;

BEGIN
  CASE CodeAction OF
    Encrypt : BEGIN
      Randomize; {Causes program to create a new table each time}
      Ctr := 0;                       {No table entries made yet}
      FillChar(TempTable,SizeOf(TempTable),0); {Initialize table}
      WHILE Ctr < 256 DO BEGIN                 {Fill table      }
        R := Random(256);                      {Get new number  }
        IF (TempTable[R] <> 1) THEN BEGIN      {Already set?    }
          TempTable[R] := 1;                   {Set to filled   }
          XlateTable[Ctr] := R;                {Store Rnd number}
          Inc(Ctr)                             {One more down   }
          END {IF}
        END;   {WHILE}
      BlockWrite(Fp, EncryptedMarker, SizeOf(EncryptedMarker));
      BlockWrite(Fp, XlateTable, SizeOf(XlateTable))
      END;    {Encrypt}

    Decrypt : BEGIN
      BlockRead(Fp, IdBytes, SizeOf(IdBytes), Size);  {Make sure}
      IF (Size <> SizeOf(IdBytes)) OR         {file is encrypted}
         (IdBytes <> EncryptedMarker) THEN BEGIN
        WriteLn('File not encrypted');        {before decrypting}
        Halt(1)
        END;

      BlockRead(Fp,XlateTable,SizeOf(XlateTable),Size); {Get all}
      IF Size <> SizeOf(XlateTable) THEN BEGIN         {of table}
        WriteLn('Bad or short encryption table found');
        Halt(2)
        END;

      OutputXlate(XlateTable);
      FOR Ctr := 0 TO 255 DO          {Load array for decoding}
        TempTable[XlateTable[Ctr]] := Ctr;
      Move(TempTable[0],XlateTable[0],SizeOf(TempTable));
      OutputXlate(XlateTable);
      END
    END
  END;

{---------------------------------------------------------------}

PROCEDURE EncryptObj.EncryptDecryptBlock;
VAR
  I : Integer;
BEGIN
  FOR I := 1 TO Size DO
    Fb[I] := XlateTable[Fb[I]]
  END;

{---------------------------------------------------------------}

PROCEDURE EncryptObj.OutputXlate;
VAR
  I : Integer;
BEGIN
  Write(Lst,'  ');
  FOR I := 0 TO 9 DO  Write(Lst,I:5);
  WriteLn(Lst,' '); WriteLn(Lst,' ');

  FOR I := 0 TO 255 DO BEGIN
    IF (I MOD 10) = 0 THEN Write(Lst,I:3,'  ');
    Write(Lst,X[I]:3,'  ');
    IF ((I+1) MOD 10) = 0 THEN WriteLn(Lst, ' ');
    END;
  WriteLn(Lst,' ');
  WriteLn(Lst,' ')
  END;

{---------------------------------------------------------------}

VAR
   InFile, OutFile : EncryptObj;
   Data            : DataBlk;
   Size            : Integer;
   Option          : String[1];

BEGIN
  ClrScr;
  WriteLn('EnDeCryp');
  WriteLn;
  WriteLn('       1 to encrypt TESTFILE.TXT');
  WriteLn('       2 to decrypt TESTFILE.CPY');
  WriteLn('       0 to quit');
  WriteLn;
  Write('Input: ');
  ReadLn(Option);
  IF (Option='0') OR (Pos(Option,'12')=0) THEN BEGIN
     WriteLn('Program Terminated');
     Halt(0)
     END;

  CASE Option[1] OF
    '1' : BEGIN
          InFile.OpenFile('TESTFILE.TXT', Input);
          OutFile.OpenFile('TESTFILE.CPY', Output);
          OutFile.SetCoding(Encrypt)
          END;
    '2' : BEGIN
          InFile.OpenFile('TESTFILE.CPY', Input);
          InFile.SetCoding(Decrypt);
          OutFile.OpenFile('TESTFILE.CHK', Output)
          END;
   END;

   REPEAT
     InFile.ReadBlock(Data, Size);
     IF Option = '1' THEN
       OutFile.EncryptDecryptBlock(Data,Size)
     ELSE
       InFile.EncryptDecryptBlock(Data, Size);
     OutFile.WriteBlock(Data, Size)
   UNTIL Size <> SizeOf(DataBlk);

   InFile.CloseFile;
   OutFile.CloseFile;
   Write('Press Enter to quit ... ');
   ReadLn
END.
