PROGRAM Cloak;

USES Crt,FCUnit;

CONST
  EndofFile = Chr(26);
  ProtectMarker : String = Chr(195)+Chr(180);

TYPE
  EofAction = (Add, Remove, NoAction);
  XFileObj1 = OBJECT(FileObj)
    PROCEDURE AddEOF(Message: String);
    PROCEDURE DelEOF;
    END;

PROCEDURE XFileObj1.AddEOF;
BEGIN
  BlockWrite(Fp, Message[1], Length(Message))
  END;

PROCEDURE XFileObj1.DelEOF;
VAR
  Intro   : DataBlk;
  Size,I  : Integer;
BEGIN
  ReadBlock(Intro,Size);
  I := 1;
  WHILE (I <= Size) AND (Intro[I] <> Ord(EndofFile)) DO
    Inc(I);
  IF (I > 255) OR
    (Intro[1] <> Ord(ProtectMarker[1])) OR
    (Intro[2] <> Ord(ProtectMarker[2])) OR
    (Intro[I-2] <> Ord(ProtectMarker[1])) OR
    (Intro[I-1] <> Ord(ProtectMarker[2])) THEN BEGIN
     WriteLn('File not protected');
     Halt(1)
     END;
  Seek(Fp,Longint(I));
  END;

VAR
   InFile,
   OutFile : XFileObj1;
   Data    : DataBlk;
   Size    : Integer;
   Option  : Byte;
   Msg     : String;

BEGIN
  ClrScr;
  WriteLn('Cloaking program');
  WriteLn;
  WriteLn('       1 to cloak FILE');
  WriteLn('       2 to uncloak a FILE');
  WriteLn('       0 to quit');
  WriteLn;
  Write('Input: ');
  ReadLn(Option);
  IF Option = 0 THEN BEGIN
     WriteLn('Program Terminated');
     Halt;
     END;

  CASE Option OF
    1 : BEGIN
          Msg := ProtectMarker + '-- You can''t touch this --' +
                     ProtectMarker + EndofFile;
          InFile.OpenFile('TESTFILE.TXT', Input);
          OutFile.OpenFile('TESTFILE.CPY', Output);
          OutFile.AddEOF(Msg);
          END;
    2 : BEGIN
          InFile.OpenFile('TESTFILE.CPY', Input);
          InFile.DelEOF;
          OutFile.OpenFile('TESTFILE.CHK', Output);
          END;
   END;

   REPEAT
     InFile.ReadBlock(Data, Size);
     OutFile.WriteBlock(Data, Size);
   UNTIL Size <> SizeOf(DataBlk);

   InFile.CloseFile;
   OutFile.CloseFile;
   Write('Press Enter to quit ... ');
   ReadLn;
END.
