UNIT Screen;

{
 A demonstration unit utilizing units from the
  Technojock Toolkit

  Purpose:  Initialize a program's main screen,
            including Main Menu, DateTime bar,
            and Program Title.

}

INTERFACE

  USES
    Crt,        { Borland Unit  }
    MiscTTT5,   { Date and Time Functions }
    FastTTT5,   { Screen Write routines }
    MenuTTT5,   { Menuing routines }
    KeyTTT5,    { Keyboard handler }
    WinTTT5;    { Windowing unit }
  VAR
    MainMenu   : Menu_Record;
    Choice,
    Error       : Integer;

  PROCEDURE InitMenu;
  PROCEDURE RunMenu;

IMPLEMENTATION

{$F+}
  PROCEDURE ClockBar;
    BEGIN
      WriteAt(1,25,Black,LightGray,Date);
      WriteAt(55,25,Black,LightGray,Time);
    END;
{$F-}

  PROCEDURE InitMenu;
    BEGIN
      SaveScreen( 1 );
      FillScreen(1,2,80,24,LightGray,Blue,' ');
      ClearLine(1,Red,LightGray);
      WriteCenter(1,Red,LightGray,
                  'TechnoJock Demo');
      ClearLine(25,Black,LightGray);
      Menu_Set( MainMenu );
      With MainMenu do
        begin
          Heading1 := 'Main Menu';
          Topic[1] := 'Load';
          Topic[2] := 'Save';
          Topic[3] := 'Print';
          Topic[4] := 'Exit';
          TotalPicks := 4;
         end;
    end;
  Procedure LoadSomething;
    begin
      WriteAt(1,1,Black,LightGray,'Loading');
      Sound(220); Delay(400); NoSound;
      WriteAt(1,1,Black,LightGray,'       ');
    end;

  Procedure SaveSomething;
    begin
      WriteAt(1,1,Black,LightGray,'Saving');
      Sound(440); Delay(400); NoSound;
      WriteAt(1,1,Black,LightGray,'      ');
    end;

  Procedure PrintSomething;
    begin
      WriteAt(1,1,Black,LightGray,'Printing');
      Sound(880); Delay(400); NoSound;
      WriteAt(1,1,Black,LightGray,'        ');
    end;


  Procedure RunMenu;
    begin
      Choice := 1;
      Repeat
        DisplayMenu(MainMenu,False,Choice,Error);
        Case Choice of
          1 : LoadSomething;
          2 : SaveSomething;
          3 : PrintSomething;
        end;
      Until (Choice = 4) OR (Error = 1);
      RestoreScreen( 1 );
    end;

  Begin
    Assign_Idle_Hook( ClockBar );
    InitMenu;
  End.
