{ Turbo Pascal Revise2 Demonstration }

USES Dos, Crt;

TYPE
  DataBlock = ARRAY[1..256] OF Byte;
  DataArray = ARRAY[1..10] OF Byte;

CONST
  DataAddress = $1B12;
     { address of FlagArray within .EXE file }
  FlagArray : DataArray =
      ( $5B, $48, $45, $52, $45, $49,
        $54, $49, $53, $5D );

VAR
  CurrPath : PathStr;
  Year, Month, Day, DOW: Word;

FUNCTION HexStr( Value : Byte ): STRING;

  VAR
     i : Integer;      TempStr : STRING[2];

  BEGIN
    TempStr[0] := Chr(2);
    IF Value SHR 4 < 10
      THEN TempStr[1] :=
               Chr( ( Value SHR 4 ) + $30 )
      ELSE TempStr[1] :=
               Chr( ( Value SHR 4 ) + $37 );
    IF Value AND $0F < 10
      THEN TempStr[2] :=
               Chr( ( Value AND $0F ) + $30 )
      ELSE TempStr[2] :=
               Chr( ( Value AND $0F ) + $37 );
    HexStr := TempStr;
  END;


PROCEDURE ReplaceData( CurrPath : PathStr;
                       DataAddress : Word;
                       NewArray : DataArray );

  VAR
    i, j, BlkCount, OffSet, Result : Integer;
     Dir : DirStr;       InF, OutF : FILE;
     Name : NameStr;        OutPath : PathStr;
     Ext : ExtStr;       FileBlock : DataBlock;

  BEGIN
     Assign( InF, CurrPath );
     {$I-} Reset( InF, 1 ); {$I+}

     IF IOResult = 0 THEN
     BEGIN
       BlkCount := 0;         j := 1;
       FSplit( CurrPath, Dir, Name, Ext );
       OutPath := Dir + Name + '.NEW';
       Assign( OutF, OutPath );
       Rewrite( OutF, 1 );
       Write( 'Read Data = ' );

       REPEAT
         BlockRead( InF, FileBlock,
               SizeOf( FileBlock ), Result );
         OffSet := DataAddress - BlkCount *
               SizeOf( FileBlock );
         IF( OffSet <= SizeOf( FileBlock ) )
             AND ( j <= SizeOf( NewArray ) ) THEN

         REPEAT
           Write( HexStr( FileBlock[j+OffSet] ),
                  ' ' );
           FileBlock[ j + OffSet ] :=
                  NewArray[ j ];
           Inc( j );
         UNTIL ( j > SizeOf( NewArray ) )
           OR ( j + OffSet >
               SizeOf( FileBlock ) );

         BlockWrite( OutF, FileBlock,
                     Result, Result );
         Inc( BlkCount );
       UNTIL Eof( InF );

       WriteLn;
       Close( OutF );
       Close( InF );
       erase( InF );
       rename( OutF, Name+'.EXE' );
     END ELSE WriteLn( CurrPath,
                       ' invalid file name!' );
  END;

VAR
  NewArray : DataArray;       i : Integer;

BEGIN
  CurrPath := FExpand( 'REVISE2.EXE' );
  FOR i := 1 TO 10 DO
    NewArray[i] := FlagArray[i];
  WriteLn( 'CurrPath = ', CurrPath );
  Write( 'DataArray = ' );
  FOR i := 1 TO 10 DO
    Write( HexStr( FlagArray[i] ), ' ' );
  WriteLn;
  GetDate(Year,Month,Day,DOW);
  NewArray[1] := Lo(Year-1900);
  NewArray[2] := Lo(Month);
  NewArray[3] := Lo(Day);
  If FlagArray[6] <> 0 then
    NewArray[4] := 1 {Initial # of executions}
  else
    NewArray[4] := FlagArray[4] + 1;
  FOR i := 5 TO 10 DO NewArray[i] := 0;
  ReplaceData( CurrPath, DataAddress, NewArray );
  Write( ' New data = ' );
  FOR i := 1 TO 10 DO
    Write( HexStr( NewArray[i] ), ' ' );
  WriteLn;
  GotoXY( 1, 25 );   ClrEol;
  Write( 'Press any key to continue: ');
  WHILE NOT KeyPressed DO;
  WriteLn;   WriteLn;
END.
