PROGRAM DynamicObjectDemo;

 { DYNDEMO.PAS }

USES Crt, Dos;

TYPE
   ScrPtr = ^SaveScreen;
   BoxPtr = ^ReportBox;
   SaveScreen = ARRAY[1..80,1..25] OF Word;
   ReportBox = OBJECT
      SavPtr: ScrPtr;  FColor, BColor: Byte;
      WPosX, WPosY, WSizeX, WSizeY: Integer;
      CONSTRUCTOR Init( PtX, PtY, Width, Height,
                         C1, C2 : Integer );
      DESTRUCTOR  Done;
      PROCEDURE   Draw;
      PROCEDURE   Erase;
   END;

{==========================================}
{ implementation for object type ReportBox }
{==========================================}

CONSTRUCTOR ReportBox.Init;
VAR
   I, J: Integer;
   Regs: Registers;
BEGIN
   WPosX  := PtX;
   WPosY  := PtY;
   WSizeX := Width;
   WSizeY := Height;
   FColor := C1;
   BColor := C2;
   New( SavPtr ); { allocate memory for array }
   Window( WPosX, WPosY, WPosX+WSizeX-1,
                         WPosY+WSizeY-1 );

  {read character and attribute on video page 0}

   FOR I := 1 TO WSizeX DO
      FOR J := 1 TO WSizeY DO
      BEGIN
         GotoXY(I,J);
         Regs.AH := 08;
         Regs.BH := 00;
         intr( $10, Regs );
         SavPtr^[I,J] := Regs.AX;
      END;
   Draw;
END;

DESTRUCTOR ReportBox.Done;
BEGIN
   Erase;
   Dispose( SavPtr );
END;

PROCEDURE ReportBox.Erase;
VAR
   I, J : Integer;
   Regs : Registers;
BEGIN
   Window( WPosX, WPosY,
           WPosX+WSizeX-1, WPosY+WSizeY-1 );
   ClrScr;   { inner window }

{ Write character and attr on video page 0 }

{ AL stores the character value }
{ BL stores the attribute value }
{ CL stores the repetitions value (1) }

   FOR I := 1 TO WSizeX DO
      FOR J := 1 TO WSizeY DO
      BEGIN
         GotoXY(I,J);
         Regs.AH := 09;
         Regs.BH := 00;
         Regs.AL := Lo( SavPtr^[I,J] );
         Regs.BL := Hi( SavPtr^[I,J] );
         Regs.CL := 1;
         Intr( $10, Regs );
      END;
   Window( 1, 1, 80, 25 );
END;

PROCEDURE ReportBox.Draw;
VAR
   BoxStr : STRING[6];
   I : Integer;
   MemSize : LongInt;
BEGIN
   TextColor( FColor );
   TextBackground( BColor );
   BoxStr := #$C9 + #$CD + #$BB +
             #$BA +#$BC + #$C8;
   Window( WPosX, WPosY,
           WPosX+WSizeX-1, WPosY+WSizeY-1 );
   ClrScr;
   GotoXY( 1, 1 );           Write( BoxStr[1] );
   FOR I := 1 TO WSizeX-2 DO Write( BoxStr[2] );
                             Write( BoxStr[3] );
   GotoXY( 1, WSizeY-1 );    Write( BoxStr[6] );
   FOR I := 1 TO WSizeX-2 DO Write( BoxStr[2] );
                             Write( BoxStr[5] );
   GotoXY( 1, 2 );
   InsLine;
   FOR I := 2 TO WSizeY-1 DO
   BEGIN
      GotoXY( 1, I );      Write( BoxStr[4] );
      GotoXY( WSizeX, I ); Write( BoxStr[4] );
   END;
   Window( WPosX+1, WPosY+1,
           WPosX+WSizeX-2, WPosY+WSizeY-2 );
   ClrScr;
   MemSize := MemAvail;
   FOR I := 1 TO 30 DO
      Write('Memory now = ',MemSize,' bytes! ');
   Window( 1, 1, 80, 25 );
END;

{ **** end of methods **** }

VAR
   Box : ARRAY[1..5] OF BoxPtr;
   MemSize : LongInt;
   I : Integer;

PROCEDURE Prompt;
BEGIN
   GotoXY( 1, 1 ); ClrEol;
   Write('Memory now = ', MemAvail,
         '. Press ENTER to continue ');
   ReadLn;
END;

BEGIN
   ClrScr;
   TextColor( White );
   TextBackground( Black );
   MemSize := MemAvail;
   FOR I := 1 TO 100 DO
      Write(' Initial memory available = ',
              MemSize, ' bytes! ' );
   GotoXY( 1, 1 ); ClrEol;
   Write('Press ENTER to continue ');
   ReadLn;
   Box[1] := New( BoxPtr, Init(  5, 12, 30, 10,
                  LightRed, Black ) );
   GotoXY( 1, 1 ); ClrEol;
   Write('Memory now = ', MemAvail,
         '. Press ENTER to continue ');
   ReadLn;
   Box[2] := New( BoxPtr, Init( 40,  5, 30, 10,
                  LightGreen, Blue ) );
   GotoXY( 1, 1 ); ClrEol;
   Write('Memory now = ', MemAvail,
         '. Press ENTER to continue ');
   ReadLn;
   Dispose( Box[1], Done );
   Dispose( Box[2], Done );
   GotoXY( 1, 1 ); ClrEol;
   Write( 'Final memory (after release) = ',
           MemAvail, ' bytes...');
   ReadLn;
END.
