{************************************************
* QUEEN1 - the first attempt at solving the     *
* queens problem.                               *
*                                               *
* INP:	c - the column # to place a queen in    *
*       n - the maximum column (& row) number   *
* USES: Soln - updates this solution counter    *
*       whenever a queen is successfully placed *
*       in the n'th column.                     *
************************************************}

UNIT Queen1;

INTERFACE

CONST
  MaxBrd = 25;

VAR
  {Chess brd}
  Board : ARRAY[0..MaxBrd+1,0..MaxBrd+1] OF Byte;
  Solns : Integer;

PROCEDURE InitBoard;
PROCEDURE Queens(C,N: Integer);


IMPLEMENTATION


PROCEDURE InitBoard;
  BEGIN
    FillChar(Board,SizeOf(Board),#0);
    Solns := 0
  END;


PROCEDURE Queens;

VAR
  I,J : Integer;
  Legal : Boolean;

BEGIN
  {Have we found a solution?}

  IF C=N THEN
    Inc(Solns)
  ELSE

   {Check each spot in the column}

    BEGIN
      FOR I:= 0 TO N-1 DO
        BEGIN

          Legal := TRUE;  {Legal until disproven}

          FOR J := 1 TO C DO

            BEGIN

              {-- Check row --}

              IF (Board[I,C-J] <> 0) THEN
                Legal := FALSE;

              {-- Check diagonal 1 --}

              IF ((I+J) < N) THEN
                IF (Board[I+J,C-J] <> 0) THEN
                  Legal := FALSE;

              {-- Check diagonal 2 --}

              IF ((I-J) >= 0) THEN
                IF (Board[I-J,C-J] <> 0) THEN
                  Legal := FALSE;
            END;

          IF (Legal) THEN

            BEGIN
              Board[I,C] := 1; {Put queen here}
              Queens(C+1,N);   {Process next col}
              Board[I,C] := 0  {Remove & try next}
            END;
        END;
    END;
END;

END.
