{************************************************
* QUEENS - solve the classical 'Queens' problem *
* FOR a board OF size n.  The problem is TO put *
* n Queens (chess pieces) on an n x n board so	*
* that no queen can attack any OF The others.	*
* This IMPLEMENTATION will print The number OF	*
* solutions found FOR each board size, from 1	*
* TO 9 squares on a side.                       *
*                                               *
* 900125 MCMason - originally coded             *
*************************************************}

{The Queen1 unit initially solves the puzzle,
 substitute queen2 and queen3 in the $Define
 compiler directive for alternative algorithms}


{$DEFINE QUEEN1}

{$IFDEF QUEEN1}
USES QUEEN1;
{$ENDIF}

{$IFDEF QUEEN2}
USES QUEEN2;
{$ENDIF}

{$IFDEF QUEEN3}
USES QUEEN3;
{$ENDIF}


VAR
   TotalSolns : Integer;   {Total solns/all sizes}
   I : Integer;


BEGIN
   TotalSolns := 0;

   { Print table heading }

   WriteLn('# Queens    # solns    Total #');
   WriteLn('# Brd sz    this sz     solns');
   WriteLn('--------    -------    -------');

   {Find the number of solutions for each}
   {board size, and print the table entry.}

   FOR I :=1 TO 9 DO
      BEGIN
         InitBoard;          {Clear the board}
                             {Solve the problem}
         Queens(0,I);        {Start @ column 0}
                             {Print summary}
         Inc(TotalSolns,solns);
         WriteLn(I:6,solns:13,TotalSolns:10)
      END;

   {Print end of table footer}

   WriteLn('--------    -------    -------')
END.
