(* HEAPTIME.PAS -- Display heap size AND current time *)

PROGRAM HEAPTIME;

USES Objects, App, Gadgets;

TYPE
  PTheApp = ^TheApp;
  TheApp = OBJECT(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    CONSTRUCTOR Init;
    PROCEDURE Idle; virtual;
  END;

CONSTRUCTOR TheApp.Init;
VAR R: TRect;
BEGIN
  TApplication.Init;
  GetExtent(R);
  R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R));
  Insert(Clock);
  GetExtent(R);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap)
END;

PROCEDURE TheApp.Idle;
BEGIN
  TApplication.Idle;
  Clock^.Update;
  Heap^.Update
END;

VAR
  Application: TheApp;

BEGIN
  Application.Init;
  Application.Run;
  Application.Done
END.

(* Copyright (c) 1990 by Tom Swan. All rights reserved         *)
