(* DISPLAY.PAS -- DISPLAY Text IN a Window *)

PROGRAM DISPLAY;

USES Objects, Views, App;

TYPE
  TheApp = OBJECT(TApplication)
    CONSTRUCTOR Init;
  END;

  PTheWindow = ^TheWindow;
  TheWindow = OBJECT(TWindow)
    CONSTRUCTOR Init;
  END;

  PTheView = ^TheView;
  TheView = OBJECT(TView)
    TextArray: ARRAY[0 .. 4] OF String[40];
    CONSTRUCTOR Init(VAR Bounds: TRect);
    PROCEDURE Draw; virtual;
  END;

CONSTRUCTOR TheApp.Init;
VAR W: PTheWindow;
BEGIN
  TApplication.Init;
  New(W, Init);
  DeskTop^.Insert(W)
END;

CONSTRUCTOR TheWindow.Init;
VAR 
  R: TRect;
  V: PTheView;
BEGIN
  DeskTop^.GetExtent(R);
  TWindow.Init(R, 'Test Window', 0);
  flags := flags AND (NOT (wfMove + wfGrow + wfClose + wfZoom));
  GetClipRect(R);
  R.Grow(-1, -1);
  V := New(PTheView, Init(R));
  Insert(V)
END;

CONSTRUCTOR TheView.Init(VAR Bounds: TRect);
BEGIN
  TView.Init(Bounds);
  TextArray[0] := 'Good night, good night!';
  TextArray[1] := 'Parting is such sweet sorrow,';
  TextArray[2] := 'That I shall say good night';
  TextArray[3] := 'Till it be morrow.';
  TextArray[4] := '    -- Romeo and Juliet II, ii';
END;

PROCEDURE TheView.Draw;
VAR
  Y : Integer;
BEGIN
  TView.Draw;
  FOR Y := 0 TO 4 DO
    WriteStr(1, Y + 4, TextArray[Y], 1)
END;

VAR
  Application: TheApp;

BEGIN
  Application.Init;
  Application.Run;
  Application.Done
END.

(* Copyright (c) 1990 by Tom Swan. All rights reserved        *)
