{$E+,I-,N+,R-,V- -- 80x87 emulation, no I/O errors, 
                    no range checks}
UNIT NDX;
{
    NDX.TPU    RKB    89/05/28.

    This unit supports reading and traversing dBASE III .NDX 
    files. 

    dBASE and dBASE III are trademarks of Ashton-Tate Corporation.

    Copyright (C) 1990. Robert K. Blaine/ECONO-SOFT.
    All rights reserved.

    Permission is hereby granted to freely use these routines
    as long as this copyright remains intact.
}
{========================}  INTERFACE  {========================}

USES Dos;
CONST
  MaxNDXKeyLength = 511 - 24 + 1;  {bytes 24..511 of the header}
  MaxNDXKeyValueLength = 100;

TYPE
  Str13  = String [13];
  Str66  = String [66];
  Str100 = String [100];

TYPE
  NDXheaderRec = RECORD
    RootPage:   Longint;    { 0- 3: B+ tree root page number}
    NextPage:   Longint;    { 4- 7: first unused page}
    d0:         Longint;    { 8-11: (reserved)}
    KeyLen:     Word;       {12-13: key length}
    KeysPage:   Word;       {14-15: keys per page}
    NumericKey: Boolean;    {   16: true iff key is numeric}
    d1:         Byte;       {   17: (reserved)}
    EntrySize:  Word;       {18-19: length of entry}
    d2:         Longint;    {20-23: (reserved)}
    Key:        ARRAY [1 .. MaxNDXKeyLength] OF Char;
  END;

  NDXpageRec = RECORD
    NEntries: Integer;      { 0- 1: #active entries in this page}
    d0:       Integer;
    Entries:  ARRAY [0 .. 507] OF Byte;
  END;

  NDXentry = ^NDXentryRec;
  NDXentryRec = RECORD
    LEpage: Longint;        { 0- 3: page containing previous keys}
    RecNo:  Longint;        { 4- 7: record number matching Key}
    CASE Byte OF
      1:(DoubleKey: double);
      2:(CharKey: ARRAY [1 .. MaxNDXKeyValueLength] OF Char);
  END;

{
   Notes: - RecNo or LEpage that are not used are set to 0.
          - an entry has LEpage or RecNo but never both.
          - numeric and date keys stored as 8-byte 80x87 Doubles.
}

  _NDX = RECORD
    F:        FILE;         {the .NDX file itself}
    H:        NDXheaderRec; {the .NDX file header}
    Level:    Integer;      {current level of recursion}
    MaxLevel: Integer;      {maximum level of recursion}
  END;

  {A routine of type "NDXproc" may be called by NDXtraverse.}

  NDXproc = PROCEDURE (VAR N: _NDX; VAR entry: NDXentry);

PROCEDURE NDXopen (VAR N: _NDX; fn: Str66);
PROCEDURE NDXclose (VAR N: _NDX);
FUNCTION NDXgetKey (VAR N: _NDX; VAR entry: NDXentry): Str100;
PROCEDURE NDXtraverse (VAR N: _NDX; Call: NDXproc);

{=====================}  IMPLEMENTATION  {======================}

PROCEDURE ErrorExit (Msg: Str66);
 BEGIN
  WriteLn (Msg);
  Halt (1);
 END;

PROCEDURE NDXopen (VAR N: _NDX; fn: Str66);
{
    Open a dBASE III Index (.NDX) file.

      entry conditions:
        passed : N = Index control record.
                 fn = file specification.

      exit conditions:
        return : N = completely initialized.
}
VAR
  SizeRead: Word;

 BEGIN  {NDXopen}
  Assign (N.F, fn);  Reset (N.F, 1);
  IF IOResult <> 0 THEN
    ErrorExit ('Could not open NDX.');

  BlockRead (N.F, N.H, SizeOf (N.H), SizeRead);
  IF (IOResult <> 0) OR (SizeRead < SizeOf (N.H)) THEN
    ErrorExit ('Could not read NDX header page.');

  N.Level    := 0;
  N.MaxLevel := 0;
 END;  {NDXopen}

PROCEDURE NDXclose (VAR N: _NDX);
{
    Close a dBASE III Index (.NDX) file.

      entry conditions:
        passed : N = Index control record.

      exit conditions:
        none.
}
 BEGIN  {NDXclose}
  Close (N.F);
  IF IOResult <> 0 THEN
    ErrorExit ('Could not close NDX.');
 END;  {NDXclose}

FUNCTION NDXgetKey (VAR N: _NDX; VAR entry: NDXentry): Str100;
{
    Get the alphanumeric key associated with an index entry.

      entry conditions:
        passed : N = Index control record.
                 Entry = Pointer to an entry record.

      exit conditions:
        return : Alphanumeric key.
}
VAR
  S: Str100;

 BEGIN  {NDXgetKey}
  IF N.H.NumericKey THEN
    NDXgetKey := ''
  ELSE
   BEGIN
    Move (entry^.CharKey, S [1], N.H.KeyLen);
    Byte (S [0]) := N.H.KeyLen;  {length of String}
    NDXgetKey := S;
   END;
 END;  {NDXgetKey}

PROCEDURE NDXtraversePrim (VAR N: _NDX; Call: NDXproc; 
                           page: Longint);
{
    Traverse a dBASE III Index (.NDX) file calling the user 
    routine for each entry in the index.

      entry conditions:
        passed : N = Index control record.
                 Call = user routine to call.
                 Page = page number.

      exit conditions:
        none.

    Note: This routine is not called directly and is not 
          interfaced; it is called through NDXtraverse.
}
VAR
  BytesRead: Word;
  Entry: NDXentry;
  GTpage: ^Longint;
  I, Base: Integer;
  PageBuf: NDXpageRec;

 BEGIN  {NDXtraversePrim}
  Inc (N.Level);
  N.MaxLevel := N.Level;

  Seek (N.F, page SHL 9 {* 512});
  IF IOResult <> 0 THEN
    ErrorExit ('Could not seek to requested page.');

  BlockRead (N.F, PageBuf, SizeOf (PageBuf), BytesRead);
  IF (IOResult <> 0) OR (BytesRead <> SizeOf (PageBuf)) THEN
    ErrorExit ('Could not read requested index page.');

  I := 0;
  Base := 0;
  WHILE I < PageBuf.NEntries DO
   BEGIN
    Entry := Addr (PageBuf.Entries [Base]);
    IF Entry^.LEpage <> 0 THEN
      NDXtraversePrim (N, Call, Entry^.LEpage);
    IF Entry^.RecNo <> 0 THEN
       Call (N, Entry);

    Inc (I);
    Inc (Base, N.H.EntrySize);
   END;  {WHILE}

  GTpage := Addr (PageBuf.Entries [Base]);
  IF GTpage^ <> 0 THEN  {keys *greater* than this page}
    NDXtraversePrim (N, Call, GTpage^);

  Dec (N.Level);
 END;  {NDXtraversePrim}

PROCEDURE NDXtraverse (VAR N: _NDX; Call: NDXproc);
{
    Front end to NDXtraversePrim; starts at RootPage.

      entry conditions:
        passed : N = Index control record.
                 Call = user routine to call.

      exit conditions:
        none.
}
 BEGIN  {NDXtraverse}
  NDXtraversePrim (N, Call, N.H.RootPage);
 END;  {NDXtraverse}

{=======================  initialization  ======================}

 END.  {NDX UNIT}
