(* CDISPLAY.PAS -- Demonstrate color palettes *)

PROGRAM CDISPLAY;

USES Objects, Drivers, Views, App;

TYPE
  PTheApp = ^TheApp;
  TheApp = OBJECT(TApplication)
    CONSTRUCTOR Init;
  END;

  PTheWindow = ^TheWindow;
  TheWindow = OBJECT(TWindow)
    CONSTRUCTOR Init;
  END;

  PTheView = ^TheView;
  TheView = OBJECT(TView)
    TextArray: ARRAY[0 .. 4] OF String[40];
    CONSTRUCTOR Init(VAR Bounds: TRect);
    FUNCTION GetPalette: PPalette; virtual;
    PROCEDURE Draw; virtual;
  END;

CONSTRUCTOR TheApp.Init;
VAR W: PTheWindow;
BEGIN
  TApplication.Init;
  New(W, Init);
  DeskTop^.Insert(W)
END;

CONSTRUCTOR TheWindow.Init;
VAR 
  R: TRect;
  V: PTheView;
BEGIN
  DeskTop^.GetExtent(R);
  TWindow.Init(R, 'Test Window', 0);
  flags := flags AND (NOT (wfMove + wfGrow + wfClose + wfZoom));
  GetClipRect(R);
  R.Grow(-1, -1);
  V := New(PTheView, Init(R));
  Insert(V)
END;

CONSTRUCTOR TheView.Init(VAR Bounds: TRect);
BEGIN
  TView.Init(Bounds);
  TextArray[0] := 'If we shadows have offended,';
  TextArray[1] := 'Think but this, and all is mended,';
  TextArray[2] := 'That you have but slumbered here';
  TextArray[3] := 'While these visions did appear.';
  TextArray[4] := '  -- A Midsummer-Night''s Dream V, ii';
END;

FUNCTION TheView.GetPalette: PPalette;
CONST
  CTheView = #2#3;
  PTheView: String[Length(CTheView)] = CTheView;
BEGIN
  GetPalette := @PTheView  
END;

PROCEDURE TheView.Draw;
VAR
  B: TDrawBuffer;
  C: Word;
  Y: Integer;
BEGIN
  {- Erase screen }
  C := GetColor(1);
  MoveChar(B, #250, C, Size.X);
  WriteLine(0, 0, Size.X, Size.Y, B);

  {- Display text in window }
  C := GetColor(2);
  FOR Y := 0 TO 4 DO
  BEGIN
    MoveStr(B, TextArray[Y], 0);
    WriteLine(4, Y + 4, Length(TextArray[Y]), 1, B)
  END
END;

VAR
  Application: TheApp;

BEGIN
  Application.Init;
  Application.Run;
  Application.Done
END.

(* Copyright (C) 1990 by Tom Swan. All rights reserved        *)
