PROGRAM TestBox;

USES Crt,Graph,GrphBox,Mouse;

{================================================================
= GrInit - Initialize graphics system                           =
================================================================}

FUNCTION GrInit: Integer;
VAR GrDriver, GrMode, GrErr : Integer;
BEGIN
  DetectGraph(GrDriver, GrMode); {* Initialize graphics system *}
  IF (GrDriver < 0) THEN
    GrInit := -1
  ELSE BEGIN
    InitGraph(GrDriver, GrMode,'');
    GrErr:=GraphResult;
    IF (GrErr <> 0) THEN
      GrInit := GrErr
    ELSE
      GrInit := 0
    END
  END;

{=============== Demonstration Main Block ======================}

CONST
  StdColor : ColorType = (Fore: Red; Back: LightCyan);
  ButtonColor : ColorType = (Fore: Yellow; Back: Black);
  PressColor : ColorType = (Fore: Black; Back: Yellow);
  AltColor : ColorType = (Fore: Red; Back: Blue);

VAR
  Box1,Box2              : BoxObj;               {Two demo boxes}
  S                      : String; {Dummy string for readability}
  Dialog1,Dialog2        : DialogBoxObj;    {2 demo dialog boxes}
  Response1,Response2    : Byte;  {Btn # values for dialog boxes}
  Adios                  : Boolean;     {Switch for exiting loop}
  Mx,My                  : Integer;         {Mouse x,y locations}

BEGIN
  IF GrInit <> GrOk THEN Halt(1);           {Initialize graphics}

{==================== Initialize all boxes =====================}

  S := 'This is a sample text box. Press Enter to Continue.';
  Box1.Init((GetMaxX - TextWidth(S)-20) DIV 2,
            ((GetMaxY - 100) DIV 2),
            TextWidth(S)+20,100,S,StdColor,1);
  S := 'Here''s a second box. Press Enter';
  Box2.Init((GetMaxX - TextWidth(S)-20) DIV 2,(GetMaxY) - 100,
            TextWidth(S) + 20,20,S,StdColor,1);
  S := 'You wanna quit?         ';
  Dialog1.Init((GetMaxX - TextWidth(S)-10) DIV 2,
               (GetMaxY - TextHeight(S)*10) DIV 2,
               TextWidth(S)+40,TextHeight(S)*10,
               S,'Quit','Continue',
               StdColor,ButtonColor,PressColor,'Q','C');
  S := 'Really?                   ';
  Dialog2.Init((GetMaxX - TextWidth(S)-10) DIV 2,
               (GetMaxY - TextHeight(S) * 6) DIV 2,
               TextWidth(S)+40,TextHeight(S) * 6,S,'Yes','No',
               AltColor,ButtonColor,PressColor,'Y','N');
  IF MaxColors >= 15 THEN BEGIN              {Display background}
    SetFillStyle(SolidFill,LightGray);
    SetColor(Black);
    Bar(0,0,GetMaxX,GetMaxY)
    END;
  Rectangle(50,30,GetMaxX-50,GetMaxY-30);            {Dsp border}
  InitMouse;
  ShowMouseCursor;
  Box1.DrawBox;                    { Display first onscreen box }
  Box1.DisplayText(10,10);
  ReadLn;
  Box2.DrawBox;                           { Display another box }
  Box2.DisplayText(Centered,0);
  ReadLn;
  Box2.RemoveBox;                      { Erase boxes and delete }
  Box2.Done;
  Box1.RemoveBox;
  Box1.Done;
  Adios := FALSE;                                {Set switch off}
  Dialog1.DrawDialog;                  {Display first dialog box}
  REPEAT
    Response1 := Dialog1.GetResponse;    {Check first dialog box}
    IF Response1 = 1 THEN BEGIN                     {Quit chosen}
      Dialog2.DrawDialog;               {Draw the 2nd dialog box}
      Response2 := Dialog2.GetResponse; {  and get user response}
      IF Response2 = 1 THEN BEGIN               {Response = Quit}
        Dialog2.RemoveDialog;                  {Get rid of box 2}
        Dialog1.RemoveDialog;                  {Get rid of box 1}
        Adios := TRUE                 {Set switch so we can Exit}
        END
      ELSE Dialog2.RemoveDialog    {Get rid of second dialog box}
      END
    UNTIL Adios = TRUE;
  Dialog2.Done; Dialog1.Done;          {Delete both dialog boxes}
  CloseGraph
END.
