UNIT Mouse;

INTERFACE
USES Dos;

PROCEDURE InitMouse;
PROCEDURE ShowMouseCursor;
PROCEDURE HideMouseCursor;
PROCEDURE GetMouseButtonPresses
                  (VAR MouseStatus,Button,X,Y : Word);
FUNCTION CheckMouse(VAR X,Y : Word): Boolean;

IMPLEMENTATION
VAR MouseStatus,Button  : Word;

PROCEDURE MouseCall (VAR M1,M2,M3,M4 : Word);    {Main mouse    }
VAR CpuReg : Registers;                          { calling proc }
BEGIN
  IF M1 >= 0 THEN BEGIN                         {Setup Registers}
    CpuReg.AX := M1; CpuReg.BX := M2;
    CpuReg.CX := M3; CpuReg.DX := M4;
    END;
  Intr($33,CpuReg);
  M1 :=CpuReg.AX; M2 :=CpuReg.BX;              {Return Registers}
  M3 :=CpuReg.CX; M4 :=CpuReg.DX;
END;

PROCEDURE InitMouse;
VAR X,Y : Word;
BEGIN
   MouseStatus := 0; MouseCall(MouseStatus,Button,X,Y)
END;

PROCEDURE ShowMouseCursor;
VAR X,Y : Word;
BEGIN
   MouseStatus := 1; MouseCall(MouseStatus,Button,X,Y)
END;

PROCEDURE HideMouseCursor;
VAR X,Y : Word;
BEGIN
   MouseStatus := 2; MouseCall(MouseStatus,Button,X,Y)
END;

PROCEDURE GetMouseButtonPresses
                  (VAR MouseStatus,Button,X,Y : Word);
BEGIN
   MouseStatus := 5; MouseCall(MouseStatus,Button,X,Y)
END;

FUNCTION CheckMouse(VAR X,Y : Word): Boolean;
BEGIN
  Button := 0;                                   {Check left btn}
  GetMouseButtonPresses(MouseStatus,Button,X,Y);   {Pressed btn?}
  IF Button > 0 THEN CheckMouse := TRUE
  ELSE CheckMouse := FALSE
  END;

END.
