UNIT GrphBox;

INTERFACE

USES Crt,Dos,Graph,Mouse;

CONST Centered = -1;                  {Use to center text in box}
TYPE
  CoorType = RECORD                  {Graphics coordinate RECORD}
    X,Y : Integer;
    END;
  ColorType = RECORD       {Color record type for boxes and btns}
    Fore,Back : Integer;
    END;
  BoxObj = OBJECT                               {Base box OBJECT}
    Pt1,Pt2        : CoorType;         {Upper left/right corners}
    Msg            : String;                    {Text to display}
    C1             : ColorType;               {Display color one}
    CurrentColor   : ColorType; {Current dsp color lets you swap}
    NbrLines       : Byte;           {Number of box border lines}
    Size           : Word;                    {Size of box image}
    PreviousScreen : Pointer;  {Ptr to memory for previous image}
    CONSTRUCTOR Init(Pt1X,Pt1Y,Width,Height : Integer;
                     DisplayString     : String;
                     Colors            : ColorType;
                     NumberofLines     : Byte);
    PROCEDURE DrawBox; Virtual;
    PROCEDURE DisplayText(LeftOffset,TopOffset:Integer); Virtual;
    FUNCTION MouseInBox(Mx,My : Integer): Boolean;
    PROCEDURE RemoveBox; Virtual;
    DESTRUCTOR Done; Virtual;
    END;
  ButtonObj = OBJECT(BoxObj)
    C2         : ColorType;   {Color to display when btn pressed}
    HotKey     : Char;         {Hotkey character to press button}
    CONSTRUCTOR Init(Pt1X,Pt1Y,Width,Height : Integer;
                     DisplayString     : String;
                     Color1,Color2     : ColorType;
                     NumberofLines     : Byte;
                     HotKeyChar        : Char);
    PROCEDURE DrawButton; Virtual;
    FUNCTION HotKeyPressed(Key: Char): Boolean;
    PROCEDURE PressButton; Virtual;
    PROCEDURE RemoveButton; Virtual;
    DESTRUCTOR Done; Virtual;
    END;
  DialogBoxObj = OBJECT(BoxObj)
    Btn1,Btn2 : ButtonObj;          {Default to 2 btn dialog box}
    CONSTRUCTOR Init(Pt1X,Pt1Y,Width,Height : Integer;
                     DisplayString,Btn1Str,Btn2Str : String;
                     BoxColor,BtnColorOff,BtnColorOn :ColorType;
                     Btn1Chr,Btn2Chr : Char);
    PROCEDURE DrawDialog; Virtual;
    FUNCTION GetResponse: Byte; Virtual;
    PROCEDURE RemoveDialog; Virtual;
    DESTRUCTOR Done; Virtual;
    END;

IMPLEMENTATION

PROCEDURE MyColors(C: ColorType);
BEGIN
  IF MaxColors >= 15 THEN BEGIN
    SetFillStyle(SolidFill,C.Back); SetColor(C.Fore)
    END
  ELSE BEGIN
    SetFillStyle(SolidFill,White);  SetColor(Black)
    END
  END;

PROCEDURE Tone;
BEGIN
  Sound(880); Delay(500); NoSound
  END;

{===============================================================}
{===================== BOX OBJECT METHODS ======================}
{===============================================================}

CONSTRUCTOR BoxObj.Init(Pt1X,Pt1Y,Width,Height : Integer;
                        DisplayString : String;
                        Colors        : ColorType;
                        NumberofLines : Byte);
BEGIN
  Pt1.X := Pt1X; Pt1.Y := Pt1Y;    {Store upper left coordinates}
  Pt2.X := Pt1X + Width - 1;  {Calculate lower right coordinates}
  Pt2.Y := Pt1Y + Height - 1;
  Msg := DisplayString;
  C1 := Colors; CurrentColor := C1;
  NbrLines := NumberofLines;
  Size := ImageSize(Pt1.X,Pt1.Y,Pt2.X,Pt2.Y)
  END;

PROCEDURE BoxObj.DrawBox;
VAR
  OldColor : Word;               {Temp variables to save current}
  OldFill  : FillSettingsType;   {  settings during routine     }
  I,J      : Byte;
BEGIN
  HideMouseCursor;                         {Get current settings}
  OldColor := GetColor;
  GetFillSettings(OldFill);
  GetMem(PreviousScreen,Size);         {Get current screen image}
  GetImage(Pt1.X,Pt1.Y,Pt2.X,Pt2.Y,PreviousScreen^);
  PutImage(Pt1.X,Pt1.Y,PreviousScreen^,XORPut);    {Erase screen}
  MyColors(CurrentColor);            {Set and display new Colors}
  Bar(Pt1.X,Pt1.Y,Pt2.X,Pt2.Y);
  FOR I := 1 TO NbrLines DO BEGIN
    J := I * 2; Rectangle(Pt1.X+J,Pt1.Y+J,Pt2.X-J,Pt2.Y-J)
    END;
  SetColor(OldColor);                  {Restore settings on Exit}
  WITH OldFill DO SetFillStyle(Pattern,Color);
  ShowMouseCursor
  END;

PROCEDURE BoxObj.DisplayText(LeftOffset,TopOffset:Integer);
VAR OldColor: Word;
BEGIN
  OldColor := GetColor;                    {Get current settings}
  HideMouseCursor;                                {Off the Mouse}
  MyColors(CurrentColor);                 {Set to current Colors}
  IF LeftOffset = Centered THEN BEGIN        {Center the text OR}
    SetTextJustify(CenterText,CenterText);
    OutTextXY(Pt1.X+((Pt2.X-Pt1.X) DIV 2),
              Pt1.Y+((Pt2.Y-Pt1.Y) DIV 2),Msg)
    END
  ELSE                                      {Position it        }
    OutTextXY(Pt1.X+LeftOffset,Pt1.Y+TopOffset,Msg);
  SetTextJustify(LeftText,TopText);       {Restore settings     }
  SetColor(OldColor);
  ShowMouseCursor
  END;

PROCEDURE BoxObj.RemoveBox;
BEGIN
  HideMouseCursor;
  PutImage(Pt1.X,Pt1.Y,PreviousScreen^,CopyPut); {Restore screen}
  FreeMem(PreviousScreen,Size); {image and return memory to heap}
  ShowMouseCursor
  END;

DESTRUCTOR BoxObj.Done;
BEGIN
  END;

FUNCTION BoxObj.MouseInBox(Mx,My : Integer): Boolean;
BEGIN
  IF (Mx > Pt1.X) AND (Mx < Pt2.X) AND   {Check position against}
     (My > Pt1.Y) AND (My < Pt2.Y) THEN  {box boundary          }
    MouseInBox := TRUE
  ELSE
    MouseInBox := FALSE
END;

{===============================================================}
{================== BUTTON OBJECT METHODS ======================}
{===============================================================}

CONSTRUCTOR ButtonObj.Init(Pt1X,Pt1Y,Width,Height : Integer;
                           DisplayString     : String;
                           Color1,Color2     : ColorType;
                           NumberofLines     : Byte;
                           HotKeyChar        : Char);
BEGIN
  BoxObj.Init(Pt1X,Pt1Y,Width,Height,
              DisplayString,Color1,NumberofLines);
  C2 := Color2; HotKey := HotKeyChar
  END;

PROCEDURE ButtonObj.DrawButton;
BEGIN
  DrawBox; DisplayText(Centered,0)
  END;

FUNCTION ButtonObj.HotKeyPressed(Key: Char): Boolean;
BEGIN
  IF Key = HotKey THEN
    HotKeyPressed := TRUE
  ELSE
    HotKeyPressed := FALSE
  END;

PROCEDURE ButtonObj.PressButton;
BEGIN
  RemoveButton;                               {Erase button THEN}
  CurrentColor := C2; DrawButton; Delay(250); {redisplay in 2nd }
  RemoveButton;                               {color. Restore TO}
  CurrentColor := C1; DrawButton              {1st color.       }
  END;

PROCEDURE ButtonObj.RemoveButton;
BEGIN
  RemoveBox
  END;

DESTRUCTOR ButtonObj.Done;
BEGIN
  BoxObj.Done
  END;

{===============================================================}
{=============== DIALOG BOX OBJECT METHODS =====================}
{===============================================================}

CONSTRUCTOR DialogBoxObj.Init(Pt1X,Pt1Y,Width,Height : Integer;
                     DisplayString,Btn1Str,Btn2Str : String;
                     BoxColor,BtnColorOff,BtnColorOn :ColorType;
                     Btn1Chr,Btn2Chr : Char);
VAR
  TotalLen,Margin,TH,CalcBtnTop : Integer;
BEGIN
  BoxObj.Init(Pt1X,Pt1Y,Width,Height,DisplayString,BoxColor,1);
  TotalLen := TextWidth(Btn1Str) +          {Semi self-adjusting}
              TextWidth(Btn2Str) + 20;      { button positions  }
  Margin := (Width - TotalLen) DIV 3;       {Adjust btn spacing }
  TH := TextHeight(Btn1Str)+10;             {Set top of btn from}
  CalcBtnTop := Pt2.Y - TH - 15;            { the bottom of box }
  Btn1.Init(Pt1.X + Margin,CalcBtnTop,
            TextWidth(Btn1Str)+15,TH+5,
            Btn1Str,BtnColorOff,BtnColorOn,2,Btn1Chr);
  Btn2.Init(Pt2.X - Margin-TextWidth(Btn2Str),
            CalcBtnTop,TextWidth(Btn2Str)+15,TH+5,
            Btn2Str,BtnColorOff,BtnColorOn,1,Btn2Chr)
  END;

PROCEDURE DialogBoxObj.DrawDialog;
BEGIN
  DrawBox; DisplayText(5,5);
  Btn1.DrawButton; Btn2.DrawButton
  END;

FUNCTION DialogBoxObj.GetResponse: Byte;
CONST Enter = 13;   {Press Enter to get the default (2 line) btn}
VAR
  Key   : Char;     {Keypress from keyboard}
  Press : Byte;     {Button number selected}
  Mx,My : Word;     {Mouse press locations (x,y)}
BEGIN
  Press := 0;                             {No selection made yet}
  REPEAT
    IF KeyPressed THEN BEGIN               {Check keyboard first}
      Key := UpCase(ReadKey);
      IF Btn1.HotKeyPressed(Key) OR        {Check for button one}
         (Ord(Key) = Enter) THEN Press := 1
      ELSE IF Btn2.HotKeyPressed(Key) THEN Press := 2;    {Btn 2}
      END
    ELSE BEGIN
      IF CheckMouse(Mx,My) THEN         {Check the mouse buttons}
        IF Btn1.MouseInBox(Mx,My) THEN Press := 1         {Btn 1}
        ELSE IF Btn2.MouseInBox(Mx,My) THEN Press := 2    {Btn 2}
      END
    UNTIL Press <> 0;                {Until you make a selection}
    Tone;
    CASE Press OF                    {Show that old button Press}
      1 : Btn1.PressButton;
      2 : Btn2.PressButton;
      END;
    GetResponse := Press    {Return the # of the selected button}
  END;

PROCEDURE DialogBoxObj.RemoveDialog;
BEGIN
  Btn2.RemoveButton; Btn1.RemoveButton; RemoveBox
  END;

DESTRUCTOR DialogBoxObj.Done;
BEGIN
  BoxObj.Done
  END;

END.
