{$Define ATIMode} { gm 910112A for ATI card. Search for "$ifdef" }

{*****************************************************************************
   bgimouse.pas - a quick (and maybe dirty) program that attaches a mouse
                  handler to the Microsoft mouse driver to provide hands-free
                  (interrupt driven) graphics cursor movement.

                  It should work with all BGI drivers, in all graphics modes.
                  It works better (less flicker) with our 16 Super VGA drivers
                  since our getimage/putimage routines are faster.

                  It is useful when using extended VGA modes (as with our
                  Super VGA BGI drivers) where the Microsoft graphics mouse
                  cursor CANNOT be used.

   Compile it as-is to see it work with Borland's BGI drivers
		  ...or if you have a fancy VGA card...
   See comments in main() on how to use our BGI driver with this program.

Written by:
Reagan Thomas  CIS: 73520,2067

Thomas Design
P.O. Box 586
Stillwater, OK 74076


NOTE:  1) When using the mouse handler, it's a always good idea to say
		HideMouse := 1;
		when doing a lot of graphics drawing.

   Thanks to Hue Nguyen of Train Track for porting this from C to Pascal.

*****************************************************************************}

program bgimouse;
uses dos, crt, graph, is16det;

{ gm 910112A - changed   test : integer; to   test : Word; b/c AX is Word }

const
   MOVED     : byte = $01;
   L_PRESS   : byte = $02;
   L_RELEASE : byte = $04;
   R_PRESS   : byte = $08;
   R_RELEASE : byte = $10;
   M_PRESS   : byte = $20;
   M_RELEASE : byte = $40;


var
   Graphdriver, Graphmode,
   MaxX, MaxY, ssize, errorcode : integer;
   MouseBtn, MouseX, MouseY, Mask,
   OldMX, OldMY, OldButt, x, y  : word;
   MouseEvent, HideMouse        : byte;
   XMofs, YMofs, OldxO, OldyO, count   : integer;
   screen, iptr, hue             : pointer;
   ttt                          : boolean;
   OldSeg, OldOffs, OldMask     : Word;

{ ----------------------------------------------------------------------- }
procedure gfxmousehandler(Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP : word);
interrupt;
var
   a, b, c, d : word;
   scr, itr : pointer;

begin
   itr:= ptr(memw[$0:$3f8], memw[$0:$3fa]);
   scr:= ptr(memw[$0:$3fc], memw[$0:$3fe]);
   a:= AX;
   b:= BX;
   c:= CX;
   d:= DX;
   OldMX:= MouseX;
   OldMY:= MouseY;
   OldButt:= MouseBtn;
   MouseEvent:= MouseEvent or a;
   MouseBtn:= b;
   MouseX:= c;
   MouseY:= d;
   if HideMouse = 0 then begin
      if (MouseX <> OldxO) or (MouseY <> OldyO) then begin
         putimage(OldxO, OldyO, Screen^, COPYPUT);
         getimage(MouseX, MouseY, MouseX+XMofs, MouseY+YMofs, screen^);
         putimage(MouseX, MouseY, iptr^, ORPUT);
         OldxO:= MouseX;
         OldyO:= MouseY;
         end;
      end;
{      for a:= 0 to 4000 do begin
        memw[$a000:a]:= random(256);
        memw[$a000:a+$2000]:= random(256);
        end; }
   inline (
           $8B/ $E5/ $5D/ $07/ $1F/ $5F/ $5E/ $5A/ $59/
           $5B/ $58/ $CB
          );
end;
{ ----------------------------------------------------------------------- }

{                 Initialize the mouse driver                             }
function init_mouse : boolean;
var
   test : WORD;     { gm - was   integer; }
   regs : registers;
begin
   with regs do begin
      AX:= 0;
      Intr($33, regs);
      test:= AX;
      if test = 0 then
         init_mouse:= false
      else
         init_mouse:= true;
      end;
end;
{ ----------------------------------------------------------------------- }
{               Enable the text mode mouse cursor                         }
{ ----------------------------------------------------------------------- }
procedure mouse_cursor;
var
   regs : registers;
begin
   regs.AX:= 1;
   Intr($33, regs);
end;
{ ----------------------------------------------------------------------- }
{               Disable the text mode mouse cursor                        }
{ ----------------------------------------------------------------------- }
procedure disable_cursor;
var
   regs : registers;
begin
   regs.AX:= 2;
   Intr($33, regs);
end;
{ ----------------------------------------------------------------------- }
{           Return the current status of the mouse                        }
{ ----------------------------------------------------------------------- }
procedure read_mouse(var mousex, mousey, button : integer);
var
   regs : registers;
begin
   regs.AX:= 3;
   Intr($33, regs);
   with regs do begin
      Button:= BX and 3;
      MouseX:= CX;
      MouseY:= DX;
      end;
end;
{ ----------------------------------------------------------------------- }
{                       Set the mouse XY count                            }
{ ----------------------------------------------------------------------- }
procedure move_mouse(mousex, mousey : integer);
var
   regs : registers;
begin
   with regs do begin
      AX:= 4;
      CX:= MouseX;
      DX:= MouseX;
      end;
   Intr($33, regs);
end;
{ ----------------------------------------------------------------------- }
{                          Set the mouse XY speed                         }
{ ----------------------------------------------------------------------- }
procedure mouse_speed(speed : integer);
var
   regs : registers;
begin
   with regs do begin
      AX:= $0013;
      DX:= speed;
      end;
   Intr($33, regs);
end;
{ ----------------------------------------------------------------------- }
{                       Set limits for mouse counts                       }
{ ----------------------------------------------------------------------- }
procedure mouse_range(xmin, ymin, xmax, ymax : integer);
var
   regs : registers;
begin
   with regs do begin
      AX:= 7;
      CX:= xmin;
      DX:= xmax;
      Intr($33, regs);
      AX:= 8;
      CX:= ymin;
      DX:= ymax;
      Intr($33, regs);
      end;
end;
{ ----------------------------------------------------------------------- }
{              Set the ratio of X to Y mouse counts                       }
{ ----------------------------------------------------------------------- }
procedure mouse_ratio(xaxis, yaxis : integer);
var
   regs : registers;
begin
   with regs do begin
      AX:= $000f;
      CX:= xaxis;
      DX:= yaxis;
      end;
   Intr($33, regs);
end;
{ ----------------------------------------------------------------------- }
{  Installs the mouse handler by hooking into the Microsoft driver        }
{ ----------------------------------------------------------------------- }
procedure InstallMouseHandler(mask, taskSeg, taskOfs : word);
var
   regs : registers;
begin
   with regs do begin
      AX:= 20;
      CX:= mask;
      DX:= taskOfs;
      ES:= taskSeg;
      Intr($33, regs);
      end;
end;







{ ----------------------------------------------------------------------- }
  var Error : integer;

begin
   if init_mouse = false then begin
      writeln('MOUSE DRIVER NOT ACTIVE!!!');
      halt(1)
      end;

 { ***************** How to do Super VGA ******************

  If you would like to try our Super VGA 16 color integrated driver...
    ...un-comment-out the following line.--

  -----------------------------------------
 |
 |  NOTE: This driver (ISVGA16.BGI)
 |  supports 16 color modes from 640x400 to 1024x786 on the following VGA
 |  cards: ATI, Techmar, Video7 VRAM, Paradise, Orchid, cards using the
 |  Paradise chipset, the Tseng Labs chipset, the Trident chipset, and those
 |  using the Chips and Tech chipset.
 |  The first five cards listed will autodetect(), but for the others, you
 |  may have the 'force' the driver to be active.  To force the driver, replace
 |  the line:
 |
 |  GraphDriver := DETECT;
 |       with
 |  GraphDriver := 11;  ( or GraphDriver := 16; for TP 6.0 & later )
 |      and add
 |  GraphMode := xxx16_800x600;
 |                     (where xxx16_800x600 is a constant from ISVGA16.PAS)
 |-----
      \/                     }

   GraphDriver := installuserdriver('ISVGA16',@_DetectISVGA16);

   GraphDriver := DETECT;


{ gm 910112A }
{$ifdef AtiMode}
   GraphDriver := 16;  { 11 or GraphDriver := 16; for TP 6.0 & later }
   GraphMode := ATI16_800x600;
        { where xxx16_800x600 is a constant from ISVGA16.PAS }
{$endif}

   InitGraph(GraphDriver, GraphMode ,'');
  Error := GraphResult;
  if Error <> grOK then             { if SVGA driver not available, error! }
  begin
     Writeln('Graphics error: ', GraphErrorMsg(Error));
     Halt(1);
  end;

   MaxX := getmaxx;
   MaxY := getmaxy;
   Hidemouse:= 0;

   mouse_speed(10);
   mouse_ratio(8,15);
   disable_cursor;
   mouse_range(0, 0, MaxX, MaxY);
   move_mouse(80,80);

{                  Draw the pointer                     }
   moveto(26, 36);	lineto(26, 52);
   lineto(30, $33);	lineto(31, 55);
   lineto(36, 54);	lineto(34, 49);
   lineto(37, 47);	lineto(26, 36);

   ssize  := imagesize(26, 36, 37, 55);    { reserve space for getimage() }
   getmem(iptr,ssize);
   getmem(screen,ssize);

   getimage(26, 36, 37, 55, iptr^);        { 'get' the pointer icon       }
   getimage(100, 100, 111, 119, screen^);  { 'get' some blank screen...   }
   putimage(26, 36, screen^, COPYPUT);     { ...and cover up the icon     }

{   mem[$0:$3f8]:= SEG(iptr);
   mem[$0:$3fa]:= OFS(iptr);
   mem[$0:$3fc]:= SEG(screen);
   mem[$0:$3fe]:= OFS(screen);  }

   XMofs := 11;	YMofs := 19; { these vars specify icon size }
   OldxO := 26;	OldyO := 36; { tell my mouse handler where the icon was drawn }
   Mask:= 1;   { Cursor position changed }
   InstallMouseHandler(Mask, SEG(gfxmousehandler), OFS(gfxmousehandler));

   HideMouse := 1;    { don't update the mouse while drawing text }

   outtextxy(0,60, 'Go ahead and move the mouse - press a key to quit');
   outtextxy(0,80, 'The cursor movement is interrupt driven, NOT polled');
   outtextxy(0,100,'--> For more info and to use Super VGA 800x600, see source <--');
   outtextxy(0,140,'    Written in C by Reagan Thomas, CIS: 73520,2067');
   outtextxy(0,155,'Ported to Pascal by Hue Nguyen,    CIS: 76334,2647');

   HideMouse := 0;    { OK, show the mouse now }

   while not keypressed do { loop til key pressed, mouse handler does the rest! }
      begin
      end;
   freemem(iptr,ssize);
   freemem(screen,ssize);
   InstallMouseHandler(OldMask, OldSeg, OldOffs);

   ttt:= init_mouse;
   restorecrtmode;
   closegraph;
end.
