%TITLE "Compare any two variables from TP"

;-----------------------------------------------------------------------;
;                                                                       ;
;  PURPOSE :    This assembly PROC will compare ANY two variable        ;
;               declared in in the calling program.  This PROC follows  ;
;               the Turbo Pascal calling conventions.                   ;
;                                                                       ;
;  SYSTEM  :  IBM PS/2 Model 30/286                                     ;
;                                                                       ;
;  AUTHOR  :  Thomas E. Jenkins, Jr.                                    ;
;                                                                       ;
;-----------------------------------------------------------------------;

                .MODEL TPascal

                .CODE

;---------------  Insert PUBLIC code declarations here

                PUBLIC    Compare

%NEWPAGE
;---------------------------------------------------------------;
;--  FUNCTION comapre ( VAR var1                 ;            --;
;--                     VAR var2                 ;            --;
;--                         strng                : BOOLEAN ;  --;
;--                         count                : WORD )     --;
;--                                              : INTEGER    --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--   INPUT :                                                 --;
;--             var1    :  POINTER                            --;
;--                        - any VAR name                     --;
;--             var2    :  POINTER                            --;
;--                        - any VAR name                     --;
;--             strng   :  BOOLEAN                            --;
;--                           will skip length byte if true  --;
;--                        - FALSE for pascal or zero         --;
;--                        - TRUE  for pascal or non-zero     --;
;--             count   :  WORD                               --;
;--                        -  a non-zero value indicating the --;
;--                           number of bytes to compare.     --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--  RETURN:  -1 var1 < var2                                  --;
;--            0 var1 = var2                                  --;
;--            1 var1 > var2                                  --;
;--                                                           --;
;---------------------------------------------------------------;
;--                                                           --;
;--  EXAMPLE CALL FROM PASCAL:                                --;
;--                                                           --;
;--  eq := Compare ( str1 , str2 , TRUE , SizeOf ( str1 ) ) ; --;
;--                                                           --;
;---------------------------------------------------------------;

Compare PROC  FAR var1:DWORD,var2:DWORD,strng:BYTE,count:WORD

                LOCALS  @@

                cld                     ;Compare from begining

                mov     dx,ds           ;Save calling routine's ds

                lds     si,var1         ;Set to first  address
                les     di,var2         ;Set to second address

                mov     cx,count        ;Get # bytes to compare

                cmp     strng,0         ;String ?
                jz      @@NOTSTRING     ;No, comapre like normal

                dec     cx              ;Take one from str length
                inc     si              ;Skip length byte
                inc     di              ;Skip length byte

@@NOTSTRING:
                jcxz    @@EQUAL         ;Length > 0 ?
                                        ; if not, report that two zero length
                                        ; variables are equal.

                repe    cmpsb           ;Compare till one byte <> paired

                je      @@EQUAL         ;var1 = var2
                ja      @@ABOVE         ;var1 > var2

                mov     ax,0FFFFh       ;var1 < var2
                mov     ds,dx
                ret

@@ABOVE:
                mov     ax,00001h       ;Set var1 > var2
                mov     ds,dx           ;Restore ds
                ret

@@EQUAL:
                xor     ax,ax           ;Set var1 = var2
                mov     ds,dx           ;Restore ds
                ret

ENDP            Compare

ENDS            CODE

                END                     ; END OF SOURCE
