UNIT Files ;

                           INTERFACE

CONST
       FILE_POSITION_OUT_OF_RANGE                = 1 ;

CONST
       FILE_READ_ERROR                           = 2 ;

CONST
       FILE_WRITE_ERROR                          = 3 ;


VAR
       fileError                                 : WORD ;


 PROCEDURE   InsertRecord ( VAR f                : FILE ;
                            VAR buffer                  ;
                                position         : LONGINT ;
                                lRecL            : WORD ) ;

 PROCEDURE   DeleteRecord ( VAR f                : FILE ;
                                position         : LONGINT ;
                                lRecL            : WORD ) ;





                       IMPLEMENTATION


 PROCEDURE   InsertRecord ( VAR f                : FILE ;
                            VAR buffer                  ;
                                position         : LONGINT ;
                                lRecL            : WORD ) ;

VAR
       bytesToMove                               : LONGINT ;
       fSize                                     : LONGINT ;
       readPosition                              : LONGINT ;
       writePosition                             : LONGINT ;
       memBuf                                    : POINTER ;
       memBufSize                                : WORD ;
       toMove                                    : WORD ;
       numRead                                   : WORD ;
       numWritten                                : WORD ;
       maxBufferRecords                          : WORD ;
       lastLoop                                  : BOOLEAN ;
       quitLoop                                  : BOOLEAN ;

   BEGIN  {  InsertRecord  }

     fSize                             := FileSize ( f ) ;

     IF ( position > ( fSize / lRecL ) )
      THEN
       BEGIN

         fileError := FILE_POSITION_OUT_OF_RANGE ;

         Exit ;

       END ;  {  IF  }

     bytesToMove := ( fSize - ( position * lRecL ) ) ;

     memBufSize := MaxAvail ;
     maxBufferRecords := memBufSize DIV lRecL ;
     memBufSize := maxBufferRecords * lRecL ;
     GetMem ( memBuf , memBufSize ) ;

     IF ( bytesToMove <= memBufSize )
      THEN
       BEGIN

         Seek ( f , ( position * lRecL ) ) ;
         BlockRead ( f , memBuf^ , bytesToMove , numRead ) ;
         IF ( numRead < bytesToMove )
          THEN
           BEGIN

             fileError := FILE_READ_ERROR ;

             Exit ;

           END ;  {  IF  }

         Seek ( f , ( ( position + 1 ) * lRecL ) ) ;
         BlockWrite ( f , memBuf^ , bytesToMove , numWritten ) ;

         IF ( numWritten < bytesToMove )
          THEN
           BEGIN

             fileError := FILE_WRITE_ERROR ;

             Exit ;

           END ;  {  IF  }

       END   {  THEN  }

      ELSE
       BEGIN

         readPosition := ( fSize DIV lRecL ) - maxBufferRecords ;
         writePosition := readPosition + 1 ;

         lastLoop := FALSE ;
         quitLoop := FALSE ;
         toMove   := memBufSize ;

         REPEAT

           IF ( lastLoop )
            THEN
               quitLoop := TRUE ;

           Seek ( f , readPosition * lRecL ) ;
           BlockRead ( f , memBuf^ , toMove , numRead ) ;
           IF ( numRead < toMove )
            THEN
             BEGIN

               fileError := FILE_READ_ERROR ;

               Exit ;

             END ;  {  IF  }

           Seek ( f , writePosition * lRecL ) ;
           BlockWrite ( f , memBuf^ , toMove , numWritten ) ;
           IF ( numWritten < toMove )
            THEN
             BEGIN

               fileError := FILE_WRITE_ERROR ;

               Exit ;

             END ;  {  IF  }

           readPosition := readPosition - maxBufferRecords ;

           IF ( readPosition <= position )
            THEN
             BEGIN

               toMove := ( writePosition - position - 1 ) * lRecL ;
               readPosition := position ;
               lastLoop := TRUE ;

             END ;  {  IF  }

           writePosition := readPosition + 1 ;

         UNTIL ( quitLoop ) ;

       END ;  {  ELSE  }

     FreeMem ( memBuf , memBufSize ) ;

     Seek ( f , ( position * lRecL ) ) ;
     BlockWrite ( f , buffer , lRecL , numWritten ) ;

     IF ( numWritten < lRecL )
      THEN
       BEGIN

         fileError := FILE_WRITE_ERROR ;

         Exit ;

       END ;  {  IF  }

   END ;  {  InsertRecord  }





 PROCEDURE   DeleteRecord ( VAR f                : FILE ;
                                position         : LONGINT ;
                                lRecL            : WORD ) ;

VAR
       bytesToMove                               : LONGINT ;
       fSize                                     : LONGINT ;
       readPosition                              : LONGINT ;
       writePosition                             : LONGINT ;
       memBuf                                    : POINTER ;
       memBufSize                                : WORD ;
       toMove                                    : WORD ;
       numRead                                   : WORD ;
       numWritten                                : WORD ;
       maxBufferRecords                          : WORD ;
       lastLoop                                  : BOOLEAN ;
       quitLoop                                  : BOOLEAN ;

   BEGIN  {  DeleteRecord  }

     fSize                             := FileSize ( f ) ;

     IF ( ( position + 1 ) > ( fSize / lRecL ) )
      THEN
       BEGIN

         fileError := FILE_POSITION_OUT_OF_RANGE ;

         Exit ;

       END ;  {  IF  }

     bytesToMove := ( fSize - ( ( position + 1 ) * lRecL ) ) ;

     memBufSize := MaxAvail ;
     maxBufferRecords := memBufSize DIV lRecL ;
     memBufSize := maxBufferRecords * lRecL ;
     GetMem ( memBuf , memBufSize ) ;

     IF ( bytesToMove <= memBufSize )
      THEN
       BEGIN

         Seek ( f , ( ( position + 1 ) * lRecL ) ) ;
         BlockRead ( f , memBuf^ , bytesToMove , numRead ) ;
         IF ( numRead < bytesToMove )
          THEN
           BEGIN

             fileError := FILE_READ_ERROR ;

             Exit ;

           END ;  {  IF  }

         Seek ( f , ( position * lRecL ) ) ;
         BlockWrite ( f , memBuf^ , bytesToMove , numWritten ) ;

         IF ( numWritten < bytesToMove )
          THEN
           BEGIN

             fileError := FILE_WRITE_ERROR ;

             Exit ;

           END ;  {  IF  }

          END   {  THEN  }

      ELSE
       BEGIN

         readPosition := ( position + 1 ) ;
         writePosition := position ;

         lastLoop := FALSE ;
         quitLoop := FALSE ;
         toMove   := memBufSize ;

         REPEAT

           IF ( lastLoop )
            THEN
               quitLoop := TRUE ;

           Seek ( f , readPosition * lRecL ) ;
           BlockRead ( f , memBuf^ , toMove , numRead ) ;
           IF ( numRead < toMove )
            THEN
             BEGIN

               fileError := FILE_READ_ERROR ;

               Exit ;

             END ;  {  IF  }

           Seek ( f , writePosition * lRecL ) ;
           BlockWrite ( f , memBuf^ , toMove , numWritten ) ;
           IF ( numWritten < toMove )
            THEN
             BEGIN

               fileError := FILE_WRITE_ERROR ;

               Exit ;

             END ;  {  IF  }

           readPosition := readPosition + maxBufferRecords ;

           IF ( readPosition >= ( fSize DIV lRecL ) )
            THEN
               quitLoop := TRUE ;

           IF ( readPosition + maxBufferRecords >= ( fSize DIV lRecL ) )
            THEN
             BEGIN

               toMove := fSize - ( readPosition * lRecL ) ;
               lastLoop := TRUE ;

             END ;  {  IF  }

           writePosition := readPosition - 1 ;

         UNTIL ( quitLoop ) ;

       END ;  {  ELSE  }

     FreeMem ( memBuf , memBufSize ) ;

     Seek ( f , ( fSize - lRecL ) ) ;
     Truncate ( f ) ;

   END ;  {  DeleteRecord  }






BEGIN

  fileError := 0 ;    {  no error yet  }

END .