Program IconEd;

uses
   Graph, Crt, MousePac;
const
   BigIconLeft = 20;
   BigIconTop  = 50;
   BigBitSize  = 8;
	IconWidth   = 16;
	IconHeight  = 16;
	IconLeft    = 280;
	IconTop     = 280;
var
   BigBit: pointer;
   Icon: array[1..IconHeight,1..IconWidth] of byte;
   x,y,i,j,c: integer;
   ch: char;
   t: boolean;

procedure InitBigBit;
var
   bbx,bby,i,j: integer;

begin
   bbx := BigIconLeft;
   bby := BigIconTop;
   HideMouse;
   for j:= bby+1 to bby+BigBitSize do
      begin
         for i := bbx+1 to bbx+2*BigBitSize do
            PutPixel(i,j,GetMaxColor);
      end;

   GetMem(BigBit,ImageSize(bbx,bby,bbx+2*BigBitSize,bby+BigBitSize));
   GetImage(bbx+1,bby+1,bbx+2*BigBitSize,bby+BigBitSize,BigBit^);
   PutImage(bbx+1,bby+1,BigBit^,XorPut);
   ShowMouse;
end;

procedure DrawEnlargedIcon;
var
   i: integer;
   Right, Bottom: integer;

begin
   SetLineStyle(Dottedln,0,NormWidth);
   Right := 2*(BigIconLeft+(IconWidth-1)*(BigBitSize+NormWidth));
   Bottom := BigIconTop+IconHeight*(BigBitSize+NormWidth);
   HideMouse;
   for i := 0 to IconHeight do
      Line(BigIconLeft,BigIconTop+i*(BigBitSize+NormWidth),Right,
           BigIconTop+i*(BigBitSize+NormWidth));
   for i := 0 to IconWidth do
      Line(BigIconLeft+2*(i*(BigBitSize+NormWidth)),BigIconTop,
           BigIconLeft+2*(i*(BigBitSize+NormWidth)),Bottom);
   ShowMouse;
   InitBigBit;
end;

procedure ToggleIconsBit(x,y: integer);
begin
   HideMouse;
	if GetPixel(2*x+IconLeft, IconTop+y) <> Black then
      begin
			PutPixel(2*x+IconLeft, IconTop+y, Black);
			PutPixel(2*x+1+IconLeft, IconTop+y, Black);
         Icon[y][x] := 0;
      end
   else
      begin
			PutPixel(2*x+IconLeft, IconTop+y, GetMaxColor);
			PutPixel(2*x+1+IconLeft, IconTop+y, GetMaxColor);
         Icon[y][x] := 1;
      end;
   ShowMouse;
end;

procedure ToggleBigBit(x,y: integer);
var
   bbx,bby,i,j: integer;
   line1,line2,col1,col2: integer;

begin
   for j := 1 to IconHeight do
      begin
         line1 := BigIconTop+(j-1)*(BigBitSize+NormWidth);
         line2 := BigIconTop+j*(BigBitSize+NormWidth);
         if (line1<=y) AND (y<line2) then
            begin
               for i:= 1 to IconWidth do
                  begin
                     col1 := BigIconLeft+2*((i-1)*(BigBitSize+NormWidth));
                     col2 := BigIconLeft+2*(i*(BigBitSize+NormWidth));
                     if (col1<=x) AND (x<col2) then
                        begin
                           HideMouse;
                           PutImage(col1+1,line1+1,BigBit^,XorPut);
                           ShowMouse;
                           ToggleIconsBit(i,j);
                        end
                  end
            end
      end
end;

procedure SaveIcon;
var
   FileName: string;
   IconFile: text;
   i,j: integer;

begin
   writeln;
   write('Enter the name of the file you want to');
   write(' store the icon in: ');
   readln(FileName);
   {$I-} Assign(IconFile,FileName);
   Rewrite(IconFile);  {$I+}
   if NOT (IOResult = 0) then
      begin
         CloseGraph;
         writeln('Cannot open file.');
         halt(1);
      end
   else
      begin
         writeln(IconFile, IconWidth, ' ', IconHeight);
         for j := 1 to IconHeight do
            begin
               for i := 1 to IconWidth do
                  write(IconFile, Icon[j][i], ' ');
               writeln(IconFile);
            end;
         Close(IconFile);
      end;
end;

procedure ReadIcon;
var
   FileName: string[80];
   ch: char;
   IconFile: text;
   i,j: integer;
   Width, Height: integer;

begin
   for j := 1 to IconHeight do
      begin
         for i := 1 to IconWidth do
            Icon[j][i] := 0;
      end;

   writeln;
   writeln;
   writeln('----------  Icon Editor --------');
   writeln;
   write('Do you want to edit an existing icon? (y) ');
   ch := ReadKey;
   if ch <> 'n' then
      begin
         writeln;
         write('Enter the name of the file to read the icon from: ');
         readln(FileName);
         {$I-}  Assign(IconFile,FileName);
         Reset(IconFile); {$I+}
         if NOT (IOResult = 0) then
            begin
               CloseGraph;
               writeln('Cannot open file.');
               halt(1);
            end;
         Readln(IconFile, Width, Height);
         if (Width <> IconWidth) OR (Height <> IconHeight) then
            begin
               writeln('Incompatible icon file.');
               halt(1);
            end
         else
            begin
               for j := 1 to IconHeight do
                  for i := 1 to IconWidth do
                     Read(IconFile, Icon[j][i]);
               Close(IconFile);
            end
      end
end;

procedure InitGraphics;
const
   GDriver: integer = Detect;
var
   GMode, GError: integer;

begin
   InitGraph(GDriver,GMode,'c:\tp\bgi');
   GError := GraphResult;
   if GError < 0 then
      begin
         writeln('Failed graphics initialization: GError=',GError);
         halt(1);
      end
end;

procedure ShowIcon;
var
   x,y: integer;

begin
   for y := 1 to IconHeight do
      for x := 1 to IconWidth do
         if Icon[y][x]=1 then
            begin
               PutImage(BigIconLeft+2*((x-1)*(BigBitSize+NormWidth))+1,
                  BigIconTop+(y-1)*(BigBitSize+NormWidth)+1,BigBit^,XorPut);
               ToggleIconsBit(x,y);
            end
end;

Begin
   ReadIcon;
   InitGraphics;
   t := InitMouse;
   DrawEnlargedIcon;
   ShowIcon;
   HideMouse;
   OutTextXY(BigIconLeft,10,'Press ESC when finished...');
   OutTextXY(BigIconLeft,BigIconTop-20,'Enlarged Icon');
	OutTextXY(IconLeft-40, IconTop-20,'Actual Icon');
   ShowMouse;
   c := WaitForInput(LeftButton);
   while c <> 27 do
      begin
         if c<0 then
            begin
               GetMouseCoords(x,y);
               ToggleBigBit(x,y);
            end;
         c := WaitForInput(LeftButton);
      end;
   HideMouse;
   CloseGraph;
   write('Do you want to save this icon to a file? (y) ');
   ch := ReadKey;
   if ch<>'n' then
      SaveIcon;
end.
