;===========================================================================
;
;    dta2PRN  -  Send a character to the printer
;
;===========================================================================
;
;
; Call from Turbo Pascal V4.0 using the
; {$L}/EXTERNAL procedure convention.
;
; Declare the procedure itself as external using this declaration:
;
; {$L dta2PRN }
; PROCEDURE dta2PRN; EXTERNAL;
;
; To reassemble/relink dta2PRN:
;-------------------------------------
; Assemble this file with MASM or TASM; i.e.  "C>TASM dta2PRN;"
;

CODE    SEGMENT BYTE PUBLIC
        ASSUME  CS:CODE
        PUBLIC  dta2PRN

dta2PRN   PROC    NEAR
          PUSH    BP                      ;SAVE PREVIOUS VALUE OF BP ON STACK
          MOV     BP,SP                   ;SP BECOMES NEW VALUE OF BP

ONSTACK   STRUC
OLDBP     DW ?
RETADDR   DW ?
BUFFERSZ  DW ?
BUFFERSEG DW ?
BUFFEROFS DW ?
ENDMARK   DB ?
ONSTACK   ENDS

; The size and the address of the buffer of characters is placed
;  on the stack.

          XOR     CX,CX                   ; 0 OUT CX
          MOV     CX,[BP].BUFFERSZ        ; CX HAS NUMBER OF CHARACTERS
                                          ;  IN THE BUFFER

          MOV     SI,[BP].BUFFEROFS       ; SI holds the offset...
          XOR     DX,DX                   ; 0 OUT DX (USE LPT1)

NEXT:     SEGSS                           ; POINT FROM SS
          LODSB                           ; LOAD AL WITH BYTE TO PRINT
          XOR     AH,AH                   ; BIOS FUNCTION 0 FOR INT 17h
          INT     17h                     ; CALL BIOS
          LOOP    NEXT                    ; GET NEXT CHARACTER


          MOV     SP,BP                   ; RESTORE PRIOR STACK POINTER & BP
          POP     BP                      ;  IN CONVENTIONAL RETURN
          RET     ENDMARK-RETADDR-2       ; Restore stack...


dta2PRN  ENDP
CODE      ENDS
          END
