program HotMod;

{  Turbo Pascal 5.0 Hot Key Modification Program.  Version 1.0  11/7/88  }
{  Copyright (c) 1988 Ron Schuster.  For non-commercial use only.  }

{  The cursor routines were extracted from CURSORS.PAS by Scott Bussinger.  The
   complete set can be downloaded from CompuServe. (BPROGA Lib 6 CURSOR.ARC)  }

uses Crt, Dos;

const
  NbrOfTables = 2;  {  Number of hot key assignment tables in TURBO.EXE  }
  TableBase : array [1..NbrOfTables] of LongInt = (136058, 136320);

type
  KeyStr = string[15];
  CursorSize = word;

  HotkeyRec = record
    Name : string[20];
    Offset : array [1..NbrOfTables] of Integer;
  end;

  KeyRec = record
    Name : KeyStr;
    Code : Byte;
  end;

const
  NbrOfHotkeys = 30;
  NbrOfRows = succ (NbrOfHotkeys) div 2;
  Hotkeys : array [1..NbrOfHotkeys] of HotkeyRec = (
    (Name: 'Break/watch menu'; Offset: (69, 81)),
    (Name: 'B/Add watch'; Offset: (72, 51)),
    (Name: 'B/Toggle breakpoint'; Offset: (63, 54)),
    (Name: 'Compile menu'; Offset: (33, 75)),
    (Name: 'Compile/Compile'; Offset: (24, 21)),
    (Name: 'Compile/Make'; Offset: (21, 18)),
    (Name: 'Debug menu'; Offset: (51, 84)),
    (Name: 'Debug/Call stack'; Offset: (81, 39)),
    (Name: 'Debug/Evaluate'; Offset: (60, 42)),
    (Name: 'Edit'; Offset: (-1, 69)),
    (Name: 'File menu'; Offset: (36, 66)),
    (Name: 'File/Load'; Offset: (12, 3)),
    (Name: 'File/Pick'; Offset: (42, 27)),
    (Name: 'File/Quit'; Offset: (15, 93)),
    (Name: 'File/Save'; Offset: (0, 6)),
    (Name: 'Help'; Offset: (-1, 57)),
    (Name: 'Last help'; Offset: (-1, 60)),
    (Name: 'Menu'; Offset: (27, 24)),
    (Name: 'Options menu'; Offset: (39, 78)),
    (Name: 'Run menu'; Offset: (30, 72)),
    (Name: 'Run/Go to cursor'; Offset: (66, 33)),
    (Name: 'Run/Program reset'; Offset: (78, 36)),
    (Name: 'Run/Run'; Offset: (75, 30)),
    (Name: 'Run/Step over'; Offset: (57, 48)),
    (Name: 'Run/Trace into'; Offset: (54, 45)),
    (Name: 'Run/User screen'; Offset: (48, 63)),
    (Name: 'Swap'; Offset: (18, 12)),
    (Name: 'Switch'; Offset: (9, 9)),
    (Name: 'Version screen'; Offset: (45, 0)),
    (Name: 'Zoom'; Offset: (6, 15)));

  NbrOfkeys = 103;
  KeyNames : array [1..NbrOfKeys] of KeyRec = (
    (Name: 'Alt0'; Code: 129),
    (Name: 'Alt1'; Code: 120),
    (Name: 'Alt2'; Code: 121),
    (Name: 'Alt3'; Code: 122),
    (Name: 'Alt4'; Code: 123),
    (Name: 'Alt5'; Code: 124),
    (Name: 'Alt6'; Code: 125),
    (Name: 'Alt7'; Code: 126),
    (Name: 'Alt8'; Code: 127),
    (Name: 'Alt9'; Code: 128),
    (Name: 'AltA'; Code: 30),
    (Name: 'AltB'; Code: 48),
    (Name: 'AltC'; Code: 46),
    (Name: 'AltD'; Code: 32),
    (Name: 'AltDash'; Code: 130),
    (Name: 'AltE'; Code: 18),
    (Name: 'AltEqual'; Code: 131),
    (Name: 'AltF'; Code: 33),
    (Name: 'AltF1'; Code: 104),
    (Name: 'AltF10'; Code: 113),
    (Name: 'AltF11'; Code: 139),
    (Name: 'AltF12'; Code: 140),
    (Name: 'AltF2'; Code: 105),
    (Name: 'AltF3'; Code: 106),
    (Name: 'AltF4'; Code: 107),
    (Name: 'AltF5'; Code: 108),
    (Name: 'AltF6'; Code: 109),
    (Name: 'AltF7'; Code: 110),
    (Name: 'AltF8'; Code: 111),
    (Name: 'AltF9'; Code: 112),
    (Name: 'AltG'; Code: 34),
    (Name: 'AltH'; Code: 35),
    (Name: 'AltI'; Code: 23),
    (Name: 'AltJ'; Code: 36),
    (Name: 'AltK'; Code: 37),
    (Name: 'AltL'; Code: 38),
    (Name: 'AltM'; Code: 50),
    (Name: 'AltN'; Code: 49),
    (Name: 'AltO'; Code: 24),
    (Name: 'AltP'; Code: 25),
    (Name: 'AltQ'; Code: 16),
    (Name: 'AltR'; Code: 19),
    (Name: 'AltS'; Code: 31),
    (Name: 'AltT'; Code: 20),
    (Name: 'AltU'; Code: 22),
    (Name: 'AltV'; Code: 47),
    (Name: 'AltW'; Code: 17),
    (Name: 'AltX'; Code: 45),
    (Name: 'AltY'; Code: 21),
    (Name: 'AltZ'; Code: 44),
    (Name: 'CtrlEnd'; Code: 117),
    (Name: 'CtrlF1'; Code: 94),
    (Name: 'CtrlF10'; Code: 103),
    (Name: 'CtrlF11'; Code: 137),
    (Name: 'CtrlF12'; Code: 138),
    (Name: 'CtrlF2'; Code: 95),
    (Name: 'CtrlF3'; Code: 96),
    (Name: 'CtrlF4'; Code: 97),
    (Name: 'CtrlF5'; Code: 98),
    (Name: 'CtrlF6'; Code: 99),
    (Name: 'CtrlF7'; Code: 100),
    (Name: 'CtrlF8'; Code: 101),
    (Name: 'CtrlF9'; Code: 102),
    (Name: 'CtrlHome'; Code: 119),
    (Name: 'CtrlLeftArrow'; Code: 115),
    (Name: 'CtrlPgDn'; Code: 118),
    (Name: 'CtrlPgUp'; Code: 132),
    (Name: 'CtrlRightArrow'; Code: 116),
    (Name: 'DelKey'; Code: 83),
    (Name: 'DownArrow'; Code: 80),
    (Name: 'EndKey'; Code: 79),
    (Name: 'F1'; Code: 59),
    (Name: 'F10'; Code: 68),
    (Name: 'F11'; Code: 133),
    (Name: 'F12'; Code: 134),
    (Name: 'F2'; Code: 60),
    (Name: 'F3'; Code: 61),
    (Name: 'F4'; Code: 62),
    (Name: 'F5'; Code: 63),
    (Name: 'F6'; Code: 64),
    (Name: 'F7'; Code: 65),
    (Name: 'F8'; Code: 66),
    (Name: 'F9'; Code: 67),
    (Name: 'Home'; Code: 71),
    (Name: 'InsKey'; Code: 82),
    (Name: 'LeftArrow'; Code: 75),
    (Name: 'PgDn'; Code: 81),
    (Name: 'PgUp'; Code: 73),
    (Name: 'RightArrow'; Code: 77),
    (Name: 'ShiftF1'; Code: 84),
    (Name: 'ShiftF10'; Code: 93),
    (Name: 'ShiftF11'; Code: 135),
    (Name: 'ShiftF12'; Code: 136),
    (Name: 'ShiftF2'; Code: 85),
    (Name: 'ShiftF3'; Code: 86),
    (Name: 'ShiftF4'; Code: 87),
    (Name: 'ShiftF5'; Code: 88),
    (Name: 'ShiftF6'; Code: 89),
    (Name: 'ShiftF7'; Code: 90),
    (Name: 'ShiftF8'; Code: 91),
    (Name: 'ShiftF9'; Code: 92),
    (Name: 'ShiftTab'; Code: 15),
    (Name: 'UpArrow'; Code: 72));

var
  Turbo : file of Byte;
  OriginalCursor: CursorSize;

function MonoDisplay: boolean;
  { Return true if the current display is a monochrome adapter }
  var Reg: Registers;
begin
  Reg.AH := $0F;
  Intr ($10, Reg);
  MonoDisplay := Reg.AL = 7
end;

procedure GetCursor (var Curs: CursorSize);
  { Get the current cursor size }
  var Reg: Registers;
begin
  Reg.AH := $03;
  Reg.BH := $00;
  Intr ($10, Reg);
  if (Reg.CX=$0607) and MonoDisplay
   then
    Curs := $0C0D                                { Watch out for bug in DOS }
   else
    Curs := Reg.CX
end;

procedure SetCursor (Curs: CursorSize);
  { Set the current cursor size }
  var Reg: Registers;
begin
  Reg.AH := $01;
  Reg.CX := Curs;
  Intr ($10, Reg)
end;

function KeyName (Key : Byte) : KeyStr;
{  Return the name of the key, given its key code  }
var
  S : KeyStr;
  I : Integer;
begin
  for I := 1 to NbrOfKeys do
    with KeyNames[I] do
      if Code = Key then begin
        KeyName := Name;
        Exit;
      end;
  Str (Key, S);  { If Key value not found in table }
  KeyName := S;  { use the number as the name }
end;

function Pad (S : String; Len : Integer) : String;
{  Pad the string S out to length Len with spaces  }
begin
  while Length (S) < Len do
    S := S + ' ';
  Pad := S;
end;

procedure NormalVideo;
begin
  if MonoDisplay then begin
    TextColor (White);
    TextBackground (Black);
  end
  else begin
    TextColor (LightGray);
    TextBackground (Blue);
  end;
end;

procedure ReverseVideo;
begin
  if MonoDisplay then begin
    TextColor (Black);
    TextBackground (LightGray);
  end
  else begin
    TextColor (White);
    TextBackground (Black);
  end;
end;

procedure DisplayHotkey (I : Integer);
{  Display the name and current key assignment of the hot key }
var
  B : Byte;
begin
  with Hotkeys[I] do begin
    B := 1;
    while (Offset[B] = -1) do
      Inc (B);
    Seek (Turbo, TableBase[B] + Offset[B]);
    Read (Turbo, B);
    GotoXY (40 * (pred (I) div NbrOfRows) + 1,
            pred (I) mod NbrOfRows + 7);
    Write (Pad (Name, 25), Pad (Keyname (B), 15));
  end;
end;

procedure DisplayMenu;
var
  I : Integer;
begin
  TextColor (Black);
  TextBackground (LightGray);
  ClrScr;
  Writeln ('HOTMOD - The Turbo Pascal 5.0 Hot Key Modifier.  Version 1.0.');
  Writeln ('Copyright (c) 1988 Ron Schuster.  For non-commercial use only.');
  Writeln ('Move the cursor to the hot key that you want to change.');
  Writeln ('Press the key that you want to change it to.');
  Writeln ('Press Esc to save your changes and exit.');
  NormalVideo;
  for I := 1 to NbrOfHotkeys do
    DisplayHotkey (I);
end;

function Read_Key : Word;
var
  Key : Char;
begin
  Key := ReadKey;
  if Key = #0 then begin
    Key := ReadKey;
    Read_Key := word (ord (Key)) shl 8;
  end
  else
    Read_Key := ord (Key);
end;

procedure MakeChanges;
const
  Esc = 27;
  UpArrow = 72;
  DownArrow = 80;
  LeftArrow = 75;
  RightArrow = 77;
var
  Sel : Integer;
  I : Integer;
  Key : Word;
  Done : Boolean;
  HiKey : Byte;

  procedure ChangeSelection (New : Integer);
  begin
    NormalVideo;
    DisplayHotkey (Sel);
    Sel := New;
    ReverseVideo;
    DisplayHotkey (Sel);
  end;

begin  {MakeChanges}
  Sel := 1;
  ReverseVideo;
  DisplayHotkey (1);
  Done := False;
  repeat
    Key := Read_Key;
    case Lo (Key) of
      0: case Hi (Key) of
           UpArrow: if Sel > 1 then
                      ChangeSelection (pred (Sel));
           DownArrow: if Sel < NbrOfHotkeys then
                        ChangeSelection (succ (Sel));
           LeftArrow: if Sel > NbrOfRows then
                        ChangeSelection (Sel - NbrOfRows);
           RightArrow: if Sel <= NbrOfRows then
                        ChangeSelection (Sel + NbrOfRows);
           else begin
             with Hotkeys[Sel] do
               for I := 1 to NbrOfTables do
                 if Offset[I] <> -1 then begin
                   Seek (Turbo, TableBase[I] + Offset[I]);
                   HiKey := Hi (Key);
                   Write (Turbo, HiKey);
                 end;
             DisplayHotkey (Sel);
           end;
         end; {case Hi (Key)}
      Esc: Done := True;
      else Write (^G);
    end; {case Lo (Key)}
  until Done;
end;  {MakeChanges}

procedure OpenTurbo;
{$I-}
var
  IO_result : Word;
begin
  Assign (Turbo, 'TURBO.EXE');
  Reset (Turbo);
  IO_result := IOresult;
  if IO_result <> 0 then begin
    Writeln ('Could not open TURBO.EXE');
    Writeln ('IOresult = ', IO_result);
    Halt (1);
  end;
  if FileSize (Turbo) <> 149793 then begin
    Writeln ('Incorrect version of Turbo Pascal');
    Halt (2);
  end;
end;

begin { main program }
  OpenTurbo;
  GetCursor (OriginalCursor);
  SetCursor ($2000);  { Make the cursor invisible }
  DisplayMenu;
  MakeChanges;
  SetCursor (OriginalCursor);
  NormVideo;
  ClrScr;
  Close (Turbo);
end.
