Program ListTest;    {by Kurt Herzog, 10/16/93}
                     {Tests the HListBox Unit }

{NOTICE:  I make no claims to or for this code- use it at your   }
{         own risk.  I hope that it will save someone the several}
{         hours I spent learning how to make it work!  If (when!)}
{         you find any bugs or ways to improve it (surely there  }
{         are some) please send me the changes so we will each   }
{         have learned something.                                }
{          - -  Kurt Herzog     CompuServe 72122,2023            }

{$X+}     {Extended Syntax}

(*$R LISTTEST.RES*)

Uses
  HListBox,              {Horizontal-scroll List Box Unit}
  {.....General purpose Units}
  Strings,               {Nul-terminated string support}
  WinTypes,              {Defines Windows API for Pascal}
  WinProcs,              {Defines Func/Proc headers for API}
  CommDlg,               {Windows' common dialogs}
  {.....ObjectWindows Units}
  Objects,               {Collections & Streams}
  ODialogs,              {Basic ObjectWindows Unit}
  OWindows;              {Basic ObjectWindows Unit}

const
  {control IDs for Main Dialog Window}
  id_List  = 101;   {Listbox}
  id_Edit  = 102;   {Edit input strings}
  id_Add   = 103;   {Add-a-string button}
  id_Drop  = 104;   {Delete-a-string button}
  id_Clear = 105;   {Clear the Listbox button}
  id_Font  = 106;   {Change Listbox font button}
  id_Count = 107;   {Static Text control for Listbox item count}

{- - - - - - -   Define Application Object Type   - - - - - - - }

Type
  TestApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{- - - - - - -   Define Window Object Type   - - - - - - - - - -}

  PTestWindow = ^TestWindow;
  TestWindow = object(TDlgWindow)
    ListBox   : PHListBox;     {Listbox}
    ListBoxXfr : record        {Transfer Buffer for Listbox}
      Strings  : PStrCollection;
      Selection: Integer;
      end;
    EditStr   : PEdit;         {Edit input strings}
    Count     : PStatic;       {Static Text control item count}
    LogFont   : TLogFont;      {TLogFont structure for ChooseFont}
    Font      : hFont;         {Handle to the font selected}
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor  Done; virtual;
    procedure   SetupWindow; virtual;
    procedure   IDAdd (Var msg : TMessage);
                  virtual id_First + id_Add;
    procedure   IDDrop (Var msg : TMessage);
                  virtual id_First + id_Drop;
    procedure   IDClear (Var msg : TMessage);
                  virtual id_First + id_Clear;
    procedure   IDFont (Var msg: TMessage);
                  virtual id_First + id_Font;
    procedure   Cancel (Var msg : TMessage);
                  virtual id_First + id_Cancel;
    procedure   PostItemCount;
  end; 

{- - - - - - -   Initialize the Window Object  - - - - - -}
constructor TestWindow.Init(AParent: PWindowsObject; ATitle: PChar);
begin
	Inherited Init(AParent, ATitle);
  Font := 0;   {Initial font will be the dialog default}
  FillChar(LogFont,SizeOf(LogFont),Chr(0));
  {Create OWL control objects for Edit, Listbox, Static Text}
  EditStr := New(PEdit,InitResource(@Self, id_Edit, 0));
  ListBox := New(PHListBox,InitResource(@Self, id_List));
  Count := New(PStatic,InitResource(@Self, id_Count, 3));
  {Create Transfer Buffer string collection of 50 items for Listbox}
  ListBoxXfr.Strings := New(PStrCollection,Init(50,10));
end;

{- - - - - - -   Destroy the Window Object   - - - - - -  -}
destructor TestWindow.Done;
begin
  {Dispose the Listbox transfer buffer string collection}
  Dispose (ListBoxXfr.Strings, Done);
  {Delete font object if one exists}
  if Font <> 0 then DeleteObject(Font);
  Inherited Done;   {call ancestral Done to clean-up}
end;

{- - - - - -  Setup Window  - - - - - - - - - - - - - - - -}
procedure TestWindow.SetupWindow;
begin
  Inherited SetupWindow;
  {Add 4 witty strings to the Listbox transfer buffer collection}
  With  ListBoxXfr.Strings^ do
    begin
      Insert(StrNew('A string'));
      Insert(StrNew('Another string'));
      Insert(StrNew('A slightly longer string'));
      Insert(StrNew('A very much longer string than any other'));
    end;
  {Transfer the Transfer Buffer to the Listbox}
  {and go Post the item count.}
  ListBox^.Transfer(@ListBoxXfr,tf_SetData);
  PostItemCount;
end;

procedure TestWindow.IDAdd (Var msg : TMessage);
var
  NewItem     : Pchar;
  NewItemSize : Integer;

begin with EditStr^, ListBox^ do begin
  {Get the size of the string in the Edit control and           }
  {allocate memory to hold it.  Retrieve the string and         }
  {add it to the Listbox, then free the memory.                 }
  NewItemSize := GetTextLen +1;  {leave room for null-terminator}
  if NewItemSize > 1 then        {Length=1 means 0-length string}
    begin
      GetMem(NewItem,NewItemSize);
      if NewItem <> nil then
        begin
          GetText(NewItem, NewItemSize);
          AddString(NewItem);
          PostItemCount;
          FreeMem(NewItem,NewItemSize);
        end;
    end
  else MessageBeep(0);   {Signal Error if no string}
end; end;  {with EditStr^, ListBox^}

procedure TestWindow.IDDrop (Var msg : TMessage);
var
  Item : Integer;

begin with ListBox^ do begin  {Delete the selected string}
  Item := GetSelIndex;
  if Item >= 0 then
    begin
      Item :=  DeleteString(Item);
      PostItemCount;
    end
  else Messagebeep(0);   {Signal Error if no string}
end; end;

procedure TestWindow.IDClear (Var msg : TMessage);
begin with ListBox^ do begin
  ClearList;
  PostItemCount;
end; end;

procedure TestWindow.IDFont (Var msg: TMessage);
  var
    CFStruct : TChooseFont;

  begin with CFStruct do
    begin
      FillChar(CFStruct,SizeOf(CFStruct),Chr(0));
      lStructSize := SizeOf(CFStruct); {Housekeeping}
      hWndOwner := HWindow;            {main window handle}
      Flags := cf_ScreenFonts          {Use Screen fonts only}
        or cf_InitToLogFontStruct;     {Remembers previous font}
      lpLogFont := @LogFont;           {pointer to LOGFONT struct }
      if ChooseFont(CFStruct) then     {Call Common Dialog}
        begin
          {Delete any previous font object, create new font}
          {then tell listbox to change font & redraw itself}
          if Font <> 0 then DeleteObject(Font);
          Font := CreateFontIndirect(lpLogFont^);
          ListBox^.ChangeFont(Font);
        end;
    end; {with CFStruct}
  end;

procedure TestWindow.Cancel (Var msg : TMessage);
begin
  CloseWindow;   {Wrap-up and go home}
end;

procedure TestWindow.PostItemCount;
var
  Number : array[0..6] of Char;

begin
  {Get current count of Listbox items & display}
  Str(ListBox^.GetCount,Number);
  Count^.SetText(Number);
end;


{- - - - - - -  APPLICATION OBJECT METHODS  - - - - - - - }
{Initialize the Application Window}
procedure TestApplication.InitMainWindow;
  begin
    MainWindow := New(PTestWindow, Init(nil, 'ListTest'));
  end;

{ - - - -  MAIN BODY OF PROGRAM  - - - - }

var
  TestApp: TestApplication;

begin
  TestApp.Init('ListTest');
  TestApp.Run;
  TestApp.Done;
end.