Unit HiBack;
{ Public Domain by                                                       }
{ David Rolston, 1991                                                    }
{ CIS: 72267,2150                                                        }
Interface

procedure HiBackCGA(On : Boolean);
Procedure HiBackEGA(On : Boolean);

Implementation

uses
  Dos;

procedure HiBackCGA(On : Boolean);
var
  CurrentMode : Byte;
begin
  CurrentMode := Mem[$0040:$0065];
  if On then 
    CurrentMode := CurrentMode and $0DF
  else
    CurrentMode := CurrentMode or $20;
  Mem[$0040:$0065] := CurrentMode;
  { This addresses the CGA Card.  Port 3D8 is the Output Mode Register
    with the following bit settings:
      B0 = 80x25 Mode
      B1 = 320x200 Graphics
      B2 = B & W Mode
      B3 = Enable Video
      B4 = 640x200 B & W
      B5 = Blinking !
      B6,
      B7 = Not Used

    There is also an Output Color Register with the settings:
      B0 = Blue
      B1 = Green
      B2 = Red
      B3 = Intensify RGB
      B4 = Alt Back Colors
      B5 = 320x200 Color Set
      B6,
      B7 = Not Used }
  Port[$03D8] := CurrentMode;
end;

Procedure HiBackEGA(On : Boolean);
{Uses BIOS call EGA, VGA, MCGA Set Palette Registers}
const
  IntNum = $10;
var
  Regs : Registers;
begin
  Regs.AX := $1003;
  if On then
    Regs.BL := 0      
  else
    Regs.BL := 1;
  Intr(IntNum, Regs);
end;

end.
