
UNIT Hexx;

Interface
TYPE
  string2 = STRING[2];
  string4 = STRING[4];
  string9 = String[9];

CONST
  HexDigit : ARRAY[0..15] OF Char = '0123456789ABCDEF';

  FUNCTION HexByte(B : Byte) : string2;
  FUNCTION HexW(I : Word) : string4;
  Function HexPtr(P : Pointer) : String9;

 Implementation

  FUNCTION HexByte(B : Byte) : string2;
  BEGIN
    HexByte := HexDigit[B SHR 4]+HexDigit[B AND $F];
  END;

  FUNCTION HexW(I : Word) : string4;
  BEGIN
    HexW := HexByte(Hi(I))+HexByte(Lo(I));
  END;

  Function HexPtr(P : Pointer) : String9;
  Var

   L : String4;
	H : String4;

  Begin
	If P = Nil then HexPtr := 'NIL      '
	else
	Begin
      L := HexW(Lo(LongInt(P)));
	   H := HexW(Hi(LongInt(P)));
	   HexPtr := H+':'+L;
	End;

   End;





End.