Unit Dates;

Interface
  Uses crt,dos;



Type
   DateSTr = String[12];
	MonthStrg = string[10];

   Function Date : DateStr;
	FUNCTION DATE_TO_DOY(DT : DATESTR) : INTEGER;
	FUNCTION DOY_TO_DATE (DY : INTEGER; YEAR : INTEGER) : DATESTR;
	FUNCTION STORE_DATE (DT : DATESTR) : REAL;
	FUNCTION UNSTORE_DATE (DT : REAL) : DATESTR;
	Function Month_Str(M : Integer) : MonthStrg;
	Function Year_Num(DT : DateStr) : Integer;
	Function Month_Num(DT : DateStr) : Integer;
	Function Day_Num(DT : DateStr) : Integer;
	Function Date_OK(Chk_Date : DateStr) : Boolean;






Implementation



Function Date : DateStr;

Var
   MnStr : String [2];
	DyStr : String [2];
	YrStr : String [4];
   MnWrd : word;
	DyWrd : word;
	YrWrd : word;
	WkWrd : word;

Begin

	GetDAte(YrWrd,MnWrd,DyWrd,WkWrd);

	Str(YrWrd:4,YrStr);
	Str(MnWrd:2,MnStr);
	If MnStr[1] = ' ' then MnStr[1] := '0';
	Str(DyWrd:2,DyStr);
	If DyStr[1] = ' ' then DyStr[1] := '0';
   Date := MnStr+'/'+DyStr+'/'+YrStr;

End;



CONST

       MONTHS : ARRAY[1..12] OF INTEGER = (31,28,31,30,31,30,31,31,30,31,30,31);



FUNCTION DATE_TO_DOY(DT : DATESTR) : INTEGER;

VAR

   MONTH,DAY,I,DYS,CODE   : INTEGER;
   YEAR              : REAL;



BEGIN

     DYS := 0;

     VAL(COPY(DT,1,2),MONTH,CODE);
     VAL(COPY(DT,4,2),DAY,CODE);
     IF LENGTH(DT) = 8 THEN VAL(COPY(DT,7,2),YEAR,CODE);
     IF LENGTH(DT) =10 THEN VAL(COPY(DT,7,4),YEAR,CODE);

     FOR I:= 1 TO MONTH-1 DO BEGIN

              DYS := DYS + MONTHS[I];
              IF (I = 2) AND (FRAC(YEAR/4) = 0) THEN DYS := DYS +1;

      END;

      DYS := DYS + DAY;
      DATE_TO_DOY := DYS;

END;



FUNCTION DOY_TO_DATE (DY : INTEGER; YEAR : INTEGER) : DATESTR;

   VAR
        I : INTEGER;
        MN : STRING[2];
        D : STRING[2];
        YR : STRING[4];

BEGIN


       I := 1;

       WHILE DY > MONTHS[I] do BEGIN

          DY := DY - MONTHS[I];
          IF (I = 2) AND (FRAC(YEAR/4)=0) THEN DY := DY-1;
          I := I + 1;

      END;

          STR(I:2,MN);
          IF MN[1] = ' ' THEN MN[1] := '0';

          STR(DY:2,D);
          IF D[1] = ' ' THEN D[1] := '0';


          STR(YEAR:4,YR);

          IF YR[1] = ' ' THEN YR[1] := '0';
          IF YR[2] = ' ' THEN YR[2] := '0';



          DOY_TO_DATE := MN+'/'+D+'/'+YR;

END;



FUNCTION STORE_DATE (DT : DATESTR) : REAL;

    VAR
        SDT            : STRING [10];
        YR             : REAL;
        NUMBER_OF_DAYS : REAL;
        I              : INTEGER;

BEGIN

    IF LENGTH(DT) = 8 THEN  SDT := COPY(DATE,7,2)+COPY(DT,7,2);
    IF LENGTH(DT) = 10 THEN SDT := COPY(DT,7,4);

    VAL(SDT,YR,I);

    NUMBER_OF_DAYS := (YR*365.0)+INT(YR/4.0)+DATE_TO_DOY(DT);


    STORE_DATE := NUMBER_OF_DAYS;

END;



FUNCTION UNSTORE_DATE (DT : REAL) : DATESTR;

VAR

   DAY,YR  : INTEGER;
   YRR,DRR : REAL;


BEGIN



      YRR := INT((DT/365.25));


      YR  := ROUND(YRR);


      DRR := DT-(YRR*365.0)-INT(YRR/4.0);

      DAY := ROUND(DRR);


     UNSTORE_DATE := DOY_TO_DATE(DAY,YR);


END;



Function Date_OK(Chk_Date : DateStr) : Boolean;

  Var
    Month     : Integer;
    Day       : Integer;
    Year      : Integer;
    Error     : Integer;
    Leap_Year : Boolean;

Begin

    Val(Copy(Chk_Date,1,2),Month,Error);

    If Error = 0 then Val(Copy(Chk_Date,4,2),Day,Error);

    If Error = 0 then Val(Copy(Chk_Date,7,4),Year,Error);
    Leap_Year :=((Error = 0) AND (Frac(Year/4) = 0));


    Date_OK :=
             (Error = 0)
         AND (Length(Chk_Date) In[8,10])
         AND ((Chk_Date[3] In['/','-']) AND (Chk_Date[6] In['/','-']))
         AND (Month In[1..12])
         AND    (((Month IN[4,6,9]) AND (Day IN[1..30]))
             OR ((Month IN[1,3,5,7,8,10..12]) AND (Day IN[1..31]))
             OR ((Month = 2) AND (Leap_Year) AND (Day IN[1..29]))
             OR ((Month = 2) AND (Not Leap_Year) AND (Day IN[1..28])))

End;





Function Short_Date(DT : DateStr) : DateStr;



Begin


      Short_Date := Copy(DT,1,6) + Copy(DT,9,2);


End;



Function Month_Num(DT : DateStr) : Integer;

  Var
    Err,M : Integer;

Begin

    Val(Copy(DT,1,2),M,Err);
    If Err <> 0 Then
     Begin
      Write(#7);
      Writeln;
      WriteLn('Error in date ',DT);
      Gotoxy(14+Err,WhereY);
      Writeln(#24);
      Writeln; Writeln;
      Writeln('Must be in form MM/DD/YY or MM/DD/YYYY');
      Halt;
     End
     Else

        Month_Num := M;

End;






Function Day_Num(DT : DateStr) : Integer;

  Var
    Err,D : Integer;

Begin

    Val(Copy(DT,4,2),D,Err);
    If Err <> 0 Then
     Begin
      Write(#7);
      Writeln;
      WriteLn('Error in date ',DT);
      Gotoxy(14+Err,WhereY);
      Writeln(#24);
      Writeln; Writeln;
      Writeln('Must be in form MM/DD/YY or MM/DD/YYYY');
      Halt;
     End
     Else

        Day_Num := D;

End;





Function Year_Num(DT : DateStr) : Integer;

  Var
    Err,Y : Integer;

Begin

    Val(Copy(DT,7,4),Y,Err);
    If Err <> 0 Then
     Begin
      Write(#7);
      Writeln;
      WriteLn('Error in date ',DT);
      Gotoxy(14+Err,WhereY);
      Writeln(#24);
      Writeln; Writeln;
      Writeln('Must be in form MM/DD/YY or MM/DD/YYYY');
      Halt;
     End
     Else

        Year_Num := Y;

End;





Function Month_Str(M : Integer) : MonthStrg;


    Type
      MonthType = Array[1..12] of MonthStrg;

    Const

     Mnth : MonthType = ('January','February','March','April','May','June','July',
                          'August','September','October','November','December');


  Begin

     Month_Str := Mnth[M];

 End;



End.