UNIT heapstr;


{Unit for dynamic strings (stored on the heap), version 1.0.
Written for Turbo Pascal 5.5.

Donated to the public domain by Wayne E. Conrad, January, 1989.
If you have any problems or suggestions, please contact me at my BBS:

    Pascalaholics Anonymous
    (602) 484-9356
    2400 bps
    The home of WBBS
    Lots of source code
}



INTERFACE


{Here's the object for dynamic strings.  It's bad form to access the
"strptr" variable directly.  Instead, use the function "value" to get
the current value.}

TYPE
  heap_string =
    OBJECT
    strptr: ^String;
    CONSTRUCTOR init;
    FUNCTION store (st: String): Boolean;
    FUNCTION value: String;
    DESTRUCTOR dispose;
    END;


IMPLEMENTATION


{This method initializes the heap string, clearing it.  This method must
be called before any of the other methods are used, and it should not be
called after that.}

CONSTRUCTOR heap_string.init;
BEGIN
  strptr := NIL
END;



{Set the value of the string on the heap.  If not enough memory is
available, returns False.}

FUNCTION heap_string.store (st: String): Boolean;
VAR
  nbytes: Word;
BEGIN
  dispose;
  nbytes := Succ (Length (st) );
  IF MaxAvail < nbytes THEN
    store := False
  ELSE
    BEGIN
    GetMem (strptr, nbytes);
    Move (st, strptr^, nbytes);
    store := True
    END;
END;


{Get the value of the string.  If the string doesn't exist, returns an
empty string.}

FUNCTION heap_string.value: String;
BEGIN
  IF strptr = NIL THEN
    value := ''
  ELSE
    value := strptr^
END;


{Dispose of the string, if it exists.}

DESTRUCTOR heap_string.dispose;
VAR
  nbytes: Word;
BEGIN
  IF strptr <> NIL THEN
    BEGIN
    nbytes := Succ (Length (strptr^) );
    FreeMem (strptr, nbytes);
    strptr := NIL
    END
END;


END.
