{*****************************************************************************
 This unit automatically checks for attempts to dereference a nil pointer, or
 any pointer which points outside of the normal Turbo heap (below HeapOrg, or
 above the free list). USE it early, perhaps first, in your USES statement. In
 order for this unit to have an effect, the program it is used in must be
 compiled with a copy of TPC patched by HEAPPAT, and the $P+ compiler
 directive must be specified before each section of source code where checking
 is to occur.

 For further information, refer to HEAP.DOC.

 Written 7/26/88, Kim Kokkonen, TurboPower Software.
 Compuserve ID 76004,2611
 Copyright (C) TurboPower Software, 1988,1989,1990. All rights reserved.

 Version 5.0 3/8/89
   Updated for Turbo Pascal 5.0.
 Version 5.5 1/6/90
   Updated for Turbo Pascal 5.5.
*****************************************************************************}

{$R-,S-}

unit BadPtr;

interface

uses
  Dos;

const
  DerefInterrupt = $66;           {Change this constant if HPAT55 has been
                                   changed to use a different interrupt number}

var
  HeapBot : Word;                 {Lowest segment of heap}
  HeapTop : Word;                 {Highest segment of heap}

  {============================================================}

implementation

const
  Digits : array[0..$F] of Char = '0123456789ABCDEF';

type
  SO = record
         O, S : Word;
       end;

var
  SaveExit : Pointer;             {Previous exit handler}
  SaveDerefInt : Pointer;         {Previous value of int 66 vector}
  BadP : Pointer;                 {Contains bad pointer if error}

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexPtr(P : Pointer) : string;
    {-Return hex string for pointer}
  begin
    HexPtr := HexW(SO(P).S)+':'+HexW(SO(P).O);
  end;

  procedure BadPointer;
    {-Called when a pointer error is detected}
  begin
    WriteLn('Bad pointer (', HexPtr(BadP), ') encountered at ', HexPtr(ErrorAddr));
    WriteLn('Valid heap limits are ', HexW(HeapBot), '-', HexW(HeapTop));
    Halt(1);
  end;

  {$L BADPTR}
  procedure CheckBad;
    {-Check for a bad pointer}
  external;

  {$F+}
  procedure Cleanup;
    {-Restore interrupt}
  begin
    ExitProc := SaveExit;
    SetIntVec(DerefInterrupt, SaveDerefInt);
  end;
  {$F-}

begin
  HeapBot := SO(HeapOrg).S;
  HeapTop := SO(FreePtr).S+$1000;
  GetIntVec(DerefInterrupt, SaveDerefInt);
  SetIntVec(DerefInterrupt, @CheckBad);
  SaveExit := ExitProc;
  ExitProc := @Cleanup;
end.
