;BADPTR.ASM
; used in BADPTR.PAS

;****************************************************** Data

DATA    SEGMENT WORD PUBLIC
        EXTRN   ErrorAddr:DWORD         ;Turbo's error address
        EXTRN   PrefixSeg:WORD          ;Prefix segment of program
        EXTRN   BadP:DWORD              ;Holds bad pointer if error
        EXTRN   HeapBot:WORD            ;Lowest heap segment
        EXTRN   HeapTop:WORD            ;Highest heap segment
DATA    ENDS

;****************************************************** Code

CODE    SEGMENT BYTE PUBLIC

        ASSUME  CS:CODE,DS:DATA

        PUBLIC  CheckBad
        EXTRN   BadPointer:NEAR

;****************************************************** CheckBad

;interrupt service routine called when a pointer is dereferenced
;Entry: ES:DI contains pointer
;Exit:  all registers preserved

lo      EQU     (WORD PTR 0)
hi      EQU     (WORD PTR 2)

CheckBad   PROC FAR
        PUSH    SI                      ;Save register
        MOV     SI,ES                   ;SI = segment of pointer
        CMP     SI,HeapBot              ;Is pointer below HeapBot?
        JB      CheckError              ;Jump if so
        CMP     SI,HeapTop              ;Is pointer above HeapTop?
        JAE     CheckError              ;Jump if so
        POP     SI                      ;Restore register
        IRET                            ;Return if all is OK

CheckError:
        PUSH    AX                      ;Save registers in case
        PUSH    BX                      ;   BadPointer returns
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    ES

        MOV     BadP.lo,DI              ;Store value of pointer
        MOV     BadP.hi,ES

        MOV     BX,SP                   ;Store error address
        MOV     AX,SS:[BX+14]           ;AX=offset of error
        MOV     ErrorAddr.lo,AX
        MOV     AX,SS:[BX+16]           ;AX=segment of error
        SUB     AX,PrefixSeg
        SUB     AX,10h                  ;Convert to relative format
        MOV     ErrorAddr.hi,AX

        CALL    BadPointer              ;Call error routine

        POP     ES
        POP     DI
        POP     DX
        POP     CX
        POP     BX
        POP     AX
        POP     SI
        IRET                            ;Return in case BadPointer doesn't halt
CheckBad   ENDP

CODE    ENDS

        END
