program TestSch2;
{------------------------------------------------------------------------------
                              DBase Key Field Locator

       TESTSCH2.PAS Copyright (c)  Richard F. Griffin

       14 July 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how status may be checked while running
       key string searches in dBase files.

       This example is an extension of the status reporting example that
       was demonstrated in GSDMO_17.PAS.

       If the GSDMO_17.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_17 to make
       the file.

       The program opens a dBase file and will ask for a LASTNAME field
       key to search for.  Enter any portion of the string.  During the
       search, the current record being searched is reported.

-------------------------------------------------------------------------------}

uses
   GSOB_Var,
   GSOBShel,
   GSXT_Sch,
   SmplStuf,
   CRT,
   DOS;

var
   St    : string;
   posn : word;
   fnum : word;

   h,m,s,c,h1,m1,s1,c1:word;
   rt : real;

{-----------------------------------------------------------------------------}
{$F+}
Procedure UserCaptureStatus(stat1,stat2,stat3 : longint);
begin
   case stat1 of
      StatusStart  : begin
                        GotoXY(1,WhereY);
                        case stat2 of
                            StatusSearch : system.write('[ Search Progress ]');
                         end;
                         Writeln;
                         GotoXY(26,WhereY);
                         system.write('Total Records to Process = ',stat3);
                      end;
      StatusStop    : begin
                         GoToXY(79,WhereY);
                         Writeln;
                         Writeln('Finished');
                      end;
      StatusSearch  : begin
                         GoToXy(1,WhereY);
                         if stat2 mod 10 = 0 then    {every 10th record}
                            system.write('Record Number ',stat2,'  ');
                      end;
   end;
end;
{$F-}
{----------------------------------------------------------------------------}

begin
                             {Establish user status capture routine}
   SetStatusCapture(UserCaptureStatus);

   ClrScr;
   if not FileExist('GSDMO_01.DBF') then   {Check for the file}
   begin
      writeln('File GSDMO_17.DBF not found.  Run GSDMO_17 to create.');
      halt;
   end;
                       {The 'Real' example starts here}

   Select(1);                     {Use record area 1 (the default)}
   Use('GSDMO_17');               {Assign the dBase III file GSDMO_17}
   REPEAT
      write('LASTNAME to search for:');
      readln(St);
      if St <> '' then
      begin
         gettime(h,m,s,c);                {Test the time it takes}

         fnum := FieldNo('LASTNAME');
         posn := SearchDBF(St,fnum,true);
         if posn > 0 then                 {Posn = starting position in string}
         begin
            writeln(RecNo,'  ',
                    FieldGet('LASTNAME'),' ',       {Get field images}
                    FieldGet('FIRSTNAME'),'  ',
                    FieldGet('UNIQUEID'));
            writeln(RecNo,' records were searched');
         end
         else
         begin
            writeln('No Match!  ',RecCount,' records were searched');
         end;

      {  Report elapsed time  }

         gettime(h1,m1,s1,c1);
         if s1 < s then s1 := s1 + 60;
         s := (s*100)+c;
         s1 := (s1*100)+c1;
         rt := s1-s;
         rt := rt/100;
         writeln('Time required to find key was  ',rt:2:2,' seconds.');
      end;

   until st = '';
   SetStatusCapture(DefCapStatus);        {Restore default status routine}
   CloseDataBases;                {Close the file}
end.
