{
 Hardcopy demo for the unit PRNTSCR.

 Part of the PRNTSCR unit source code was taken from Capt Antonio Rivera's
 HRDCPY.ARC procedure for the Proprinter.

 Other parts were taken from the original Borland HardCopy procedure and
 modified for TP4.

 I wish to thank the Sysops amd Tech people at Borland for the excellent
 help they have provided. Especially John Sieraski for his SetBinBit
 procedure.

 I also wish to absolve them of any blame for mistakes I might have made in
 this program.
 --------------------------------------------------------------------------

 First compile PRTSCR with
 TPC PRNTSCR

 Then compile HCDEMO with
 TPC HCDEMO

 The PRNTSCR unit will print upright or sideways print on the following
 printers:

 Epson MX/FX/RX
 IBM Proprinter
 Okidata 84

 Comments are welcome:

 Jerry Adkins
 P.O. Box 1160
 Rialto, CA 92376

 Compuserve ID 70455,112

}
Program HcDemo;
Uses
   DOS,
   CRT,
   Graph,
   Printer,
   PrntScr;

Const
   Inverse = False; { Assume no inverse printing }

Var
   Mode  : Integer;      { Which print mode? Depends on printer. }
   Start : Integer;      { Initialize printier or not. This is used in one of
                           my programs that prints a screen full of graphics,
                           then another screen without initializing the
                           printer the second time. }

   PrnType : Integer;    { 1 = Proprinter
                           2 = Epson
                           3 = Okidata }

   Gd : Integer; { Graph Driver }

   Upright : Boolean;    { Upright or sideways print? }

   Ch : Char;            { For ReadKey }

{$I GrInit.Inc}

Begin
   ClrScr;

   Repeat
      Gotoxy(20,10);
      Write('Printer type: 1=Proprinter  2=Epson  3=Okidata ');
      Readln(PrnType); { Use a better input routine in your program. }
   Until PrnType in [1..3];

   Mode := 1;  { Change to experiment with other modes. }
   Start := 0; { Assume only one screen to print }
   Initialize(Gd);       { Graphics }
   SetFillStyle(3,White);
   Bar(200,5,400,300);
   SetTextStyle(DefaultFont,HorizDir,1);
   OutTextXY(100,330,'Upright graph. Switch printer on. Press any key...');
   Ch := ReadKey;
   Upright := True;
   hardcopy(Inverse,Mode,PrnType,Start,Upright);
   ClearDevice;
   Bar(200,5,400,300);
   SetTextStyle(DefaultFont,HorizDir,1);
   OutTextXY(100,330,'Sideways graph. Switch printer on. Press any key...');
   Ch := ReadKey;
   UpRight := False;
   hardcopy(Inverse,Mode,PrnType,Start,Upright);
   CloseGraph;
end.
