;------------------------------------------------------------------------------;
;		    Concepts from the TEGL Windows Toolkit		       ;
;		   Copyright (C) 1990,1992 TEGL Systems Corporation 	       ;
;			     All Rights Reserved.			       ;
;------------------------------------------------------------------------------;

		.model tpascal

		.data
		extrn	rmwbits 	    : word
		extrn	activepage	    : word
		extrn	bytesperline	    : word


		extrn	getmaxx 	    : word
		extrn	getmaxy 	    : word
		extrn	egapalette	    : byte

		extrn	lastmode__	    : byte
		extrn	lastpage__	    : byte


		.code


setgrmode	proc	far mode:word
		public	setgrmode

		push	ds
		push	si
		push	es
		push	di

		mov	ax,@data
		mov	ds,ax
		mov	es,ax

		mov	ds:getmaxx,639
		mov	ds:getmaxy,349

		mov	ax,10h
		dec	mode
		jz	goset
		mov	ax,12h
		mov	ds:getmaxy,479
goset:		int	10h

		mov	ax,1002h
		mov	dx,offset egapalette
		int	10h

		pop	di
		pop	es
		pop	si
		pop	ds
		ret
setgrmode	endp



currentvid	proc	far
		public	currentvid

		push	ds

		mov	ax,@data
		mov	ds,ax

		mov	ah,0fh
		int	10h

		mov	ds:lastmode__,al
		mov	ds:lastpage__,bh

		pop	ds
		ret
currentvid	endp

restorevid	proc	far
		public	restorevid

		push	ds

		mov	ax,@data
		mov	ds,ax

		xor	ax,ax
		mov	al,lastmode__
		int	10h

		mov	ah,05h
		mov	al,lastpage__
		int	10h

		pop	ds
		ret
restorevid	endp



imagesize	proc	far argx1:word,argy1:word,argx2:word,argy2:word
		public	imagesize
		push	bx

		mov	ax,argx2			;x1-x+1
		sub	ax,argx1
		inc	ax

		mov	dx,ax
		mov	cl,3				; /8
		shr	ax,cl

		and	dl,07h				;check for byte
		jz	hisz01				;boundary
		inc	ax
hisz01: 	mov	bx,argy2			;y1-y+1
		sub	bx,argy1
		inc	bx
		mul	bx				;rows * bytes per row

		shl	ax,1				;multiply by 4
		rcl	dx,1
		shl	ax,1
		rcl	dx,1

		add	ax,6				;add 6 for header
		adc	dx,0

		pop	bx
		ret
imagesize	endp

fastline	proc	far argx1:word,argy1:word,argx2:word,argy2:word,color:word
		public	fastline
		local	varvertincr:word,varincr1:word,varincr2:word,varroutine:word
		local	rmwb:word,bpline:word

		push	ds
		push	si
		push	es
		push	di


		mov	ax,@data
		mov	ds,ax
		mov	ax,ds:rmwbits
		mov	rmwb,ax

		mov	ax,ds:bytesperline
		mov	bpline,ax


; configure the graphics controller

		mov	dx,3ceh 	; dx := graphics controller port addr

		mov	ah,byte ptr [color] ; ah := pixel value
		xor	al,al		; al := set/reset register number
		out	dx,ax

		mov	ax,0f01h	; ah := 1111b (bit plane mask for
					;  enable set/reset
		out	dx,ax		; al := enable set/reset register #

		mov	ah,byte ptr [rmwb] ; bits 3 and 4 of ah := function
		mov	al,3		; al := data rotate/func select reg #
		out	dx,ax

; check for vertical line

		mov	si,bpline	; increment for video buffer

		mov	cx,argx2
		sub	cx,argx1	; cx := x2 - x1
		jz	vertline10	; jump if vertical line

; force x1 < x2

		jns	l01		; jump if x2 > x1

		neg	cx		; cx := x1 - x2

		mov	bx,argx2	; exchange x1 and x2
		xchg	bx,argx1
		mov	argx2,bx

		mov	bx,argy2	; exchange y1 and y2
		xchg	bx,argy1
		mov	argy2,bx

; calculate dy = abs(y2-y1)

l01:		mov	bx,argy2
		sub	bx,argy1	; bx := y2 - y1
		jz	horizline10	; jump if horizontal line

		;sloped line not supported
		jmp	short lexit


; routine for vertical lines

vertline10:	mov	ax,argy1	; ax := y1
		mov	bx,argy2	; bx := y2
		mov	cx,bx
		sub	cx,ax		; cx := dy
		jge	l31		; jump if dy >= 0

		neg	cx		; force dy >= 0
		mov	ax,bx		; ax := y2

l31:		inc	cx		; cx := # of pixels to draw
		mov	bx,argx1	; bx := x
		push	cx		; preserve this register
		call	evgaactiveaddr	; ah := bit mask
					; es:bx -> video buffer
					; cl := # bits to shift left
; set up graphics controller

		shl	ah,cl		; ah := bit mask in proper position
		mov	al,8		; al := bit mask reg number
		out	dx,ax

		pop	cx		; restore this register

; draw the line

l32:		or	es:[bx],al	; set pixel
		add	bx,si		; increment to next line
		loop	l32

		jmp	short lexit



; routine for horizontal lines (slope = 0)

horizline10:
		push	ds		; preserve ds

		mov	ax,argy1
		mov	bx,argx1
		call	evgaactiveaddr	; ah := bit mask
					; es:bx -> video buffer
					; cl := # bits to shift left
		mov	di,bx		; es:di -> buffer

		mov	dh,ah		; dh := unshifted bit mask for leftmost
					;	 byte
		not	dh
		shl	dh,cl		; dh := reverse bit mask for first byte
		not	dh		; dh := bit mask for first byte

		mov	cx,argx2
		and	cl,7
		xor	cl,7		; cl := number of bits to shift left
		mov	dl,0ffh 	; dl := unshifted bit mask for
					;	 rightmost byte
		shl	dl,cl		; dl := bit mask for last byte

; determine byte offset of first and last pixel in the line

		mov	ax,argx2	; ax := x2
		mov	bx,argx1	; bx := x1

		mov	cl,3		; number of bits to shift to
						;  convert pixels to bytes

		shr	ax,cl		; ax := byte offset of x2
		shr	bx,cl		; bx := byte offset of x1
		mov	cx,ax
		sub	cx,bx		; cx := (# bytes in line) - 1

; get graphics controller port address into dx

		mov	bx,dx		; bh := bit mask for first byte
					; bl := bit mask for last byte
		mov	dx,3ceh 	; dx := graphics controller port
		mov	al,8		; al := bit mask register number

; make video buffer addressible through ds:si

		push	es
		pop	ds
		mov	si,di		; ds:si -> video buffer

; set pixels in leftmost byte of the line

		or	bh,bh
		js	l43		; jump if byte-aligned (x1 is leftmost
					;  pixel in byte)
		or	cx,cx
		jnz	l42		; jump if more than one byte in the line

		and	bl,bh		; bl := bit mask for the line
		jmp	short l44

l42:		mov	ah,bh		; ah := bit mask for 1st byte
		out	dx,ax		; update graphics controller
		movsb			; update bit planes
		dec	cx

; use a fast 8086 machine instruction to draw the remainder of the line

l43:		mov	ah,11111111b	; ah := bit mask
		out	dx,ax		; update bit mask register
		rep	movsb		; update all pixels in the line

; set pixels in the rightmost byte of the line

l44:		mov	ah,bl		; ah := bit mask for last byte
		out	dx,ax		; update graphics controller
		movsb			; update bit planes
		pop	ds		; restore ds


; restore default graphics controller state and return to caller

lexit:		xor	ax,ax		; ah := 0, al := 0
		out	dx,ax		; restore set/reset register

		inc	ax		; ah := 0, al := 1
		out	dx,ax		; restore enable set/reset register

		mov	al,3		; ah := 0, al := 3
		out	dx,ax		; al := data rotate/func select reg #

		mov	ax,0ff08h	; ah := 1111111b, al := 8
		out	dx,ax		; restore bit mask register

		pop	di
		pop	es
		pop	si
		pop	ds
		ret

fastline	endp

getimage	proc	far argx0:word,argy0:word,argx1:word,argy1:word,addrbuf:dword
		public	getimage
		local	varpixelrows:word,varpixelrowlen:word,bpline:word

		push	ds
		push	si
		push	di

		mov	ax,@data
		mov	ds,ax
		mov	ax,ds:bytesperline
		mov	bpline,ax

; compute dimensions of bit block

		mov	ax,argx1
		sub	ax,argx0
		mov	cx,0ff07h

		and	cl,al

		xor	cl,7
		shl	ch,cl
		mov	cl,ch
		push	cx

		mov	cl,3
		shr	ax,cl
		inc	ax
		push	ax

		mov	ax,argy1
		sub	ax,argy0
		inc	ax
		push	ax

; establish addressing

		mov	ax,argy0
		mov	bx,argx0
		call	evgaactiveaddr
		xor	cl,7
		push	es
		pop	ds
		mov	si,bx

		les	di,addrbuf

; build 5-byte bit block header

		pop	ax
		mov	varpixelrows,ax
		stosw
		pop	ax
		mov	varpixelrowlen,ax
		stosw
		pop	ax
		mov	ch,al
		stosb

; set up graphics controller

		mov	dx,3ceh 	; dx := graphics controller i/o port

		mov	ax,0005 	; ah := 0 (read mode 0, write mode 0)
		out	dx,ax		; al := 5 (mode register)

		mov	ax,0304h	; ah := 3 (plane #3)
;		mov	ax,0004h	; ah := 3 (plane #3)
					; al := 4 (read map select)

		cmp	cx,0ff00h
		jne	getbl06

; copy from video buffer to system ram
; routine for byte-aligned bit blocks

		mov	cx,varpixelrowlen
		mov	varpixelrowlen,0
		shr	cx,1		; divide by 2
		jnc	getbl01
		mov	varpixelrowlen,1

getbl01:	out	dx,ax
		push	ax
		push	si
		mov	bx,varpixelrows

getbl02:	push	si
		push	cx

		jcxz	getbl03

		rep	movsw

getbl03:	test	varpixelrowlen,1
		jz	getbl04
		movsb

getbl04:	pop	cx
		pop	si
		add	si,bpline

		dec	bx
		jnz	getbl02

		pop	si
		pop	ax
		dec	ah
		jns	getbl01

		jmp	lexit1


; copy from video buffer to system ram
; routine for non-aligned bit blocks

getbl06:	out	dx,ax
		push	ax
		push	varpixelrows
		push	si

getbl07:	mov	bx,varpixelrowlen
		push	si

getbl08:	lodsw

		dec	si
		rol	ax,cl
		stosb
		dec	bx
		jnz	getbl08

		and	es:[di-1],ch
		pop	si
		add	si,bpline

		dec	varpixelrows
		jnz	getbl07

		pop	si
		pop	varpixelrows

		pop	ax
		dec	ah
		jns	getbl06

lexit1: 	pop	di
		pop	si
		pop	ds
		ret

getimage	endp


putimage	proc	far argx:word,argy:word,addrbuf:dword,rmwb:word
		public	putimage
		local	varpixelrows:word,varpixelrowlen:word
		local	varrowcounter:word,varstartmask:word
		local	varendmaskl:word,varendmaskr:word,bpline:word

		; rmwbits -   normalput        00h
		;	      xorput	       18h
		;	      orput	       10h
		;	      andput	       08h
		;	      notput	       80h

		push	ds
		push	si
		push	di

		mov	ax,@data
		mov	ds,ax
		mov	ax,ds:bytesperline
		mov	bpline,ax

; extablish addressing

		mov	ax,argy
		mov	bx,argx
		call	evgaactiveaddr
		inc	cl
		and	cl,7
		mov	di,bx

		lds	si,addrbuf

; obtain dimensions of bit block from header

		lodsw
		mov	varpixelrows,ax
		lodsw
		mov	varpixelrowlen,ax
		lodsb
		mov	ch,al

; set up graphics controller

		mov	dx,3ceh 	; dx := graphics controller i/o port

		mov	ah,byte ptr [rmwb] ; ah := value for data rotate/function
		and	ah,18h
		mov	al,3		;    select register
		out	dx,ax		; 18h is xor

		mov	ax,0805h	; ah := 8 (read mode 1, write mode 0)
		out	dx,ax		; al := 5 (mode register)

		mov	ax,0007 	; ah := 0 (don't care for all maps;
		out	dx,ax		;   cpu reads always return 0ffh)
					; al := 7 (color don't care reg number)

		mov	ax,0ff08h	; ah := 0ffh (value for bit mask reg)
		out	dx,ax		; set up bit mask reg

		mov	dl,0c4h 	; dx := 3c4h (sequence i/o port)

;		mov	ax,0802h	; ah := 1000b (value for map mask reg)
		mov	ax,0f02h	; ah := 1000b (value for map mask reg)
					; al := 2 (map mask register number)

		test	byte ptr rmwb,018h
		jnz	nofancy
		mov	ah,0fh		; ah := 1111b (value for map mask reg)

nofancy:	cmp	cx,0ff00h
		jne	putbl15

; routine for byte-aligned bit blocks

		mov	cx,varpixelrowlen
		mov	varpixelrowlen,0
		shr	cx,1		; divide by 2
		jnc	putbl10
		mov	varpixelrowlen,1

putbl10:	out	dx,ax
		push	ax
		push	di
		mov	bx,varpixelrows

putbl11:	push	di
		push	cx

		test	byte ptr rmwb,80h
		jz	normal
		jcxz	putbl12a
notnorm:	lodsw
		not	ax
		stosw
		loop	notnorm

putbl12a:	test	varpixelrowlen,1
		jz	putbl13
		lodsb
		not	al
		stosb
		jmp	putbl13


normal: 	jcxz	putbl12
		rep	movsw
putbl12:	test	varpixelrowlen,1
		jz	putbl13
		movsb

putbl13:	pop	cx
		pop	di
		add	di,bpline
		dec	bx
		jnz	putbl11

		pop	di
		pop	ax
		shr	ah,1
		jnz	putbl10
		jmp	lexit2

; routine for non-aligned bit blocks

putbl15:	push	ax
		mov	bx,0ffh
		mov	al,ch
		cbw

		cmp	varpixelrowlen,1
		jne	putbl16

		mov	bl,ch
		mov	ah,ch
		xor	al,al

putbl16:	shl	ax,cl
		shl	bx,cl

		mov	bl,al
		mov	al,8
		mov	varendmaskl,ax
		mov	ah,bl
		mov	varendmaskr,ax
		mov	ah,bh
		mov	varstartmask,ax

		mov	bx,varpixelrowlen
		pop	ax

; set pixels row by row in the bit planes

putbl17:	out	dx,ax
		push	dx
		push	ax
		push	di
		mov	dl,0ceh

		mov	ax,varpixelrows

putbl18:
		push	ax
		push	di
		push	si
		push	bx

		mov	ax,varstartmask
		out	dx,ax

		lodsw
		test	byte ptr rmwb,80h
		jz	norm001
		not	ax
norm001:

		dec	si
		test	cl,cl
		jnz	putbl19

		dec	bx
		jnz	putbl20
		jmp	short putbl22

putbl19:	rol	ax,cl

		and	es:[di],ah
		inc	di

		dec	bx

putbl20:	push	ax
		mov	ax,0ff08h
		out	dx,ax
		pop	ax

		dec	bx
		jng	putbl22

; set pixels in middle of row

putbl21:	and	es:[di],al
		inc	di

		lodsw
		test	byte ptr rmwb,80h
		jz	norm002
		not	ax
norm002:
		dec	si
		rol	ax,cl

		dec	bx
		jnz	putbl21

; set pixels at end of row

putbl22:	mov	bx,ax
		mov	ax,varendmaskl

		out	dx,ax
		and	es:[di],bl

		mov	ax,varendmaskr
		out	dx,ax
		and	es:[di+1],bh

		pop	bx
		pop	si
		add	si,bx
		pop	di
		add	di,bpline
		pop	ax
		dec	ax
		jnz	putbl18

		pop	di

		pop	ax
		pop	dx
		shr	ah,1
		jnz	putbl17

; restore graphics controller and sequencer to their default states

lexit2: 	mov	ax,0f02h
		out	dx,ax

		mov	dl,0ceh
		mov	ax,003
		out	dx,ax

		mov	ax,0005
		out	dx,ax

		mov	ax,0f07h
		out	dx,ax

		mov	ax,0ff08h
		out	dx,ax

		pop	di
		pop	si
		pop	ds
		ret

putimage	endp

wrtchar 	proc	far argc:word,argx:word,argy:word,argfgd:word
		public	wrtchar
		local	varshift:word
		local	rmwb:word,bpline:word

		push	ds
		push	si
		push	es
		push	di

; calculate first pixel address

		mov	ax,argy 	; ax := y
		mov	bx,argx 	; bx := x
		call	evgaactiveaddr	; es:bx -> buffer
					; cl := # bits to shift left to mask
					;  pixel
		inc	cx
		and	cl,7		; cl := # bits to shift to mask char

		mov	ch,0ffh
		shl	ch,cl		; ch := bit mask for right side of char
		mov	varshift,cx

		push	es		; preserve video buffer segment
		mov	si,bx		; si := video buffer offset

; set up character definition table addressing

		mov	ax,@data
		mov	ds,ax

		mov	ax,ds:rmwbits
		mov	rmwb,ax

		mov	ax,ds:bytesperline
		mov	bpline,ax

		mov	ax,40h
		mov	ds,ax
		mov	cx,ds:[85h]

		xor	ax,ax
		mov	ds,ax

		mov	ax,argc
		mov	bx,43h*4
		les	di,ds:[bx]
		mul	cl
		add	di,ax


		pop	ds		; ds:si -> video buffer

; set up graphics controller registers

		mov	dx,3ceh 	; graphics controller address reg port

		mov	ax,0a05h	; al :=  mode register number
					; ah :=  write mode 2 (bits 0-1)
					;	 read mode 1 (bit 4)
		out	dx,ax

		mov	ah,byte ptr [rmwb] ; ah := read-modify-write bits
		mov	al,3		; al := data rotate/function select reg
		out	dx,ax

		mov	ax,0007 	; ah := color don't care bits
					; al := color don't care reg number
		out	dx,ax		; "don't care" for all bit planes

; select output routine depending on whether character is byte-aligned

		mov	bl,byte ptr [argfgd] ; bl := foreground pixel value

		test	byte ptr [varshift],0ffh ; test # bits to shift
		jne	l20		; jump if character is not byte-aligned


; routine for byte-aligned characters

		mov	al,8		; al := bit mask register number

wrtcl10:	mov	ah,es:[di]	; ah := pattern for next row of pixels

		out	dx,ax		; update bit mask register
		and	[si],bl 	; update foreground pixels

		inc	di		; es:di -> next byte in char def table
		add	si,bpline	; increment to next line in video buffer
		loop	wrtcl10
		jmp	short wrtcexit


; routine for non-byte-aligned characters

l20:		push	cx		; preserve loop counter
		mov	cx,varshift	; ch := mask for left side of character
					; cl := # bits to shift left
; left side of character

		mov	al,es:[di]	; al := bits for next row of pixels
		xor	ah,ah
		shl	ax,cl		; ah := bits for left side of char
					; al := bits for right side of char

		push	ax		; save bits for right side on stack
		mov	al,8		; al := bit mask register number

		out	dx,ax		; set bit mask for foreground pixels

		and	[si],bl 	; update foreground pixels

; right side of character

		pop	ax
		mov	ah,al		; ah := bits for right side of char
		mov	al,8
		out	dx,ax		; set bit mask

		inc	si		; ds:si -> right side of char in buffer

		and	[si],bl 	; update foreground pixels

; increment to next row of pixels in character

		inc	di		; es:di -> next byte in char def table
		dec	si
		add	si,bpline	; ds:si -> next line in video buffer

		pop	cx
		loop	l20


; restore default graphics controller registers

wrtcexit:	mov	ax,0ff08h	; default bit mask
		out	dx,ax

		mov	ax,0005 	; default mode register
		out	dx,ax

		mov	ax,0003 	; default data rotate/function select
		out	dx,ax

		mov	ax,0f07h	; default color don't care
		out	dx,ax

nowrt:		pop	di
		pop	es
		pop	si
		pop	ds

		ret

wrtchar 	endp


charheight	proc	far
		public	charheight

		push	ds

		mov	ax,40h
		mov	ds,ax
		mov	ax,ds:[85h]

		pop	ds

		ret
charheight	endp

evgaactiveaddr	proc	near

		mov	cl,bl
		push	ds
		push	dx

		mov	dx,@data
		mov	ds,dx
		mov	dx,ds:bytesperline
		mul	dx

		pop	dx
		shr	bx,1
		shr	bx,1
		shr	bx,1
		add	bx,ax

		mov	ax,ds:activepage
		shr	ax,1
		shr	ax,1
		shr	ax,1
		shr	ax,1
		add	ax,0a000h
		mov	es,ax
		pop	ds

		and	cl,7
		xor	cl,7
		mov	ah,1
		ret

evgaactiveaddr	endp

		end
