{------------------------------------------------------------------------------}
{		    Concepts from the TEGL Windows Toolkit		       }
{		   Copyright (C) 1990,1992 TEGL Systems Corporation 	       }
{			     All Rights Reserved.			       }
{------------------------------------------------------------------------------}
{$I switches.inc}

Unit menus;

Interface

Uses frames,fgraph,msmouse,visual;

TYPE
   OptionMPtr  = ^OptionMenu;
   OptionEPtr  = ^OptionEntry;

   OptionMenu  = RECORD
		    maxwidth	   : Word;
		    numofentries   : word;
		    linkentries    : OptionEPtr;
		 END;

   OptionEntry = RECORD
		    NextOE	   : OptionEPtr;
		    entryline	   : String[30];
		    entryactive    : Boolean;
		    entrycallproc  : callproc;
		 END;


Function CreateOptionMenu : OptionMPtr;
Procedure DefineOptions(OM:OptionMptr; EntryStr:String; Active:Boolean; EntryCallProc:callproc);
procedure OpenOptionMenu(x,y:Word; OM:OptionMPtr);

implementation

Function CreateOptionMenu : OptionMPtr;
   VAR newom : OptionMPtr;
   BEGIN
      getmem(newom,sizeof(newom^));

      newom^.maxwidth	    := 0;
      newom^.numofentries   := 0;
      newom^.linkentries    := NIL;

      CreateOptionMenu := newom;
   END;

Procedure DefineOptions(OM:OptionMptr; EntryStr:String; Active:Boolean; EntryCallProc:callproc);
   VAR NewOE	   : OptionEPtr;
       entrysize   : Word;
       OE	   : OptionEPtr;
   BEGIN
      getmem(NewOE,sizeof(NewOE^));

      NewOE^.EntryCallProc := EntryCallProc;

      inc(om^.numofentries);
      entrysize := textwidth(EntryStr);
      IF entrysize > OM^.maxwidth THEN
	 OM^.maxwidth := entrysize;

      NewOE^.entryline	   := EntryStr;
      NewOE^.entryactive   := active;
      NewOE^.NextOE	   := nil;

      OE := OM^.linkentries;
      while (OE<>nil) and (OE^.NextOE<>nil) do
	 OE := OE^.NextOE;

      IF OE=NIL THEN
	 OM^.linkentries := NewOE
      else
	 OE^.NextOE := NewOE;
   END;

Procedure ListOptionMenu(fs:ImageStkPtr; OM:OptionMPtr);
   VAR mx,my,mx1,my1 : Word;
       OE	     : OptionEPtr;
       BarHeight     : Word;
       ys	     : Word;
       x,y,x1,y1     : word;
   BEGIN
      x := fs^.x;
      y := fs^.y;
      x1 := fs^.x1;
      y1 := fs^.y1;

      BarHeight := textheight('A');

      OE := OM^.linkentries;
      mx  := 6;
      my  := 4;
      mx1 := x1-x-6;
      my1 := my+BarHeight;

      while (OE<>nil) do
	 BEGIN
	    if OE^.entryactive then
	       begin
		  setcolor(white);
		  DefineMouseClickArea(fs,mx,my,mx1,my1,OE^.entrycallproc);
	       end
	    else
	       setcolor(lightgray);

	    IF OE^.entryline[1]='-' THEN
	       begin
		  ys := y+2+my+(barheight DIV 2);
		  line(x+mx,ys,x+mx1,ys);
	       end
	    ELSE
	       OutTextXY(x+mx+2,y+2+my,OE^.entryline);

	    inc(my,BarHeight);
	    inc(my1,BarHeight);
	    OE := OE^.NextOE;
	 END;
   END;

procedure openmenuredraw(ifs:ImageStkPtr; ms: MsClickPtr);
   var x,y,x1,y1 : word;
   begin
      x  := ifs^.x;
      y  := ifs^.y;
      x1 := ifs^.x1;
      y1 := ifs^.y1;

      bevelbox(x,y,x1,y1,lightgray,lightgray,darkgray,3);

{     setfillstyle(solidfill,white);
      Bar(x,y,x1,y1);
      setcolor(black);
      rectangle(x,y,x1,y1);
}
   end;

procedure closemenuframe(ifs:ImageStkPtr; ms: MsClickPtr);
   begin
      if ifs<>pendactive then
	 begin
	    if frameexist(pendactive) then
	       closeframe(pendactive);
	    setpendingoff;
	 end;
   end;

procedure OpenOptionMenu(x,y:Word; OM:OptionMPtr);
   VAR x1,y1	  : Word;
   BEGIN
      x1 := x + OM^.MaxWidth + 12;
      y1 := y+2+OM^.Numofentries*textheight('A')+8;
      pendactive := openframe(x,y,x1,y1,openmenuredraw);
      pendcallproc := closemenuframe;
      hidemouse;
      ListOptionMenu(pendactive,OM);
      showmouse;
   END;

end.
