program getGIFheader ;
uses dos ;
const
 progdata = 'GRR- Free DOS utility: GIF file info displayer.';
 progdat2 = 'V1.00: August 19, 1993. (c) 1993 by David Daniel Anderson - Reign Ware.';
 usage = 'Usage:  GRR directory and/or file_spec[.GIF]   Example:  GRR cindyc*';
var
   header  : string [6] ;

   gpixn   : byte ;

   gpixels , gback,
   rwidthLSB,
   rheightLSB,
   rwidth,
   rheight : char ;

   gifname : string [12] ;
   giffile : text ;

   dirinfo : searchrec ;
   gpath   : pathstr ;
   gdir    : dirstr ;
   gname   : namestr ;
   gext    : extstr ;

procedure showhelp;
begin
     writeln (progdata);
     writeln (progdat2);
     writeln (usage);
     halt ;
end;

function taffy ( astring : string; newlen : byte) : string;
begin
    while ( length ( astring ) < newlen ) do
            astring := astring + ' ' ;
    taffy := astring;
end;

FUNCTION LeadingZero(w : Word) : String;
VAR
  s : String;
BEGIN
  Str(w:0,s);
  IF Length(s) = 1 THEN
    s := '0' + s;
  LeadingZero := s;
END;

procedure writeftime ( fdatetime : longint );
var
   Year2           : String ;
   DateTimeInf     : DateTime ;
begin
   UnpackTime( fdatetime,DateTimeInf);
   WITH DateTimeInf DO
   BEGIN
        Year2 := LeadingZero(Year);
        Delete(Year2,1,2);
        Write  (
                LeadingZero(Month)     ,'-',
                LeadingZero(Day)       ,'-',
                Year2                  ,'  ',
                LeadingZero(Hour)      ,':',
                LeadingZero(Min)       ,':',
                LeadingZero(Sec)
               );
   END;
end;

procedure displaygifscreenstats ( screendes : byte );
var
   GCM : Boolean ;

begin
     GCM := screendes > 128;
     if screendes > 128 then
        screendes := screendes - 128;
     if screendes > 64 then
        screendes := screendes - 64;
     if screendes > 32 then
        screendes := screendes - 32;
     if screendes > 16 then
        screendes := screendes - 16;
     if screendes > 8 then
        screendes := screendes - 8;
     case screendes of
       0 : write ( '  2' );
       1 : write ( '  4' );
       2 : write ( '  8' );
       3 : write ( ' 16' );
       4 : write ( ' 32' );
       5 : write ( ' 64' );
       6 : write ( '128' );
       7 : write ( '256' );
     end;
     If GCM Then
        Write (' ]  GCM/')
     Else
        Write (' ]  ---/');

end;

procedure checkforgiflite ( VAR thefile : text );
var
   ic            : word ;
   dummy, glite  : char ;
   gliteword     : string [7] ;

begin
          for ic := 13 to 784 do
              read ( thefile, dummy );

          gliteword := '       ' ;
          for ic := 1 to 7 do begin
              read ( thefile, glite );
              gliteword[ic] := glite ;
          end ;

          if ( pos ( 'GIFLITE', gliteword ) = 1 ) then
             write ( 'GL' )
          else
             write ( '--' );
end;

begin
     gpath := '' ;
     gpath := paramstr ( 1 );
     if ( gpath = '' ) then
        gpath := '*.gif' ;

     if ( pos ( '.',gpath ) <> 0 ) then begin
        gpath := copy ( gpath,1,pos ( '.',gpath ));
        gpath := gpath + 'gif'
     end
     else gpath := gpath + '*.gif' ;

     fsplit ( fexpand ( gpath ) ,gdir,gname,gext );
     findfirst ( gpath, archive, dirinfo );
     if doserror <> 0 then showhelp;
     while doserror = 0 do
     begin
          gifname := dirinfo.name;
          assign ( giffile, gdir + gifname );
          reset ( giffile );
          read ( giffile,header );
          if ( pos ( 'GIF' , header ) <> 1 )
             then header := '?_GIF?' ;
 read ( giffile, rwidthLSB , rwidth , rheightLSB , rheight , gpixels , gback );

          gifname := taffy(gifname,12);
          write ( gifname , '  ', dirinfo.size:7 ,'  ');
          writeftime ( dirinfo.time );
          write ( '    ',header,'   [' );

          write (( ord ( rwidthLSB  ) + ( 256 * ord ( rwidth  ))) :4, ' ' ,
                 ( ord ( rheightLSB ) + ( 256 * ord ( rheight ))) :4, '  ' );

          gpixn := ord ( gpixels );
          displaygifscreenstats ( gpixn );

{         write ( ', ', ord ( gback )); } { This is the background color,}
          checkforgiflite ( giffile );  { commented out since it is not used }

          writeln ;
          close ( giffile );
          findnext ( dirinfo );
     end ;
end.
