program figdemo;

uses
  graph,crt,grphglob,figures;




var
  aline          : line;
  next_aparabola_point_ptr   : pointptr;
  aparabola      : polyline;
  apolycircle    : polygon;
  apolyoctagon   : polygon;
  apolyellipse   : polygon;
  atriangle      : triangle;
  asquare        : square;
  apentagon      : pentagon;
  aheptagon      : heptagon;
  anarc          : arc;

  gd, gm         : integer;
  i,j,k          : integer;

{--------------------------------------------------------}
{ Example for figures                                    }
{--------------------------------------------------------}


procedure  aline_example;
begin
  aline.init(300,150,400,200,cyan,dashedln,0,thickwidth);
  aline.show;
  aline.stretchfirst(5);    {drag first point by 5 pixels with cursor keys}
  aline.lengthensecond(50); {lengthen second point by 50 pixels}
  delay(1000);
  aline.moveto(150,150);     {move point x,y to 50,50}
  delay(1000);
  aline.moverel(50,0);     {move the line 50 pixels right}
  delay(1000);
  aline.lengthenfirst(-50); {shorten first point by 50 pixels}
  aline.stretchsecond(10);  {drag second point by 10 pixels with cursor keys}
  aline.rotate(100,100,30); {rotate line about 100,100 by 30 degrees}
  delay(1000);
  aline.changestyle(yellow,solidln,0,normwidth); {change line parameters}
  aline.drag(5);            {drag the line with the cursor keys}
  aline.hide;
end;

procedure  apolyline_example;
var
  xvalue : integer;
  yvalue : integer;
  first  : boolean;

begin
  {a parabola is formed by the general equation y := a * x^2 + b * x + c
  for this example we will use the equation y := 1/4 * x^2  + 10
  set x axis at maxx div 2 and y axis at maxy}

  first := true;
  for xvalue := -31 to 30 do
    begin
      yvalue := round(sqr(xvalue)/ 4 + 10);
      if first then
	begin
	  aparabola.init(xvalue+320,yvalue,random(15)+1,
			       solidln,normwidth);      {create the first
							instance of the
							polyline}
	  first := false;
	end
      else
	aparabola.add(new(polylineptr,init(xvalue+320,yvalue,random(15)+1,
			       solidln,normwidth)));   {add the next points
							in the polyline}
    end;

  aparabola.show;

  aparabola.drag(5);

  aparabola.hide;

  aparabola.done; {dispose of dynamic memory for aparabola}

end;



procedure  apolygon_example;
var
  tempaspect : real;

begin
 apolyoctagon.init(maxx div 2,maxy div 2,50,8,cyan,slashfill,red,
		  solidln,thickwidth);
 apolyoctagon.fill;
 apolyoctagon.drag(5);
 apolyoctagon.rotate(20);
 delay(1000);
 apolyoctagon.hide;
 apolyoctagon.done;   {dispose of dynamic memory for polygon}


 apolycircle.init(maxx div 2,maxy div 2,50,30,cyan,slashfill,red,
		  solidln,thickwidth);
 apolycircle.fill;
 apolycircle.drag(5);
 apolycircle.hide;
 apolycircle.done;

 tempaspect := aspectfactor;

 aspectfactor := 0.75;
 apolyellipse.init(maxx div 2,maxy div 2,50,30,cyan,slashfill,red,
		  solidln,thickwidth);
 aspectfactor := tempaspect;

 apolyellipse.fill;
 apolyellipse.show;
 delay(1000);
 apolyellipse.expand(30);
 delay(1000);
 apolyellipse.drag(5);
 apolyellipse.hide;
 apolyellipse.done;

end;

procedure  atriangle_square_example;
var
 k : integer;
 tempaspect : real;

begin
  tempaspect := aspectfactor;

  for k:= 1 to 3 do
    begin

      atriangle.init(maxx div 2, maxy div 2, 50, green, solidfill, blue,
		     dottedln,thickwidth);
      atriangle.fill;
      atriangle.drag(5);
      atriangle.rotate(90);
      delay(1000);
      atriangle.expand(30);
      delay(1000);
      atriangle.hide;

      asquare.init(maxx div 2, maxy div 2, 50, blue, solidfill, white,
		     solidln,thickwidth);
      asquare.fill;
      asquare.drag(5);
      asquare.rotate(90);
      delay(1000);
      asquare.expand(30);
      delay(1000);
      asquare.hide;

      if k = 1 then
	aspectfactor := 2.0
      else
	aspectfactor := 0.75;
    end;

end;


procedure  apentagon_heptagon_example;
var
 k : integer;
 tempaspect : real;

begin
  tempaspect := aspectfactor;

  for k:= 1 to 3 do
    begin

      apentagon.init(maxx div 2, maxy div 2, 50, green, solidfill, blue,
		     dottedln,thickwidth);
      apentagon.fill;
      apentagon.drag(5);
      apentagon.rotate(90);
      delay(1000);
      apentagon.expand(30);
      delay(1000);
      apentagon.hide;

      aheptagon.init(maxx div 2, maxy div 2, 50, blue, solidfill, white,
		     solidln,thickwidth);
      aheptagon.fill;
      aheptagon.drag(5);
      aheptagon.rotate(90);
      delay(1000);
      aheptagon.expand(30);
      delay(1000);
      aheptagon.hide;

      if k = 1 then
	aspectfactor := 2.0
      else
	aspectfactor := 0.75;
    end;

end;
procedure  anarc_example;
begin
end;




{***********************************************}
{main                                           }
{***********************************************}

begin

  bgiinitgraph;   {initialize graphics and link driver}

  aline_example;
  apolyline_example;
  apolygon_example;
  atriangle_square_example;
  apentagon_heptagon_example;

  CloseGraph;

end.






