; GRAFTEXT - Fast text in graphics mode
;           Gsol - solid text procedure
;
; by Tim Godfrey 72617,2125
;
; version 2.0 - 2/19/93  updated for support of protected mode in BP7
;
data   segment word public
       assume DS:DATA
       extrn   pitch:WORD     ; number of bytes per scan line
       extrn   Seg0040:word
       extrn   SegA000:word
lpage   dw      ?               ; local storage for Page offset

data   ends



code      segment   byte public
assume    cs:code,ds:data
public    gsol
page 60,132
;                   val val val     val      VAR    VAR
; procedure gsol(gdx,gdy,color,fontlines,fontbase,instring);

; These equates define the BP relative passed parameters
gdx       equ  [BP+20]
gdy       equ  [BP+18]
backgnd   equ  [BP+16]
color     equ  [BP+14]
fontlines equ  [BP+12]
fontbase  equ  [BP+8]
instring  equ  [BP+4]
pitchBP   equ  [BP-4]     ; local pitch variable now stored on stack
                          ; pitch is not a passed parameter- see note below 

gsol proc    NEAR

     push      bp
     mov       bp,sp
     push      ds
     mov       ax,pitch        ; read pitch out of data segment
     push      ax              ; save pitch on stack at [BP-4]
                               ;
                               ; Note! Do not add anything that would change
                               ; the stack pointer between this push AX and
                               ; the push BP above without making a
                               ; corresponding change to the pitchBP EQU


; Calculate byte address (segment & offset) and bit mask

;
     push    ds
     mov     dx,Seg0040         ; bios data segment
     mov     ds,dx
     mov     si,062h
     mov     al,[si]       ; get active display page
     or      al,al
     jz      page0           ; if zero, skip ofset add
     mov     ax,8000h           ; set ax to 8000h
     jmp     setpage
page0:
     xor     ax,ax              ; clear page offset
setpage:
     pop     ds

     mov     lpage,ax   ; page offset value

     mov     dx,3CEh         ; Graphics Controller port address
     mov     ax,0205h        ; Writemode 2, Readmode 0, index 5
     out     dx,ax           ; select register 5 (mode)

     mov     dx,3C4h         ; Sequencer/Map Mode port address
     mov     ax,0F02h
     out     dx,ax           ; Select "Map Mask" register 2, enable all planes


;
     mov     bx,gdx          ; get X address from stack frame
     shr     bx,1
     shr     bx,1
     shr     bx,1            ; compute memory address ofset  BX := x/8
;
     les     SI,instring     ; get doulbleword base address of string
     xor     ch,ch           ; clear ch
     mov     cl,byte ptr ES:[si]  ; points to length of string
     or      cl,cl		; set flags
     jz	     nullstring      ; if length is zero, skip everything

     mov     ax,gdy          ; get Y address (a pixel row)
     add     ax,fontlines           ; add in lines in font as ofset to Y value
     dec     ax              ; subtract 1 because cx is 1 based inst. of 0
     mov     dx,pitch        ; DS is still correct
     mul     dx              ; AX := (y * 80)  ([pitch] bytes per row)
     add     dx,lpage   ; add in page offset;
     add     ax,bx           ; AX := (y * 80) + x/8          (offset)

     mov     di,ax           ; save EGA/VGA memory ofset in DI

     mov     dx,SegA000       ; base page of EGA/VGA memory
                             ; note: this variable is in main DS
     mov     ds,dx           ; DS := EGA/VGA buffer segment address

; Get the Graphics Controller register address
     mov     dx,3CEh         ; base: (offset is 8 for bitmask register)

strloop:                     ; loop for number of characters in string
     push    CX              ; save string count for outer loop
     inc     SI              ; make si point to nextchar
     mov     bl,byte ptr ES:[SI]      ; SI points to next char - read into bx
     inc     bl              ; increment char code : draw char from bot to top
     mov     ax,fontlines    ; get number of lines/char in font
     mov     cx,ax           ; keep for use as char-loop counter
     mul     bl              ; ax := bl (character) * al (bytes/char)
     mov     bx,ax           ; leave font character ofset in BX
     push    ES              ; save char string seg.
     push    SI              ; save char string pointer
     push    DI              ; save EGA/VGA destination
;
; loop for the number of lines
;

     les     SI,fontbase     ; get dblword base address of font
;
;
     dec     cx              ; one less pass thru loop, due to early latch read

     dec     bx              ; move UP to next scanline in font

     mov     ax,0FF08h            ; bit mask index = 8, mask = FFh
     out     dx,ax           ; enable all bits in bit mask into reg 8
;                            ; preserve bitmap index: 8 in AL

     mov     ah,byte ptr backgnd
     mov     [di],ah         ; Set all bits to "backgnd color".

     mov     ah,[di]         ; Latch the bit plane data with dummy read
                             ; latch only once for all writes this character

charloop:                    ; loop through the font's scanlines bottom to top


; Set bits in the appropriate bit planes by writing color value to EGA/VGA memory

     mov     ah,ES:[BX][SI]  ; get bit mask byte from font: bx=font char ofs
     out     dx,ax           ; load bit mask into reg 8

     mov     ah,color
     mov     [di],ah         ; write foreground color with bit mask.

;                            ; read pitch from BP stack frame
     sub     di,pitchBP      ; move up one line in EGA/VGA memory

     dec     bx              ; move UP to next scanline in font

     mov     ah,0FFh
     out     dx,ax           ; enable all bits in bit mask, reg 8
;
     mov     ah,backgnd
     mov     [di],ah         ; Set all bits to "backgnd color".


     loop    charloop        ; decrement cx and do next scanline

                             ; perform final foreground write

     mov     ah,ES:[BX][SI]  ; get bit mask byte from font: bx=font char ofs
     out     dx,ax           ; load bit mask into reg 8

     mov     ah,color
     mov     [di],ah         ; write foreground color with bit mask.


     pop     DI              ; get back EGA/VGA destination
     inc     DI              ; move screen position to next char over

     pop     SI              ; pop character pointer
     pop     ES              ;  "     "      segment

     pop     CX              ; get outer loop - counting chars in string
     loop    strloop

nullstring:
; Restore default EGA/VGA graphics status



                             ; dx already points do Graphics Controller
     mov     ax,0005h        ; write mode=0; read mode=0; index =5
     out     dx,ax           ; select register 5 (mode)

     mov     ax,0FF08h        ; reset bitmask register to all on
     out     dx,ax           ; ... Graphics Controller register 8

     pop       ax            ; discard pitch value from stack frame
     pop       ds
     pop       bp
     ret       16d
gsol endp

code ends

     end

