program FNTstrip;
{ strip header from font files}


Uses
  Dos,CRT,break;

type
   filenametype  =   string[24];
   fap           =   file;

var
   b             :   byte;
   source        :   fap;
   sourcename,
   destname      :   filenametype;
   term          :   text;           {CRT file type}
   multispec,indrvdir,outdrvdir     :   filenametype;
   recsread      :   integer;
   flag,batch    :   boolean;
   response      :   char;
   buffer        :   array[0..4096] of byte;


  Function Open(var f; name: Filenametype): boolean;
  var
    fp : file absolute f;
  begin
    Assign(fp,Name);
    {$I-}
    reset(fp,1);
    {$I+}
    If IOresult <> 0 then
     begin
      Open := False;
     end
    else
      Open := True;
  end { Open };


type

    string64 =    string[64];

var
    dest     :    fap;
    dta      :    SearchRec;  {in dos unit}
    reg      :    Registers;  {in dos unit}
    namestr  :    string[13];
    numfiles,return,atrib :    integer;
    dos_attr              :    byte;
    firstfile             :    boolean;


procedure getfilename(search:string64; var atr,out:integer);
var
   i,retcode  : integer;

begin
if firstfile  then begin
                   dos_attr := archive; { accept any file, including arc.}
                   findfirst(search,dos_attr,dta);
                   firstfile := FALSE;
                   end
              else
                   findnext(dta);

   if DosError = 18 then out := 0  {no files found}
   else if DosError <> 0 then out := -1            {error}
   else begin
      with dta do begin
              namestr := DTA.name;
              atr := dos_attr ;   {pass attribute}
      end;
      out := 1;
   end;
end; {of procedure getfilename}

procedure getspec;
begin
   write(term,'Enter drive and subdir prefix for ');
   textcolor(yellow);
   write(term,'input');
   textcolor(lightgray);
   write(' data files : ');
   readln(indrvdir);
   write(term,'Enter Filespec (CR for *.fnt) :');
   readln(multispec);
   if length(multispec) = 0 then multispec:='*.FNT';
end;


Function OpenIn(var MainFile: fap; var MainFileName: filenametype; mode:boolean) : boolean;
var
     exist           :  boolean;
     status          :  integer;
begin
OpenIn := TRUE;                   { the returned value of this function}
                                    { False indicated end of program}
    repeat
    if not mode then
         begin
           Write(term,'Enter Input FileName (CR to exit)  : ');
           readln(MainfileName);
           if Length(mainfilename)=0 then begin
               OpenIn := FALSE;
               writeln(term,'Exiting....');
               exit;
           end;
         end
      else
      begin
         if firstfile then begin
               getspec;
               writeln(term,'Converting files like ',indrvdir+multispec);
               end;
         repeat
             getfilename(indrvdir+multispec,atrib,status);
             if status = -1 then begin
                 writeln(term,'Invalid File Specification');
                 getspec;
                 firstfile := TRUE;
             end;
         until status<>-1 ;
         if status = 0 then begin
             writeln(term,'Batch operation completed');
             OpenIn := FALSE;
             exit;
         end;
         MainFileName := indrvdir+namestr;  {form filename to be read from}
      end;
    exist := Open(MainFile,MainFileName) ;
    if not exist then Writeln(term,'ERROR -- File not found:  ',MainFileName);
    until exist;
end {OpenIn};

Procedure OpenOut(var OutFile: fap; var OutFilename: filenametype);
var
    answer     :  string[10];
    Dir        : dos.DirStr;
    Name       : dos.NameStr;
    Ext        : dos.ExtStr;
    per        :  integer;
begin

    Fsplit(outfilename,dir,name,ext);    {remove source path}

    OutFileName := outdrvdir+name+ext;   {append to drive/dir info}

    Assign(OutFile,OutFileName);
    {$I-}
    reset(OutFile);
    {$I+}
    If IOresult = 0 then
    begin
      Write(term,OutFileName,' exists: Overwrite? (Y/N)  ');
      readln(answer);
      if upcase(answer[1])<>'Y' then Halt;
    end;
    writeln(term,'Opening ',outfilename);
    assign(outfile,outfilename);
    rewrite(outfile,1);
end {Open Out};


type
  hexstr = string[4];

function Hex(Number:Integer;Bytes:integer):hexstr;

const
  T : array[0..15] of char = '0123456789ABCDEF';

var
  D : integer;
  H : hexstr;

begin H[0]:=chr(bytes+bytes);
 for D:=bytes+bytes downto 1 do begin
   H[D]:=T[number and 15];
   Number:=Number shr 4;
 end;
 Hex:=H;
end;




procedure striphdr;
var
   snlen : integer;
   result,fsize  : word;
begin

   blockread(source,buffer,8);       { read first 8 bytes}
   fsize := buffer[4] * 256;      { get Y dimension for bytes/char }

   if (buffer[0]<> $AA) or (buffer[1]<>$55) then begin
      close(source);
      Writeln('This file is not in Tseng Labs .FNT font format!');
      halt;
      end;



   writeln('Font is ',buffer[4],' high, expecting ',fsize,' bytes');

   blockread(source,buffer,fsize,result);    {copy input file to buffer}
   close(source);

   if result<>fsize then begin
       writeln('Error reading file!');
       halt;
       end;


   destname := sourcename;
   openout(dest,destname);
   blockwrite(dest,buffer,result);
   close(dest);


end; {of procedure readlib}




{START OF MAIN PROGRAM}

begin
assignCRT(term);
rewrite(term);
write(term,'Use batch (wildcard) mode for multiple file conversions? (Y/N)  ');
readln(response);
if Upcase(response)='Y' then batch:= TRUE else batch := FALSE ;
firstfile := TRUE;
writeln(term);
writeln(term,'Output files are not renamed: Be sure the source and dest paths are different!');
write(term,'Drive and subdir prefix for ');
textcolor(yellow);
write(term,'output');
textcolor(lightgray);
writeln(term,' files (CR for none) ');
write(term,'(Include  \ on end of paths)'^M^J' :  ');
readln(outdrvdir);
writeln(term);

while OpenIn(source,sourcename,batch)=TRUE do begin
   writeln(term);
   writeln(term,'"',sourcename,'" opened for input');
   writeln(term);
   striphdr;            {reads entire file }
end; {of while nextfile=true section}
close(term);
end.
