{$I+}    {I/O checking on}
program GtxtDemo;      {Fast display of Text in Graphics mode.}
                       {works on horizontal 8 pixel boundaries }
                       {For EGA/VGA only - Bugs/problems/sugesstions welcomed!}
                       {Author: Tim Godfrey, 72617,2125 }
                       {Previous version loaded Fonts as .OBJ files into TPU }
                       { Version 27 Jan 89 }
                       {Fixed bug in ASMs causing eventual stack overflow}
                       {Added SetYOfset to allow "Pseudo Paging" for EGA modes}
                       {to write on second page, just add 350 to Y coordinates}
                       { Version 1 Feb 89 }
                       {Added true paging support of SetActivePage and }
                       { SetVisualPage from the Graph Unit}

                       { Version 7 Jul 89 }
                       { Added new Procedure SetGfont, eliminating requirement
                       { of passing the font data with every procedure call}
                       { Improved optimization of assembler }
                       { Added Pitch variable to support pixels per line other }
                       { than 640. Pitch is number of _bytes_ per scan line}


Uses
  opCrt,dos,Graph,graftext,mouselib;

type
   hstype        =   string[2];
   filenametype  =   string[24];

var
   err,fchar,xline,idx      :   integer;
   teststr                  :   string;
   resxstr,resystr          :   string[10];
   rowaray                  :   array [0..255] of byte;
   dot,fpix,lentxtpix       :   integer;
   maxtextlines             :   integer;
   akey                     :   char;
   numstr                   :   string[10];
   z,yofs,startaddr           :   word;
   inx                        :   integer;
   s_hr,s_min,s_sec,s_hs,e_hr,e_min,e_sec,e_hs : word;
   s_hsecs,e_hsecs,iterations                  : longint;
   reprate,deltasecs                           : real;

{----------------Graphics Support Section--------------------}


const
  { The names of the various device drivers supported }
  DriverNames : array[0..10] of string[8] =
  ('Detect', 'CGA', 'MCGA', 'EGA', 'EGA64', 'EGAMono',
   'RESERVED', 'HercMono', 'ATT400', 'VGA', 'PC3270');

  { The five fonts available }
  Fonts : array[0..4] of string[13] =
  ('DefaultFont', 'TriplexFont', 'SmallFont', 'SansSerifFont', 'GothicFont');

  { The five predefined line styles supported }
  LineStyles : array[0..4] of string[9] =
  ('SolidLn', 'DottedLn', 'CenterLn', 'DashedLn', 'UserBitLn');

  { The twelve predefined fill styles supported }
  FillStyles : array[0..11] of string[14] =
  ('EmptyFill', 'SolidFill', 'LineFill', 'LtSlashFill', 'SlashFill',
   'BkSlashFill', 'LtBkSlashFill', 'HatchFill', 'XHatchFill',
   'InterleaveFill', 'WideDotFill', 'CloseDotFill');

  { The two text directions available }
  TextDirect : array[0..1] of string[8] = ('HorizDir', 'VertDir');

  { The Horizontal text justifications available }
  HorizJust  : array[0..2] of string[10] = ('LeftText', 'CenterText', 'RightText');

  { The vertical text justifications available }
  VertJust   : array[0..2] of string[10] = ('BottomText', 'CenterText', 'TopText');

var
  GraphDriver : integer;  { The Graphics device driver }
  GraphMode   : integer;  { The Graphics mode value }
  MaxX, MaxY  : word;     { The maximum resolution of the screen }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }
  OldExitProc : Pointer;  { Saves exit procedure address }
  textx,texty : word;

Function BGIpath(bginame:string) : string;
var
     fullname : string;
     fpath,path1    : dirstr;
     Name     : NameStr;
     Ext      : ExtStr;
     p1len    : integer;
     path2    : string;
     found    : boolean;

begin
   fsplit(paramstr(0),path1,name,ext);
   p1len := length(path1);
   if not (path1[pred(p1len)]=':') then delete(path1,p1len,1);

   if length(path1)=0 then  {program directory is same as current directory}
      path2 := '.;'+getenv('PATH')
   else
      path2 := path1+';'+getenv('PATH');    {put program's directory in search path}

   fpath := fsearch(BGIname,path2);
   if fpath = '' then begin
      Write(bginame,' Not Found on path or program directory. Press any key.');
      repeat until keypressed;
      BGIpath := '';
      end
   else begin
      fsplit(fexpand(fpath),path1,name,ext);
      p1len := length(path1);
      if not (path1[pred(p1len)]=':') then delete(path1,p1len,1);
      BGIpath := path1;
      end;
end;



{$F+}
procedure MyExitProc;
begin
  ExitProc := OldExitProc; { Restore exit procedure address }
  CloseGraph;              { Shut down the graphics system }
end; { MyExitProc }
{$F-}

procedure Initialize;
{ Initialize graphics and report any errors that may occur }
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  OldExitProc := ExitProc;                { save previous exit proc }
  ExitProc := @MyExitProc;                { insert our exit proc in chain }
if (paramcount>0) and ((paramstr(1)='/V') or (paramstr(1)='/v')) then begin
  GraphDriver := VGA;
  graphmode := VGAHi;
  end
else if (paramcount>0) and ((paramstr(1)='/E') or (paramstr(1)='/e')) then begin

  GraphDriver := EGA;
  graphmode := EGAHi;
  end

  else
  graphdriver := detect;

  InitGraph(GraphDriver, graphmode,BGIpath('EGAVGA.BGI'));  { activate graphics }
  ErrorCode := GraphResult;               { error? }
  if ErrorCode <> grOk then
  begin
    Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
    writeln('(A /V parameter will force VGA mode.)');
    Halt(1);
  end;
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
end; { Initialize }


{_______________________________________________________}

{-----------------Mainline Program-----------------------}


begin

teststr := 'This is a test 01234567890 (8x8 font) ';

Initialize;  {graphics activation}

maxtextlines := (Maxy div 8) -1;
str(1+maxx,resxstr);
str(1+maxy,resystr);
teststr := resxstr+'x'+resystr+' test 01234567890 (8x8 font) ';


setfillStyle(widedotfill,lightgray);


Bar(0,0,Maxx,Maxy);
MouseSetLimits(0,0,MaxX,MaxY);

SetGfont(Thin8);
inx := 0;

mouseshow;

iterations := 0;
gettime(s_hr,s_min,s_sec,s_hs);
repeat
(*
  Gtxtsol(100,100+(inx*14),blue,inx,teststr);
*)
  for idx := 0 to 15 do
     Gtxtsol(8,(9*idx),blue,(idx+inx) and $F,teststr);
  for idx := 0 to 15 do
     Gtxtsol(8,(MaxY div 2)+(9*idx),red,(idx+inx) and $F ,teststr);
  for idx := 0 to 15 do
     Gtxtsol(10+(MaxX div 2),(9*idx),green,(idx+inx) and $F,teststr);
  for idx := 0 to 15 do
     Gtxtsol(10+(MaxX div 2),(MaxY div 2)+(9*idx),darkgray,(idx+inx) and $F,teststr);

(*
  line(0,0,inx*16,maxy);
  setcolor(inx);
*)
inx := (inx + 1) and $F;
inc(iterations);

until MousePressed or Keypressed;

gettime(e_hr,e_min,e_sec,e_hs);



if (keypressed) then readkey;
(* Akey := readkey; *)

CloseGraph;

s_hsecs := s_hs + 100 * (s_sec + (60 * (s_min + (60 * s_hr))));
e_hsecs := e_hs + 100 * (e_sec + (60 * (e_min + (60 * e_hr))));

deltasecs := (e_hsecs - s_hsecs) / 100.0 ;
reprate := iterations / deltasecs;

writeln(iterations,' iterations in ',deltasecs:7:2,' seconds = ',reprate:5:2,' per second.');
Writeln(Memavail div 1024,'K bytes available');

end.
