{$I+}    {I/O checking on}
program GtxtDemo;      {Fast display of Text in Graphics mode.}
                       {works on horizontal 8 pixel boundaries }
                       {For EGA/VGA only - Bugs/problems/sugesstions welcomed!}
                       {Author: Tim Godfrey, 72617,2125 }
                       {Previous version loaded Fonts as .OBJ files into TPU }
                       { Version 27 Jan 89 }
                       {Fixed bug in ASMs causing eventual stack overflow}
                       {Added SetYOfset to allow "Pseudo Paging" for EGA modes}
                       {to write on second page, just add 350 to Y coordinates}
                       { Version 1 Feb 89 }
                       {Added true paging support of SetActivePage and }
                       { SetVisualPage from the Graph Unit}

                       { Version 7 Jul 89 }
                       { Added new Procedure SetGfont, eliminating requirement
                       { of passing the font data with every procedure call}
                       { Improved optimization of assembler }
                       { Added Pitch variable to support pixels per line other }
                       { than 640. Pitch is number of _bytes_ per scan line}

                       { Version 8 Mar 93 }
                       { Added support for Borland Pascal 7 Protected Mode }
                       { Improved optimization of assembler }
                       { Fixed bugs that could cause mouse droppings }


Uses
  Crt,dos,Graph,graftext
{$ifdef SVGA}
  ,is16det
{$endif}
  ;

type
   hstype        =   string[2];
   filenametype  =   string[24];

var
   err,fchar,xline,idx      :   integer;
   teststr                  :   string;
   resxstr,resystr          :   string[10];
   rowaray                  :   array [0..255] of byte;
   dot,fpix,lentxtpix       :   integer;
   maxtextlines             :   integer;
   akey                     :   char;
   numstr                   :   string[10];
   z,yofs,startaddr           :   word;

{----------------Graphics Support Section--------------------}


const
  { The names of the various device drivers supported }
  DriverNames : array[0..10] of string[8] =
  ('Detect', 'CGA', 'MCGA', 'EGA', 'EGA64', 'EGAMono',
   'RESERVED', 'HercMono', 'ATT400', 'VGA', 'PC3270');

  { The five fonts available }
  Fonts : array[0..4] of string[13] =
  ('DefaultFont', 'TriplexFont', 'SmallFont', 'SansSerifFont', 'GothicFont');

  { The five predefined line styles supported }
  LineStyles : array[0..4] of string[9] =
  ('SolidLn', 'DottedLn', 'CenterLn', 'DashedLn', 'UserBitLn');

  { The twelve predefined fill styles supported }
  FillStyles : array[0..11] of string[14] =
  ('EmptyFill', 'SolidFill', 'LineFill', 'LtSlashFill', 'SlashFill',
   'BkSlashFill', 'LtBkSlashFill', 'HatchFill', 'XHatchFill',
   'InterleaveFill', 'WideDotFill', 'CloseDotFill');

  { The two text directions available }
  TextDirect : array[0..1] of string[8] = ('HorizDir', 'VertDir');

  { The Horizontal text justifications available }
  HorizJust  : array[0..2] of string[10] = ('LeftText', 'CenterText', 'RightText');

  { The vertical text justifications available }
  VertJust   : array[0..2] of string[10] = ('BottomText', 'CenterText', 'TopText');

var
  GraphDriver : integer;  { The Graphics device driver }
  GraphMode   : integer;  { The Graphics mode value }
  MaxX, MaxY  : word;     { The maximum resolution of the screen }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }
  OldExitProc : Pointer;  { Saves exit procedure address }
  textx,texty : word;
  paramstr1   : string[20];

Function BGIpath(bginame:string) : string;
var
     fullname : string;
     fpath,path1    : dirstr;
     Name     : NameStr;
     Ext      : ExtStr;
     p1len    : integer;
     path2    : string;
     found    : boolean;

begin
   fsplit(paramstr(0),path1,name,ext);
   p1len := length(path1);
   if not (path1[pred(p1len)]=':') then delete(path1,p1len,1);

   if length(path1)=0 then  {program directory is same as current directory}
      path2 := '.;'+getenv('PATH')
   else
      path2 := path1+';'+getenv('PATH');    {put program's directory in search path}

   fpath := fsearch(BGIname,path2);
   if fpath = '' then begin
      Write(bginame,' Not Found on path or program directory. Press any key.');
      repeat until keypressed;
      BGIpath := '';
      end
   else begin
      fsplit(fexpand(fpath),path1,name,ext);
      p1len := length(path1);
      if not (path1[pred(p1len)]=':') then delete(path1,p1len,1);
      BGIpath := path1;
      end;
end;



{$F+}
procedure MyExitProc;
begin
  ExitProc := OldExitProc; { Restore exit procedure address }
  CloseGraph;              { Shut down the graphics system }
end; { MyExitProc }
{$F-}

procedure Initialize;
{ Initialize graphics and report any errors that may occur }
begin
  { when using Crt and graphics, turn off Crt's memory-mapped writes }
  DirectVideo := False;
  OldExitProc := ExitProc;                { save previous exit proc }
  ExitProc := @MyExitProc;                { insert our exit proc in chain }

paramstr1 := paramstr(1);
for z := 1 to length(paramstr1) do
   paramstr1[z] := upcase(paramstr1[z]);

if (paramcount>0) and (paramstr1='/V') then begin
  GraphDriver := VGA;
  graphmode := VGAHi;
  end
else if (paramcount>0) and ((paramstr1='/E')) then begin

  GraphDriver := EGA;
  graphmode := EGAHi;
  InitGraph(Graphdriver, graphmode,BGIpath('EGAVGA.BGI'));
  end

  else
{$ifdef SVGA}
       {support for supervga modes}
      if (paramcount>0) and ((paramstr1='/800') or (paramstr1='/1K')) then
          begin
          Graphdriver := InstallUserDriver('ISVGA16',@_DetectISVGA16);
          Graphdriver := DETECT;
          InitGraph(Graphdriver, graphmode,BGIpath('ISVGA16.BGI'));
          if (paramstr1='/1K') then begin
            setgraphmode(tsg16_1024x768);
            pitch := 128;
            end
          else begin
            setgraphmode(tsg16_800x600);
            pitch := 100;
            end;
          end
      else  begin
          graphdriver := detect;
          InitGraph(Graphdriver, graphmode,BGIpath('EGAVGA.BGI'));
          end;

{$else}

  InitGraph(GraphDriver, graphmode,BGIpath('EGAVGA.BGI'));  { activate graphics }
{$endif}

  ErrorCode := GraphResult;               { error? }
  if ErrorCode <> grOk then
  begin
    Writeln('Graphics error: ', GraphErrorMsg(ErrorCode));
    writeln('Note - as written, this program expects to find EGAVGA.BGI in the');
    writeln('parent of the current directory. A /V parameter will force VGA mode.');

    Halt(1);
  end;
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
end; { Initialize }


type hexstr = string[10];

function Hex(Number:Integer;Bytes:integer):hexstr;

const
  T : array[0..15] of char = '0123456789ABCDEF';

var
  D : integer;
  H : hexstr;

begin H[0]:=chr(bytes+bytes);
 for D:=bytes+bytes downto 1 do begin
   H[D]:=T[number and 15];
   Number:=Number shr 4;
 end;
 Hex:=H;
end;




{_______________________________________________________}

{-----------------Mainline Program-----------------------}


begin

teststr := 'This is a test 01234567890 (8x8 font) ';

Initialize;  {graphics activation}

maxtextlines := (Maxy div 8) -1;
str(1+maxx,resxstr);
str(1+maxy,resystr);
teststr := resxstr+'x'+resystr+' test 01234567890 (8x8 font) ';


setfillStyle(widedotfill,darkgray);


Bar(0,0,Maxx,Maxy);

SetGfont(Thin8);

for idx := 0 to 15 do
   Gtxtsol(8,(9*idx),blue,idx,teststr);
for idx := 0 to 15 do
   Gtxtsol(8,(MaxY div 2)+(9*idx),red,idx,teststr);
for idx := 0 to 15 do
   Gtxtsol(10+(MaxX div 2),(9*idx),green,idx,teststr);
for idx := 0 to 15 do
   Gtxtsol(10+(MaxX div 2),(MaxY div 2)+(9*idx),darkgray,idx,teststr);


   Akey := readkey;


{----------------------------------}

Bar(0,0,Maxx,Maxy);

SetGfont(Thin14);
teststr := resxstr+'x'+resystr+' test 01234567890 (8x14 font) ';

for idx := 0 to 7 do
   Gtxtsol(8,(15*idx),blue,idx,teststr);
for idx := 0 to 7 do
   Gtxtsol(8,(MaxY div 3)+(15*idx),red,idx,teststr);
for idx := 0 to 7 do
   Gtxtsol(10+(MaxX div 2),(15*idx),green,idx,teststr);
for idx := 0 to 7 do
   Gtxtsol(10+(MaxX div 2),(MaxY div 3)+(15*idx),darkgray,idx,teststr);
for idx := 0 to 7 do
   Gtxttran(8,(2*(MaxY div 3))+(15*idx),idx,teststr);
for idx := 0 to 7 do
   Gtxttran(10+(MaxX div 2),(2*(MaxY div 3))+(15*idx),8+idx,teststr);


Akey := readkey;

GtxtSol(0,450,blue,white,'Scrolled image. This line is 450, top is 350');

for yofs := 0 to 350 do begin   {use loop here to make scrolling visible}
    delay(2);
    SetYofset(yofs);
    end;

Akey := readkey;

for yofs :=  349 downto 0 do begin        {Smooth scroll back down}
    delay(2);
    SetYofset(yofs);
    end;

Akey := readkey;
Bar(0,0,Maxx,Maxy);

if maxy<= 350 then begin    {paging not available at 480 lines}
                            {bug in Graph unit causes overwriting of
                             loaded-high program in B000 segment!}

    setactivepage(1);
    setvisualpage(1);

    setfillStyle(ltbkSlashFill,darkgray);
    Bar(0,0,Maxx,Maxy);
    setcolor(green);
    line(0,0,maxx,maxy);
    GtxtSol(0,10,blue,white,'Now on second page using SetActivePage(1)');
    GtxtSol(8,100,blue,white,'BIOS buffer addr = '+hex(mem[$40:$4E],1));
    GtxtSol(8,200,blue,white,'BIOS vid.page addr= '+hex(mem[$40:$62],1));

    If maxy>350 then begin
        GtxtSol(0,300,blue,white,'As you can see, there aren''t two');
        GtxtSol(0,315,blue,white,'independant pages available in');
        GtxtSol(0,330,blue,white,'480 line graphic modes');
        GtxtSol(0,345,blue,white,'Run GTXTDEMO with /E switch');
        GtxtSol(0,360,blue,white,'To see paging at EGA 350 lines');

        end;



    Akey := readkey;
    setactivepage(0);
    setvisualpage(0);
    GtxtSol(0,50,blue,white,'Now on first page using SetActivePage(0)');
    GtxtSol(8,100,blue,white,'BIOS buffer addr = '+hex(mem[$40:$4E],1));
    GtxtSol(8,200,blue,white,'BIOS vid.page addr= '+hex(mem[$40:$62],1));
    Akey := readkey;

    {rapidly alternate between pages}
    for z := 1 to 12 do begin
      delay(12);
      setvisualpage(1);
      delay(12);
      setvisualpage(0);
      end;
    end;

teststr := 'These lines use GtxtSol for speed';
setfillStyle(widedotfill,darkgray);
Bar(0,0,Maxx,Maxy);

SetGfont(Thin8);
for idx := 0 to maxtextlines do
   GtxtSol(8,(8*idx),black,idx mod 15,teststr);

teststr := 'These lines use OutTextXY ..slower.';

setfillstyle(solidfill,black);
for idx := 0 to maxtextlines do  begin
   setcolor(idx mod 15);                      {separate command to set color}
   bar((MaxX div 2),(8*idx),(MaxX div 2)+textwidth(teststr),(8*idx)+textheight(teststr));
                                                        {clear background}
   outtextxy((MaxX div 2),(8*idx),teststr);                      {write the string}
   end;


Akey := readkey;

setfillStyle(widedotfill,darkgray);
teststr := 'These lines use GtxtTran for speed';
Bar(0,0,Maxx,Maxy);

setfillstyle(solidfill,green);
bar(0,0,maxx div 16,maxy);
setfillstyle(solidfill,red);
bar(maxx div 16,0,maxx div 8,maxy);
setfillstyle(solidfill,blue);
bar(maxx div 8,0,3*maxx div 16,maxy);
setfillstyle(solidfill,darkgray);
bar(3*maxx div 16,0,maxx div 4,maxy);



for idx := 0 to maxtextlines do
   Gtxttran(8,(8*idx),idx mod 15,teststr);

teststr := 'These lines use OutTextXY ..slower.';


for idx := 0 to maxtextlines do  begin
   setcolor(idx mod 15);
   outtextxy((MaxX div 2),(8*idx),teststr);
   end;


Akey := readkey;

setfillStyle(SOLIDfill,BLACK);
teststr := 'Various Fonts can be BINOBJ''ed and added';
Bar(0,0,Maxx,Maxy);

SetGfont(Brdwy19);
for idx := 0 to 5 do
   Gtxttran(0,(20*idx),idx+2,teststr);

SetGfont(Sans19);
for idx := 0 to 5 do
   Gtxttran(100,(maxy div 3)+(20*idx),idx+2,teststr);

SetGfont(Wndw19);
for idx := 0 to 5 do
   Gtxttran(200,(maxy div 3)*2+(20*idx),idx+2,teststr);


Akey := readkey;

CloseGraph;
end.
