unit GrafText;
  {
    ======================================================================
    A Unit for Fast display of Text in Graphics mode.
    Includes 8, 14, 16, and 19 line fonts.
    A faster but more limited alternative to OutTextXY.
    Works only on horizontal 8 pixel boundaries, but on any scan line.
    Designed for EGA/VGA only.
    Uses built in fonts (.OBJ files in TPU)
    Uses PITCH variable to allow varying number of bytes per scan line.
    New procedure, SetGfont, to select fonts instead of including font
      in call.
    Supports SetActivePage and SetVisualPage functions of GRAPH unit
      when using 350 line EGA modes.

    Author: Tim Godfrey, 72617,2125
    Version: 7 July 89

    note: this code modified 29 November 91 / JJLeier
    =====================================================================
  }

  interface

    type
      Gfonts = (Thin6,Thin8,Thin14,Thin16,Brdwy19,Wndw19,Sans19,LastFontMarker);

    const
      GfontHgts : array[0..ord(LastFontMarker)-1] of byte = (6,8,14,16,19,19,19);

    var
       pitch     : word;
       fontlines : word;

    procedure GTxtTran (gdx,gdy,color:word;st:string);
    procedure GTxtSol  (gdx,gdy,backgnd,color:word;st:string);
    procedure SetGFont (newfont:Gfonts);
    procedure SetYOfset(yofs:word);  { number scan lines to scroll up screen }

  implementation

    var
       fontpointer : pointer;

    {$L GrafTex1}
    procedure GTran (gdx,gdy,color,fontlines : word;
      fontpointer : pointer; var st : string);
    external;

    {$L GrafTex2}
    procedure Gsol (gdx,gdy,backgnd,color,fontlines : word;
      fontpointer : pointer; var st : string);
    external;

    procedure GTxtTran (gdx,gdy,color : word; st : string);
      { a transparent text writing routine}
      begin
        GTran(gdx,gdy,color,fontlines,fontpointer,st);
      end; { procedure GTxtTran }

    procedure GTxtSol (gdx,gdy,backgnd,color : word; st : string);
      { a text writing routine with solid background}
      begin
        GSol(gdx,gdy,backgnd,color,fontlines,fontpointer,st);
      end; { procedure GTxtSol }

    { link in the supported fonts }
    { note: to save code space, comment out links for unused fonts }


    {$L 6x8.obj}
    procedure Font6;
    external;

    {$L 8x8.obj}
    procedure Font8;
    external;

    {$L 8x14.obj}
    procedure Font14;
    external;

    {$L 8x16.obj}
    procedure Font16;
    external;

    {$L Sans19.obj}
    procedure Sans1F19;
    external;

    {$L Wndws19.obj}
    procedure WindowsF19;
    external;

    {$L Brdw19.obj}
    procedure BroadwayF19;
    external;

    procedure SetGFont (newfont : Gfonts);
      { activate a new font for the graftext calls. }
      { set globals and point to linked in font file }
      begin
        case newfont of
          Thin6 :
            begin
              fontlines := 8;
              FontPointer := @Font6;
            end; { case thin6 }
          Thin8 :
            begin
              fontlines := 8;
              FontPointer := @Font8;
            end; { case thin8 }
          Thin14 :
            begin
              fontlines := 14;
              FontPointer := @Font14;
            end; { case thin14 }
          Thin16 :
            begin
              fontlines := 16;
              FontPointer := @Font16;
            end; { case thin16 }
          Brdwy19 :
            begin
              fontlines := 19;
              FontPointer := @BroadwayF19;
            end; { case broadway19 }
          Wndw19 :
            begin
              fontlines := 19;
              FontPointer := @WindowsF19;
            end; { case windows19 }
          Sans19 :
            begin
              fontlines := 19;
              FontPointer := @Sans1F19;
            end; { case sans19 }
        end; { case newfont }
      end; { procedure SetGFont }

    procedure SetYOfset (yofs : word);
      begin
        { set CRT controller Start Address hi/low }
        yofs := yofs * pitch;   {scale from scan lines to bytes}
        port[$3d4] := $C;
        port[$3d5] := hi(yofs);
        port[$3d4] := $D;
        port[$3d5] := lo(yofs);
      end;

begin
  {
    the pitch variable allows operation with
    SuperVGA modes: for example 800x600
    would have a pitch of 100.
    pitch is number of bytes per scan line.
  }
  pitch := 80;  { default pitch for 640 by x modes }
  Fontlines := 8;           {default Font}
  FontPointer := @Font8;
end.
