; GRAFTEXT - Fast text in graphics mode
;           Gtran - transparent text procedure
;
; by Tim Godfrey 72617,2125
;
; version 2.0 - 2/19/93  updated for support of protected mode in BP7
;
data   segment word public
       assume DS:data
       extrn   pitch:WORD     ; number of bytes per scan line
       extrn   Seg0040:word   ; Pmode selector for bios data area
       extrn   SegA000:word   ; Pmode selector for ega/vga graphics page
lpage   dw      ?               ; local Dseg storage for Page offset
data   ends

code   segment   byte public
assume  cs:code,ds:data
public    gtran
page 60,132
;                    val val val     val      VAR    VAR
; procedure gtran(gdx,gdy,color,fontlines,fontbase,instring);
; transparent text writing
;
; These equates define the BP relative passed parameters
gdx       equ  [BP+18]
gdy       equ  [BP+16]
color     equ  [BP+14]
fontlines equ  [BP+12]
fontbase  equ  [BP+8]
instring  equ  [BP+4]

pitchBP   equ  [BP-4]

gtran proc    NEAR

     push      bp
     mov       bp,sp
     push      ds
     mov       ax,pitch
     push      ax              ; save pitch on stack frame (at bp-4)
                               ;
                               ; Note! Do not add anything that would change
                               ; the stack pointer between this push AX and
                               ; the push BP above without making a
                               ; corresponding change to the pitchBP EQU

; Calculate byte address (segment & offset) and bit mask
;
     push    ds
     mov     dx,Seg0040         ; bios data segment
     mov     ds,dx
     mov     si,062h
     mov     al,[si]         ; get active display page from BIOS
     or      al,al           ; set flags - only 2 pages possible, 0 and 1
     jz      page0           ; if zero, skip ofset add
     mov     ax,8000h        ; set ax to 8000h for page 1
     jmp     setpage
page0:
     xor     ax,ax           ; clear page offset
setpage:
     mov     lpage,ax        ; page offset value
     pop     ds


     mov     dx,3CEh         ; Graphics Controller port address
     mov     ax,0205h        ; WriteMode 2, Readmode 0 at index 5
     out     dx,ax           ; select register 5 (mode)
     mov     dx,3C4h         ; Sequencer/Map Mode port address
     mov     ax,0F02h
     out     dx,ax           ; Select "Map Mask" register 2, enable all planes

;
     mov     bx,gdx          ; get X address from stack frame
     shr     bx,1
     shr     bx,1
     shr     bx,1            ; compute memory address ofset  BX := x/8
;
     les     SI,instring     ; get doulbleword base address of string
     xor     ch,ch           ; clear ch
     mov     cl,byte ptr ES:[si]  ; points to length of string
     or      cl,cl		; set flags
     jz	     nullstring      ; if length is zero, skip everything

     mov     ax,gdy          ; get Y address (a pixel row)
     add     ax,fontlines    ; add in lines in font as ofset to Y value
     dec     ax              ; subtract 1 because cx is 1 based inst. of 0
     mov     dx,pitch
     mul     dx              ; AX := (y * 80)  (80 bytes per row)
     add     dx,lpage        ; add in page offset (1/2 of buffer);
     add     ax,bx           ; AX := (y * 80) + x/8          (offset)

     mov     di,ax           ; save EGA/VGA memory ofset in DI
                             ;
     mov     dx,SegA000      ; selector to base page of EGA/VGA memory
                             ; note: this variable is in main DS
     mov     ds,dx           ; DS := EGA/VGA buffer segment address

; Get the Graphics Controller address
     mov     dx,3CEh         ; base register (offset has to be 8 for bitmask)

strloop:                     ; loop for number of characters in string
     push    CX              ; save string count for outer loop
     inc     SI              ; make si point to nextchar
     mov     bl,byte ptr ES:[SI]      ; SI points to next char - read into bx
     inc     bl              ; increment char code : draw char from bot to top
     mov     ax,fontlines    ; get number of lines/char in font
     mov     cx,ax           ; keep for use as char-loop counter
     mul     bl              ; ax := bl (character) * al (bytes/char)
     mov     bx,ax           ; leave font character ofset in BX
     push    ES              ; save char string seg.
     push    SI              ; save char string pointer
     push    DI              ; save EGA/VGA destination
;
; loop for the number of lines
;

     les     SI,fontbase     ; get dblword base address of font
;
     mov     al,8            ; bit mask index


charloop:                    ; loop through the font's scanlines bottom to top

     dec     bx              ; move UP to next scanline in font

     mov     ah,ES:[BX][SI]  ; get bit mask byte from font: bx=font char ofs
     out     dx,ax           ; load the bit mask into reg 8
;
; Set bits in the appropriate bit planes by writing color value to EGA/VGA memory

     mov     ah,[di]         ; Latch the bit plane data with dummy read
     mov     ah,byte ptr color ; get the color value
     mov     [di],ah         ; Set bits to '1' in appropriate planes.
;
;                            ; read pitch from BP stack frame
     sub     di,pitchBP      ; move up one line in EGA/VGA memory
     loop    charloop        ; decrement cx and do next scanline



     pop     DI              ; get back EGA/VGA destination
     inc     DI              ; move screen position to next char over

     pop     SI              ; pop character pointer
     pop     ES              ;  "     "      segement

     pop     CX              ; get outer loop - counting chars in string
     loop    strloop

nullstring:
; Restore default EGA/VGA graphics status

                       ; dx still points to Graphics Controller port address
     mov     ax,0005h        ; write mode=0: read mode=0: index=5
     out     dx,ax           ; select register 5 (mode)

     mov     ax,0FF08h        ; reset bitmask register to all on
     out     dx,ax           ; ... Graphics Controller register 8

     pop       ax            ; discard pitch value from stack frame
     pop       ds
     pop       bp
     ret       14d


gtran endp

code ends

     end
