(************************************************************************)
(*                                                                      *)
(*  Description         : Misc. constant- and typedeclarations          *)
(*                                                                      *)
(************************************************************************)

Unit
  Typ;

Interface

Const
   CEgaCtrl  = $03CE;
   CVideoSeg = $A000;
Type
   PByte     = ^Byte;
   PWord     = ^Word;
   PLong     = ^Longint;

   PByteArr  = ^TByteArr;
   TByteArr  = Array[1..64000] Of Byte;

   PfStr     = String[100];

   TGPaletteRec = Record
                     Red,
                     Green,
                     Blue   : Byte;
                  End;

   PGPalette    = ^TGPalette;
   TGPalette    = Array[0..255] Of TGPaletteRec;

   TGifDescrip  = Record
                     ScreenWidth,          (* Width and height for whole picture *)
                     ScreenHeight : Word;
                     GifInfo,

                     (* GIFInfo contains the following information:              *)
                     (* Bit 0000 0000                                            *)
                     (*     1xxx xxxx - True if theres a global palette          *)
                     (*     x111 xxxx - Bits/color                               *)
                     (*     xxxx 1xxx - Reserved                                 *)
                     (*     xxxx x111 - Bits per. Pixel (no. color) in the image *)

                     BackGround,           (* Evt. background color              *)
                     EofMark      : Byte;  (* Terminator for this  record        *)
                  End;

   TGifImageRec = Record
                     LeftOffset,           (* Image position related to the      *)
                     TopOffset,            (* whole image.                       *)
                     ImageWidth,           (* Width and height for this image    *)
                     ImageHeight  : Word;
                     ImageInfo    : Byte;

                     (* ImageInfo contains the following information:            *)
                     (* Bit 0000 0000                                            *)
                     (*     1xxx xxxx - True if local palette is to be used      *)
                     (*     x1xx xxxx - True if the image is interlaced          *)
                     (*     xx11 1xxx - Not Used                                 *)
                     (*     xxxx x111 - Bits per pixel (no. color) in the image  *)
                  End;


Implementation

End.