Program
   TestGif;

Uses
  (* Define Fast!*)

  (*$IfDef Fast!*)
  WGifAsm,
  (*$Else*)
  WriteGif,
  (*$Endif*)
  Graph;

Var
  Gd,Gm,I,X,Y: Integer;

  Procedure DrawTextBar(X1,Y1,X2,Y2: Integer);
  Begin
     X1:=X1-(X2 Div 2); X2:=X1+X2;
     Y1:=Y1-(Y2 Div 2); Y2:=Y1+Y2;

     SetFillStyle(SolidFill,LightGray);
     Bar(X1,Y1,X2,Y2);

     Inc(X1,4); Inc(Y1,4); Dec(X2,4); Dec(Y2,4);

     SetColor(DarkGray);
     RectAngle(X1,Y1,X2-1,Y2-1);
     PutPixel(X2,Y1,DarkGray); PutPixel(X1,Y2,DarkGray);
     SetColor(White);
     RectAngle(X1+1,Y1+1,X2,Y2);
  End;

Begin
   DetectGraph(Gd,Gm);
   InitGraph(Gd,Gm,'C:\bp\bgi');

   Randomize;

   I:=GraphResult;
   If I=0 Then
   Begin
      (* Make 300 boxes *)

      For I:=1 To 300 Do
      Begin
         X:=Random(Succ(GetMaxx)); Y:=Random(Succ(GetMaxy));
         SetFillStyle(Succ(Random(11)),Succ(Random(15)));

         Bar(X,Y,X+Random(150),Y+Random(100));
      End;

      DrawTextBar(320,240,350,150);
      SetColor(White);
      SetTextJustify(CenterText,CenterText);
      OutTextXy(320,210,'WRITEGIF.PAS &');
      OutTextXy(320,230,'WGIFASM.PAS');
      OutTextXy(320,270,'GIF write');

      WriteScreenToGif(16,'TestGif.Gif');
      CloseGraph;
   End Else
   Begin
      Writeln('Error during BGI init: '+GraphErrorMsg(I));
   End;
End.