{
  GETDECS.PAS - PUBLIC DOMAIN - JIM MURPHY - 74030,2643

  Program to read a .PAS file, and find all procedure, function,
  and overlay declarations, and write the declaration header to
  another file so it can be included in the initialization section
  of a unit.  The format for using the program from the command
  line is:

    getdecs <infilename> <outfilename> <return>

  Two parameters are required. Use CON or PRN as <outfilename> to
  send output to the SCREEN or PRINTER instead.

  The program will only find procedures and functions that begin
  in the first column of the input source file.  This is done so
  procedures/functions inside of, and local to a procedure or
  function will not be output.  Local procedures would normally be
  indented a few spaces from the left margin according to standard
  (more or less) indenting practices.
}


PROGRAM GETDECS;

var
  infvar:text;
  outfvar:text;


procedure getparams;

begin
  if paramcount<>2 then
  begin
    writeln('Incorrect parameter count.');
    writeln('Correct syntax is: getdecs <infilename> <outfilename>');
    writeln('Use CON or PRN as <outfilename> to send output to the');
    writeln('screen or printer respectively.');
    halt;
  end else
  begin
    if paramstr(1)=paramstr(2) then
    begin
      writeln('Duplicate filenames not allowed');
      halt;
    end;
  end;
end;  { end getparams }


procedure prepfiles;

begin
  assign(infvar,paramstr(1));
  assign(outfvar,paramstr(2));
  {$I-}
  reset(infvar);
  {$I+}
  if ioresult<>0 then
  begin
    writeln('Unable to find input file.');
    halt;
  end;
  {$I-}
  rewrite(outfvar);
  {$I+}
  if ioresult<>0 then
  begin
    writeln('Unable to open output file.');
    close(infvar);
    halt;
  end;
end;  { end prepfiles }


procedure finddecs;

const
  pro='PROCEDURE';
  fun='FUNCTION';
 ovr1='{OVERLAY}';
 ovr2='OVERLAY';

var
  instr:string;
  teststr:string;


  procedure toupper;

  var i:integer;

  begin
    for i:=1 to length(teststr) do
      teststr[i]:=upcase(teststr[i]);
  end;  { end toupper }


begin
  while not eof(infvar) do
  begin
    readln(infvar,instr);
    teststr:=instr;
    toupper;
    if pos(pro,teststr)=1 then writeln(outfvar,instr);
    if pos(fun,teststr)=1 then writeln(outfvar,instr);
    if pos(ovr1,teststr)=1 then
      writeln(outfvar,copy(instr,11,length(instr)-10));
    if pos(ovr2,teststr)=1 then
      writeln(outfvar,copy(instr,9,length(instr)-8));
  end;
  close(infvar);
  close(outfvar);
end;  { end finddecs }


BEGIN
  getparams;
  prepfiles;
  finddecs;
END.