
program TestWait;
uses
  crt,
  FastWait;

var
  Counter : word;
  jj : longint;

BEGIN
  clrscr;
  HighVideo;
  writeln('           Southern Software  (c) 1991'#10);
  LowVideo;
  writeln('This test compares the standard "delay" routine with our new "Wait"');
  writeln('procedure.  Below is the calculated number of small loops the PC goes');
  writeln('through for one millisecond delay.  If this number is above 1,191 then');
  writeln('the "delay" routine in the Turbo CRT unit as well as those in the');
  writeln('TurboPower Software Object Professional and Turbo Professional series');
  writeln('will yield delays that are too short.  Our "wait" procedure is the same');
  writeln('as the "delay" procedure except that it will adjust for faster machines.');
  writeln;
  writeln('The looping below is for 10 seconds in each case.  The seconds are shown');
  writeln('and at the end, the number of BIOS ticks is shown.  A properly calibrated');
  writeln('delay routine should be almost exactly 10 seconds long, which is 182 ticks.');
  writeln;
  writeln('To abort at any time, press any key.');
  writeln(#10);
  write('The delay factor for this machine is actually ');
  HighVideo;
  writeln(WaitOneMS);
  LowVideo;
  writeln(#10);
  writeln('10 second delays using');
  write('    CRT unit "delay" : ');
  HighVideo;
                   (* Delay 10 seconds using the CRT unit "delay" routine.  *)
  jj := BIOSTick;
  repeat
  until (jj <> BIOSTick);
  jj := BIOSTick;
  for Counter := 1 to 10 do 
    begin
      delay(1000);
      write(Counter)
    end;
  jj := (BIOSTick - jj);
  LowVideo;
  write('         BIOS Ticks : ');
  HighVideo;
  writeln(jj);
  LowVideo;
  write('FastWait unit "wait" : ');
  HighVideo;
                   (* Delay 10 seconds using FastWait unit "wait" routine.  *)
  jj := BIOSTick;
  repeat
  until (jj <> BIOSTick);
  jj := BIOSTick;
  for Counter := 1 to 10 do 
    begin
      wait(1000);
      write(Counter)
    end;
  jj := (BIOSTick - jj);
  LowVideo;
  write('         BIOS Ticks : ');
  HighVideo;
  writeln(jj, #10);
  LowVideo;
  write('Press any key to end ');
  repeat
  until keypressed;
  while keypressed do
    Counter := ord(ReadKey);
  clrscr
END.

