USES CRT,GRAPH,FFONT55;

VAR driver,mode : integer;
     FontBuffer : array[0..20000] of byte;
             TF : FontObj;

FUNCTION LoadFont(FN:string):boolean;
VAR f : file;
    r : word;
BEGIN
  {$I-}
  ASSIGN(f,FN);
  RESET(f,1);
  BLOCKREAD(f,FontBuffer,sizeof(fontbuffer),r);
  CLOSE(f);
  LoadFont := (IOResult = 0) and (r>0);
  {$I+}
END;

PROCEDURE InitGraphics;
VAR C : integer;
BEGIN
  Driver := detect;
  INITGRAPH(Driver, Mode, '');
{  SetGraphMode(1);}
  IF GraphResult <> 0 THEN HALT(1);
END;

PROCEDURE ClearScreen(c:integer);
BEGIN
  SETFILLSTYLE(SOLIDFILL,c);
  BAR(0,0,GETMAXX,GETMAXY);
END;

PROCEDURE CircleText( cx,cy,r,Align,GuideColor,dir:integer;
                          st:string;
                          StartA : real);
VAR
  tColor,c,circ,slen : integer;
 TotalR,NextRotation,
      cRotation,oldR : real;
                  AC : ArcCoordsType;
                   S : string;
          CClockwise : boolean;

BEGIN
  CClockwise := (dir < 0);
  slen := TF.TextWidth(St);
  circ := TRUNC(2*PI*r);
  TotalR := slen/circ*360;
  TColor := GetColor;

  SETTEXTJUSTIFY(LEFTTEXT,align);
  TF.SetTextOptions(0,TRUE);


  cRotation := StartA;

  FOR c := 1 to LENGTH(st) DO
  BEGIN

    S := st[c];

    oldR := cRotation;

    NextRotation := (TF.TextWidth(S)/slen*TotalR);

    IF CClockwise
    THEN BEGIN
           cRotation := cRotation + NextRotation;
           SETCOLOR(GuideColor);

           ARC(cx,cy,TRUNC(OldR),TRUNC(crotation),r);

           GETARCCOORDS(AC);

           SETCOLOR(tColor);

           WITH AC DO
           BEGIN

             TF.SetRotation(OldR + NextRotation/2 + 90);

             TF.StringOutxy(xStart,yStart,S);

           END;
         END
    ELSE BEGIN
           cRotation := cRotation - NextRotation;
           SETCOLOR(GuideColor);

           ARC(cx,cy,TRUNC(crotation),TRUNC(OldR),r);

           GETARCCOORDS(AC);

           SETCOLOR(tColor);

           WITH AC DO
           BEGIN

             TF.SetRotation(OldR - NextRotation/2 +270);

             TF.StringOutxy(xend,yend,S);

           END;
         END
  END;
END;

PROCEDURE ShadowDemo;
VAR atX,atY : integer;
BEGIN
  atX := GETMAXX div 2;
  atY := GETMAXY div 2;

  SETTEXTJUSTIFY(CENTERTEXT,CENTERTEXT);

  TF.SetTextStyle(@FontBuffer,-30,8);

  SETCOLOR(BLUE);
  TF.SetTextOptions(-30,TRUE);
  TF.StringOutXY(atX ,atY ,'''FreeFont'' 3-D Text');

  SETCOLOR(WHITE);
  TF.SetTextOptions(30,TRUE);
  TF.StringOutXY(atX ,atY ,'''FreeFont'' 3-D Text');

END;

PROCEDURE Mirrordemo;
BEGIN
  SETFILLSTYLE(SOLIDFILL,BLUE);
  BAR(0,0,GETMAXX,GETMAXY div 2);

  SETFILLSTYLE(SOLIDFILL,LIGHTBLUE);
  BAR(0,GETMAXY div 2,GETMAXX,GETMAXY);

  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  TF.SetTextStyle(@FontBuffer,0,7);

  TF.SetTextOptions(-15,TRUE);
  SETCOLOR(WHITE);
  TF.StringOutXY(GETMAXX div 2,(GETMAXY div 2) - 2,'''FreeFont'' Mirror');

  TF.SetTextOptions(195,TRUE);
  SETCOLOR(lightGray);
  TF.StringOutXY(GETMAXX div 2,(GETMAXY div 2)+2,'''FreeFont'' Mirror');

END;

PROCEDURE CircDemoII;
VAR
             Xasp,Yasp : word;
    atX,atY,rad,bColor : integer;

BEGIN
  bcolor := LIGHTBLUE;
  GETASPECTRATIO(Xasp,Yasp);
  atX := GETMAXX div 2;
  atY := GETMAXY div 2;
  rad := 140;

  SETCOLOR(bColor);

  SETFILLSTYLE(SOLIDFILL,BLUE);
  FILLELLIPSE(atX,atY,(rad-5),(rad-5) * longint(Xasp) div Yasp);

  TF.SetTextStyle(@FontBuffer,0,14);
  TF.SetTextOptions(0,TRUE);
  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  TF.StringOutXY(atX,atY,'II');
  TF.SetTextStyle(@FontBuffer,0,7);


  SETCOLOR(BLACK);
  CircleText(atX,atY,rad,TOPTEXT,bColor,-1,'''FreeFont'' Circular Text',180);
END;

PROCEDURE CircDemoI;
VAR
             Xasp,Yasp : word;
    atX,atY,rad,bColor : integer;
BEGIN
  bColor := LIGHTBLUE;
  GETASPECTRATIO(Xasp,Yasp);
  atX := GETMAXX div 2;
  atY := GETMAXY div 2;
  rad := 140;

  SETCOLOR(bColor);

  SETFILLSTYLE(SOLIDFILL,BLUE);
  FILLELLIPSE(atX,atY,rad-10,(rad-10) * longint(Xasp) div Yasp);

  TF.SetTextStyle(@FontBuffer,0,14);
  TF.SetTextOptions(0,TRUE);
  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  TF.StringOutXY(atX,atY,'I');

  TF.SetTextStyle(@FontBuffer,0,7);
  SETCOLOR(WHITE);
  CircleText(atX,atY,rad,BOTTOMTEXT,bcolor,1,'''FreeFont'' Circular Text',0);
END;

PROCEDURE RotateDemo;
BEGIN
  SETTEXTJUSTIFY(LEFTTEXT,BOTTOMTEXT);

  TF.SetTextStyle(@FontBuffer,90,8);
  TF.SetTextOptions(0,TRUE);

  SETCOLOR(BLACK);
  TF.StringOutXY(60,GETMAXY - 20,'Rotate Text');

  SETCOLOR(DarkGray);
  TF.SetRotation(60);
  TF.StringOutXY(60,GETMAXY - 20,'Rotate Text');

  SETCOLOR(LightGray);
  TF.SetRotation(30);
  TF.StringOutXY(60,GETMAXY - 20,'Rotate Text');

  SETCOLOR(WHITE);
  TF.SetRotation(0);
  TF.StringOutXY(60,GETMAXY - 20,'Rotate Text');

END;

PROCEDURE LastPage;
VAR atX,atY : integer;
BEGIN
  IF LoadFont('LITT.chr') THEN
  BEGIN


  TF.SetTextStyle(@FontBuffer,0,8);
  TF.SetTextOptions(0,FALSE);

  SETCOLOR(BLACK);
  SETTEXTJUSTIFY(LEFTTEXT,TOPTEXT);
  atX := 40;
  atY := 10;
  TF.StringOutXY(atX,atY,'''FreeFont'' is a Turbo Pascal Unit for v5.0 and v5.5');
  INC(atY,30);
  TF.StringOutXY(atX,atY,'of Borland''s Turbo Pascal Compiler.  Source code is');
  INC(atY,30);
  TF.StringOutXY(atX,atY,'available by sending $10.00 to :');
  INC(atY,45);
  TF.StringOutXY(atX,atY,'Michael E. Garey');
  INC(atY,30);
  TF.StringOutXY(atX,atY,'912 Blue Mountain Ln.');
  INC(atY,30);
  TF.StringOutXY(atX,atY,'Antioch, TN 37013');
  INC(atY,45);
  TF.StringOutXY(atX,atY,'Please specify a 3.5" or 5.25" diskette.');
  END;
END;

PROCEDURE FeatureDemo;
BEGIN
  SETTEXTJUSTIFY(LEFTTEXT,TOPTEXT);

  TF.SetTextStyle(@FontBuffer,0,6);
  SETCOLOR(BLACK);

  TF.SetTextOptions(0,FALSE);
  TF.StringOutXY(30,20,'''FreeFont'' text can be');

  TF.SetTextOptions(-15,FALSE);
  TF.StringOutXY(30,60,'Italics');

  TF.SetTextOptions(0,TRUE);
  TF.StringOutXY(30,100,'Bold');

  TF.SetTextOptions(-15,TRUE);
  TF.StringOutXY(30,140,'or BOTH');
END;

PROCEDURE welcome;
BEGIN
  TF.SetTextStyle(@FontBuffer,0,14);
  TF.SetTextOptions(0,TRUE);
  SETCOLOR(YELLOW);
  CircleText(GETMAXX div 2,GETMAXY + GETMAXY div 8,480,TOPTEXT,LIGHTBLUE,1,'Welcome',117);
  CircleText(GETMAXX div 2,GETMAXY div -8,480,BOTTOMTEXT,LIGHTBLUE,-1,'''FreeFont''',239);
  TF.SetTextStyle(@FontBuffer,0,7);
  TF.SetTextOptions(0,TRUE);
  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  TF.StringOutXY(GETMAXX div 2 ,GETMAXY div 2,'to');

END;

FUNCTION Finished:boolean;
VAR
      ch : Char;
       d : longint;
    done : boolean;
BEGIN
  d := 0;
  done := FALSE;
  SETCOLOR(WHITE);
  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  OUTTEXTXY(GETMAXX div 2,GETMAXY - 5,'Press any key to QUIT');
  REPEAT
    IF KEYPRESSED THEN
    BEGIN
      ch := readkey;
      IF ch = #0 THEN ch := readkey;
      done := TRUE;
    END ELSE INC(d);
  UNTIL done or (d=400000);
  Finished := done;
END;

PROCEDURE continue;
VAR
      ch : Char;
       d : longint;
    done : boolean;
BEGIN
  d := 0;
  done := FALSE;
  SETCOLOR(WHITE);
  SETTEXTJUSTIFY(CENTERTEXT,BOTTOMTEXT);
  OUTTEXTXY(GETMAXX div 2,GETMAXY - 5,'Press any key to continue');
  REPEAT
    IF KEYPRESSED THEN
    BEGIN
      ch := readkey;
      IF ch = #0 THEN ch := readkey;
      Done := TRUE;
    END ELSE INC(d);
  UNTIL done or (d=100000);
  ClearScreen(LIGHTBLUE);
END;

BEGIN
  InitGraphics;

  IF LoadFont('trip.chr') THEN
  BEGIN

    REPEAT

      ClearScreen(LIGHTBLUE);

      Welcome;
      continue;

      FeatureDemo;
      continue;

      RotateDemo;
      continue;

      CircDemoI;
      continue;

      CircDemoII;
      continue;

      MirrorDemo;
      continue;

      ShadowDemo;
      continue;

      LastPage;

    UNTIL finished;

    restorecrtmode;

  END
  ELSE BEGIN
         restorecrtmode;
         writeln('Error Loading the Font File.');
       END;
END.

