program FMU;

uses WObjects, WinTypes, WinProcs, Strings;

{$R FMU.RES}

(*::::::::::::::::::::::::::::Constants::::::::::::::::::::::::::::::::*)

const T = 1;
      F = 0;
      cb_Removed = 0;
      cb_Checked = 1;
      cb_Grayed  = 2;
      id_HeightScroll = 114;
      ph_HeightScroll = 155;
      id_WidthScroll  = 127;
      ph_WidthScroll  = 156;
      id_EscScroll    = 139;
      ph_EscScroll    = 157;
      id_OrientScroll = 130;
      ph_OrientScroll = 158;
      id_WeightScroll = 136;
      ph_WeightScroll = 159;
      id_Italicized   = 141;
      id_Underlined   = 142;
      id_StrikeOut    = 143;
      id_CharSet      = 146;
        csid_ANSI     = 101;
        csid_OEM      = 105;
        csid_Symbol   = 110;
        csid_OK       = 111;
        csid_Cancel   = 112;
      id_Output       = 147;
        opid_Char     = 101;
        opid_Default  = 102;
        opid_String   = 103;
        opid_Stroke   = 104;
        opid_OK       = 111;
        opid_Cancel   = 112;
      id_Quality      = 148;
        oqid_Default  = 101;
        oqid_Draft    = 102;
        oqid_Proof    = 103;
        oqid_OK       = 111;
        oqid_Cancel   = 112;
      id_Clipping     = 149;
        cpid_Char     = 101;
        cpid_Default  = 102;
        cpid_Stroke   = 103;
        cpid_OK       = 111;
        cpid_Cancel   = 112;
      id_Pitch        = 150;
        fpid_Default  = 101;
        fpid_Fixed    = 102;
        fpid_Variable = 103;
        fpid_OK       = 111;
        fpid_Cancel   = 112;
      id_Family       = 151;
        ffid_Decorate = 101;
        ffid_DontCare = 102;
        ffid_Modern   = 103;
        ffid_Roman    = 104;
        ffid_Script   = 105;
        ffid_Swiss    = 106;
        ffid_OK       = 111;
        ffid_Cancel   = 112;
      id_Weight       = 152;
        fwid_DontCare = 101;
        fwid_Thin     = 102;
        fwid_XtraLite = 103;
        fwid_Light    = 104;
        fwid_Normal   = 105;
        fwid_Medium   = 106;
        fwid_SemiBold = 107;
        fwid_Bold     = 108;
        fwid_XtraBold = 109;
        fwid_Heavy    = 110;
        fwid_OK       = 111;
        fwid_Cancel   = 112;
      id_EditBox      = 144;
      ph_EditBox      = 154;
      id_FaceName     = 153;
      id_AboutFMU     = 175;
        aid_ReturnFMU = 112;


(*:::::::::::::::::::::::::::::::Objects:::::::::::::::::::::::::::::::*)

type
  PMyDlg = ^TMyDlg;
  TMyDlg = object(TDlgWindow)
    x, y: Integer;  { BaseFontDimensions }
    TextFace: Array[0..20] of char;
    EditBox: TEdit;
    TheFont: HFont;
    HeightScroll: TScrollBar;
    WidthScroll: TScrollBar;
    EscScroll: TScrollBar;
    OrientScroll: TScrollBar;
    WeightScroll: TScrollBar;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure BaseFontDimensions;
    function GetClassName: Pchar; virtual;
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    procedure SetupWindow; virtual;
    procedure DefWndProc(var Msg: TMessage); virtual;
    procedure HeightScroller(var Msg: Tmessage); virtual id_First + id_HeightScroll;
    procedure WidthScroller(var Msg: Tmessage); virtual id_First + id_WidthScroll;
    procedure EscScroller(var Msg: Tmessage); virtual id_First + id_EscScroll;
    procedure OrientScroller(var Msg: Tmessage); virtual id_First + id_OrientScroll;
    procedure WeightScroller(var Msg: Tmessage); virtual id_First + id_WeightScroll;
    procedure Italicized(var Msg: TMessage); virtual id_First + id_Italicized;
    procedure Underlined(var Msg: TMessage); virtual id_First + id_Underlined;
    procedure StrikeOut(var Msg: TMessage); virtual id_First + id_StrikeOut;
    procedure CharSet(var Msg: TMessage); virtual id_First + id_CharSet;
    procedure Output(var Msg: TMessage); virtual id_First + id_Output;
    procedure Quality(var Msg: TMessage); virtual id_First + id_Quality;
    procedure Clipping(var Msg: TMessage); virtual id_First + id_Clipping;
    procedure Pitch(var Msg: TMessage); virtual id_First + id_Pitch;
    procedure Family(var Msg: TMessage); virtual id_First + id_Family;
    procedure Weight(var Msg: TMessage); virtual id_First + id_Weight;
    procedure DoStuff;
    procedure CleanUp;
    destructor Done; virtual;
  end;

  TAbout = object(TDialog)
    procedure SetupWindow; virtual;
    procedure OKEnd(var Msg: TMessage); virtual id_First + aid_ReturnFMU;
  end;

  TCharSet = object(TDialog)
    OldCharSet: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetANSI(var Msg: TMessage); virtual id_First + csid_ANSI;
    procedure SetOEM(var Msg: TMessage); virtual id_First + csid_OEM;
    procedure SetSymbol(var Msg: TMessage); virtual id_First + csid_Symbol;
    procedure OKEnd(var Msg: TMessage); virtual id_First + csid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + csid_Cancel;
  end;

  TOutput = object(TDialog)
    OldOutput: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetChar(var Msg: TMessage); virtual id_first + opid_Char;
    procedure SetDefault(var Msg: TMessage); virtual id_first + opid_Default;
    procedure SetString(var Msg: TMessage); virtual id_first + opid_String;
    procedure SetStroke(var Msg: TMessage); virtual id_first + opid_Stroke;
    procedure OKEnd(var Msg: TMessage); virtual id_First + opid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + opid_Cancel;
  end;

  TQuality = object(TDialog)
    OldQuality: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetDefault(var Msg: TMessage); virtual id_First + oqid_Default;
    procedure SetDraft(var Msg: TMessage); virtual id_First + oqid_Draft;
    procedure SetProof(var Msg: TMessage); virtual id_First + oqid_Proof;
    procedure OKEnd(var Msg: TMessage); virtual id_First + oqid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + oqid_Cancel;
  end;

  TClipping = object(TDialog)
    OldClipping: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetChar(var Msg: TMessage); virtual id_First + cpid_Char;
    procedure SetDefault(var Msg: TMessage); virtual id_First + cpid_Default;
    procedure SetStroke(var Msg: TMessage); virtual id_First + cpid_Stroke;
    procedure OKEnd(var Msg: TMessage); virtual id_First + cpid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + cpid_Cancel;
  end;

  TPitch = object(TDialog)
    OldPitch: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetDefault(var Msg: TMessage); virtual id_First + fpid_Default;
    procedure SetFixed(var Msg: TMessage); virtual id_First + fpid_Fixed;
    procedure SetVariable(var Msg: TMessage); virtual id_First + fpid_Variable;
    procedure OKEnd(var Msg: TMessage); virtual id_First + fpid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + fpid_Cancel;
  end;

  TFamily = object(TDialog)
    OldFamily: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetDecorate(var Msg: TMessage); virtual id_First + ffid_Decorate;
    procedure SetDontCare(var Msg: TMessage); virtual id_First + ffid_DontCare;
    procedure SetModern(var Msg: TMessage); virtual id_First + ffid_Modern;
    procedure SetRoman(var Msg: TMessage); virtual id_First + ffid_Roman;
    procedure SetScript(var Msg: TMessage); virtual id_First + ffid_Script;
    procedure SetSwiss(var Msg: TMessage); virtual id_First + ffid_Swiss;
    procedure OKEnd(var Msg: TMessage); virtual id_First + ffid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + ffid_Cancel;
  end;

  TWeight = object(TDialog)
    OldWeight: integer;
    procedure SetupWindow; virtual;
    procedure RadioSet(MessageID: integer);
    procedure SetDontCare(var Msg: TMessage); virtual id_First + fwid_DontCare;
    procedure SetThin(var Msg: TMessage); virtual id_First + fwid_Thin;
    procedure SetXtraLite(var Msg: TMessage); virtual id_First + fwid_XtraLite;
    procedure SetLight(var Msg: TMessage); virtual id_First + fwid_Light;
    procedure SetNormal(var Msg: TMessage); virtual id_First + fwid_Normal;
    procedure SetMedium(var Msg: TMessage); virtual id_First + fwid_Medium;
    procedure SetSemiBold(var Msg: TMessage); virtual id_First + fwid_SemiBold;
    procedure SetBold(var Msg: TMessage); virtual id_First + fwid_Bold;
    procedure SetXtraBold(var Msg: TMessage); virtual id_First + fwid_XtraBold;
    procedure SetHeavy(var Msg: TMessage); virtual id_First + fwid_Heavy;
    procedure OKEnd(var Msg: TMessage); virtual id_First + fwid_OK;
    procedure CancelEnd(var Msg: TMessage); virtual id_First + fwid_Cancel;
  end;

  MyApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

(*:::::::::::::::::::::::::Global Variables::::::::::::::::::::::::::::*)

var LogFont : TLogFont;
    VPitch: Integer;
    VFamily: Integer;

(*::::::::::::::::::::::::: TAbout Procedures::::::::::::::::::::::::::*)

procedure TAbout.SetupWindow;
var TheDC: HDC;
    TheIcon: HIcon;
    Test: Boolean;
begin
  TDialog.SetupWindow;
  TheIcon := LoadIcon(HInstance, 'FMU_ICON' );
  TheDC := GetDC( HWindow );
  test := DrawIcon(TheDC, 30, 30, TheIcon);
  ReleaseDC( HWindow, TheDC );
end;

procedure TAbout.OKEnd(var Msg: TMessage);
begin
  OK(Msg);
end;

(*::::::::::::::::::::::::TCharSet Procedures::::::::::::::::::::::::::*)

procedure TCharSet.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldCharSet := LogFont.lfCharSet;
  case OldCharSet of
    ANSI_CharSet:   CheckRadioButton(HWindow, csid_ANSI, csid_Symbol, csid_ANSI);
    OEM_CharSet:    CheckRadioButton(HWindow, csid_ANSI, csid_Symbol, csid_OEM);
    Symbol_CharSet: CheckRadioButton(HWindow, csid_ANSI, csid_Symbol, csid_Symbol);
  end;
End;

procedure TCharSet.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, csid_ANSI, csid_Symbol, MessageID);
  case MessageID of
    csid_ANSI     : LogFont.lfCharSet := ANSI_CharSet;
    csid_OEM      : LogFont.lfCharSet := OEM_CharSet;
    csid_Symbol   : LogFont.lfCharSet := Symbol_CharSet;
  end;
End;

procedure TCharSet.SetANSI(var Msg: TMessage);   Begin  RadioSet(csid_ANSI); End;
procedure TCharSet.SetOEM(var Msg: TMessage);    Begin  RadioSet(csid_OEM); End;
procedure TCharSet.SetSymbol(var Msg: TMessage); Begin  RadioSet(csid_Symbol); End;
procedure TCharSet.OKEnd(var Msg: TMessage);     Begin  OK(Msg); End;

procedure TCharSet.CancelEnd(var Msg: TMessage);
Begin
  LogFont.lfCharSet := OldCharSet;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TOutput Procedures::::::::::::::::::::::::::*)

procedure TOutput.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldOutput := LogFont.lfOutPrecision;
  case OldOutput of
    Out_Character_Precis: CheckRadioButton(HWindow, opid_Char, opid_Stroke, opid_Char);
    Out_Default_Precis:   CheckRadioButton(HWindow, opid_Char, opid_Stroke, opid_Default);
    Out_String_Precis:    CheckRadioButton(HWindow, opid_Char, opid_Stroke, opid_String);
    Out_Stroke_Precis:    CheckRadioButton(HWindow, opid_Char, opid_Stroke, opid_Stroke);
  end;
End;

procedure TOutput.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, opid_Char, opid_Stroke, MessageID);
  case MessageID of
    opid_Char     : LogFont.lfOutPrecision := Out_Character_Precis;
    opid_Default  : LogFont.lfOutPrecision := Out_Default_Precis;
    opid_String   : LogFont.lfOutPrecision := Out_String_Precis;
    opid_Stroke   : LogFont.lfOutPrecision := Out_Stroke_Precis;
  end;
End;

procedure TOutput.SetChar(var Msg: TMessage);    Begin  RadioSet(opid_Char);    End;
procedure TOutput.SetDefault(var Msg: TMessage); Begin  RadioSet(opid_Default); End;
procedure TOutput.SetString(var Msg: TMessage);  Begin  RadioSet(opid_String);  End;
procedure TOutput.SetStroke(var Msg: TMessage);  Begin  RadioSet(opid_Stroke);  End;
procedure TOutput.OKEnd(var Msg: TMessage);      Begin  OK(Msg);                End;

procedure TOutput.CancelEnd(var Msg: TMessage);
Begin
  LogFont.lfOutPrecision := OldOutput;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TQuality Procedures::::::::::::::::::::::::::*)

procedure TQuality.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldQuality := LogFont.lfQuality;
  case OldQuality of
    Default_Quality: CheckRadioButton(HWindow, oqid_Default, oqid_Proof, oqid_Default);
    Draft_Quality:   CheckRadioButton(HWindow, oqid_Default, oqid_Proof, oqid_Draft);
    Proof_Quality:   CheckRadioButton(HWindow, oqid_Default, oqid_Proof, oqid_Proof);
  end;
End;

procedure TQuality.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, oqid_Default, oqid_Proof, MessageID);
  case MessageID of
    oqid_Default  : LogFont.lfQuality := Default_Quality;
    oqid_Draft    : LogFont.lfQuality := Draft_Quality;
    oqid_Proof    : LogFont.lfQuality := Proof_Quality;
  end;
End;

procedure TQuality.SetDefault(var Msg: TMessage); Begin  RadioSet(oqid_Default); End;
procedure TQuality.SetDraft(var Msg: TMessage);   Begin  RadioSet(oqid_Draft);   End;
procedure TQuality.SetProof(var Msg: TMessage);   Begin  RadioSet(oqid_Proof);   End;
procedure TQuality.OKEnd(var Msg: TMessage);      Begin  OK(Msg);                End;

procedure TQuality.CancelEnd(var Msg: TMessage);
Begin
  LogFont.lfQuality := OldQuality;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TClipping Procedures::::::::::::::::::::::::::*)

procedure TClipping.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldClipping := LogFont.lfClipPrecision;
  case OldClipping of
    Clip_Character_Precis: CheckRadioButton(HWindow, cpid_Char, cpid_Stroke, cpid_Char);
    Clip_Default_Precis:   CheckRadioButton(HWindow, cpid_Char, cpid_Stroke, cpid_Default);
    Clip_Stroke_Precis:    CheckRadioButton(HWindow, cpid_Char, cpid_Stroke, cpid_Stroke);
  end;
End;

procedure TClipping.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, cpid_Char, cpid_Stroke, MessageID);
  case MessageID of
    cpid_Char     : LogFont.lfClipPrecision := Clip_Character_Precis;
    cpid_Default  : LogFont.lfClipPrecision := Clip_Default_Precis;
    cpid_Stroke   : LogFont.lfClipPrecision := Clip_Stroke_Precis;
  end;
End;

procedure TClipping.SetChar(var Msg: TMessage);    Begin  RadioSet(cpid_Char);    End;
procedure TClipping.SetDefault(var Msg: TMessage); Begin  RadioSet(cpid_Default); End;
procedure TClipping.SetStroke(var Msg: TMessage);  Begin  RadioSet(cpid_Stroke);  End;
procedure TClipping.OKEnd(var Msg: TMessage);      Begin  OK(Msg);                End;

procedure TClipping.CancelEnd(var Msg: TMessage);
Begin
  LogFont.lfClipPrecision := OldClipping;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TPitch Procedures::::::::::::::::::::::::::*)

procedure TPitch.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldPitch := VPitch;
  case OldPitch of
    Default_Pitch:  CheckRadioButton(HWindow, fpid_Default, fpid_Variable, fpid_Default);
    Fixed_Pitch:    CheckRadioButton(HWindow, fpid_Default, fpid_Variable, fpid_Fixed);
    Variable_Pitch: CheckRadioButton(HWindow, fpid_Default, fpid_Variable, fpid_Variable);
  end;
End;

procedure TPitch.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, fpid_Default, fpid_Variable, MessageID);
  case MessageID of
    fpid_Default  : VPitch := Default_Pitch;
    fpid_Fixed    : VPitch := Fixed_Pitch;
    fpid_Variable : VPitch := Variable_Pitch;
  end;
End;

procedure TPitch.SetDefault(var Msg: TMessage);  Begin  RadioSet(fpid_Default);  End;
procedure TPitch.SetFixed(var Msg: TMessage);    Begin  RadioSet(fpid_Fixed);    End;
procedure TPitch.SetVariable(var Msg: TMessage); Begin  RadioSet(fpid_Variable); End;

procedure TPitch.OKEnd(var Msg: TMessage);
Begin
  LogFont.lfPitchAndFamily := VFamily or VPitch;
  OK(Msg);
End;

procedure TPitch.CancelEnd(var Msg: TMessage);
Begin
  VPitch := OldPitch;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TFamily Procedures::::::::::::::::::::::::::*)

procedure TFamily.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldFamily := VFamily;
  case OldFamily of
    ff_Decorative: CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_Decorate);
    ff_DontCare:   CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_DontCare);
    ff_Modern:     CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_Modern);
    ff_Roman:      CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_Roman);
    ff_Script:     CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_Script);
    ff_Swiss:      CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, ffid_Swiss);
  end;
End;

procedure TFamily.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, ffid_Decorate, ffid_Swiss, MessageID);
  case MessageID of
    ffid_Decorate : VFamily := ff_Decorative;
    ffid_DontCare : VFamily := ff_DontCare;
    ffid_Modern   : VFamily := ff_Modern;
    ffid_Roman    : VFamily := ff_Roman;
    ffid_Script   : VFamily := ff_Script;
    ffid_Swiss    : VFamily := ff_Swiss;
  end;
End;

procedure TFamily.SetDecorate(var Msg: TMessage); Begin RadioSet(ffid_Decorate); End;
procedure TFamily.SetDontCare(var Msg: TMessage); Begin RadioSet(ffid_DontCare); End;
procedure TFamily.SetModern(var Msg: TMessage);   Begin RadioSet(ffid_Modern);   End;
procedure TFamily.SetRoman(var Msg: TMessage);    Begin RadioSet(ffid_Roman);    End;
procedure TFamily.SetScript(var Msg: TMessage);   Begin RadioSet(ffid_Script);   End;
procedure TFamily.SetSwiss(var Msg: TMessage);    Begin RadioSet(ffid_Swiss);    End;

procedure TFamily.OKEnd(var Msg: TMessage);
Begin
  LogFont.lfPitchAndFamily := VFamily or VPitch;
  OK(Msg);
End;

procedure TFamily.CancelEnd(var Msg: TMessage);
Begin
  VFamily := OldFamily;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::TWeight Procedures::::::::::::::::::::::::::*)

procedure TWeight.SetupWindow;
Begin
  TDialog.SetupWindow;
  OldWeight := LogFont.lfWeight;
  case OldWeight of
    fw_DontCare : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_DontCare);
    fw_Thin     : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Thin);
    fw_ExtraLight : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_XtraLite);
    fw_Light    : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Light);
    fw_Normal   : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Normal);
    fw_Medium   : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Medium);
    fw_SemiBold : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_SemiBold);
    fw_Bold     : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Bold);
    fw_ExtraBold : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_XtraBold);
    fw_Heavy    : CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, fwid_Heavy);
  end;
End;

procedure TWeight.RadioSet(MessageID: integer);
Begin
  CheckRadioButton(HWindow, fwid_DontCare, fwid_Heavy, MessageID);
  case MessageID of
    fwid_DontCare : LogFont.lfWeight := fw_DontCare;
    fwid_Thin     : LogFont.lfWeight := fw_Thin;
    fwid_XtraLite : LogFont.lfWeight := fw_ExtraLight;
    fwid_Light    : LogFont.lfWeight := fw_Light;
    fwid_Normal   : LogFont.lfWeight := fw_Normal;
    fwid_Medium   : LogFont.lfWeight := fw_Medium;
    fwid_SemiBold : LogFont.lfWeight := fw_SemiBold;
    fwid_Bold     : LogFont.lfWeight := fw_Bold;
    fwid_XtraBold : LogFont.lfWeight := fw_ExtraBold;
    fwid_Heavy    : LogFont.lfWeight := fw_Heavy;
  end;
End;

procedure TWeight.SetDontCare(var Msg: TMessage); Begin RadioSet(fwid_DontCare); End;
procedure TWeight.SetThin(var Msg: TMessage);     Begin RadioSet(fwid_Thin); End;
procedure TWeight.SetXtraLite(var Msg: TMessage); Begin RadioSet(fwid_XtraLite); End;
procedure TWeight.SetLight(var Msg: TMessage);    Begin RadioSet(fwid_Light); End;
procedure TWeight.SetNormal(var Msg: TMessage);   Begin RadioSet(fwid_Normal); End;
procedure TWeight.SetMedium(var Msg: TMessage);   Begin RadioSet(fwid_Medium); End;
procedure TWeight.SetSemiBold(var Msg: TMessage); Begin RadioSet(fwid_SemiBold); End;
procedure TWeight.SetBold(var Msg: TMessage);     Begin RadioSet(fwid_Bold); End;
procedure TWeight.SetXtraBold(var Msg: TMessage); Begin RadioSet(fwid_XtraBold); End;
procedure TWeight.SetHeavy(var Msg: TMessage);    Begin RadioSet(fwid_Heavy); End;
procedure TWeight.OKEnd(var Msg: TMessage);       Begin OK(Msg); End;

procedure TWeight.CancelEnd(var Msg: TMessage);
Begin
  LogFont.lfWeight := OldWeight;
  Cancel(Msg);
End;

(*::::::::::::::::::::::::::TMyDlg Procedures::::::::::::::::::::::::::*)

constructor TMyDlg.Init(AParent: PWindowsObject; AName: PChar);
var AsciStr: PChar;
    AString: Array[0..52] of char;
begin
  BaseFontDimensions;
  strcopy( AString, 'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz');
  AsciStr := @AString[0];
  TDlgWindow.Init(AParent, AName);
  EditBox.Init(@Self, id_EditBox, AsciStr, x+2, y*12-2, x*62-1, y*8+2, 0, True);
  TheFont := 0;
  with LogFont do begin
    lfHeight := 12;
    lfWidth := 12;
    lfEscapement := 0;
    lfOrientation := 0;
    lfWeight := fw_Normal;
    lfItalic := F;
    lfUnderline := F;
    lfStrikeOut := F;
    lfCharSet := ANSI_CharSet;
    lfOutPrecision := Out_Default_Precis;
    lfClipPrecision := Clip_Default_Precis;
    lfQuality := Default_Quality;
    lfPitchAndFamily := Variable_Pitch or ff_Script;
    StrPCopy(lfFaceName, 'Roman');
  end;
  HeightScroll.Init(@Self, id_HeightScroll, x*14, y+1,   x*20-2, y+1, True);
  WidthScroll.Init(@Self, id_WidthScroll,   x*14, y*3-4, x*20-2, y+1, True);
  EscScroll.Init(@Self, id_EscScroll,       x*14, y*5-6, x*20-2, y+1, True);
  OrientScroll.Init(@Self, id_OrientScroll, x*14, y*6+8, x*20-2, y+1, True);
  WeightScroll.Init(@Self, id_WeightScroll, x*14, y*8+6, x*20-2, y+1, True);
  HeightScroll.SetPosition(LogFont.lfHeight);
  WidthScroll.SetPosition(LogFont.lfWidth);
  EscScroll.SetPosition(LogFont.lfEscapement);
  OrientScroll.SetPosition(LogFont.lfOrientation);
  WeightScroll.SetPosition(LogFont.lfWeight);
end;

procedure TMyDlg.BaseFontDimensions;
var Convert: LongInt;
begin
  Convert := GetDialogBaseUnits;
  x := Convert;
  y := Convert shr 16;
end;

function TMyDlg.GetClassName: PChar;
begin
  GetClassName := 'FMU';
end;

procedure TMyDlg.GetWindowClass(var WndClass: TWndClass);
begin
  TDlgWindow.GetWindowClass(WndClass);
  WndClass.hIcon := LoadIcon(HInstance, 'FMU_ICON');
end;

procedure TMyDlg.SetupWindow;
var SysMenu: HMenu;
    Msg: TMessage;
Begin
  TDlgWindow.SetupWindow;
  SysMenu := GetSystemMenu(HWindow, False);
  AppendMenu(SysMenu, mf_Enabled, id_AboutFMU, 'About FMU' );
  DoStuff;
End;

procedure TMyDlg.DefWndProc(var Msg: TMessage);
var AboutDlg: TAbout;
begin
  if (Msg.Message = WM_SysCommand) and (Msg.WParam = id_AboutFMU) then begin
    AboutDlg.Init( @self.HWindow, 'ABOUT FMU' );
    AboutDlg.Execute;
    AboutDlg.Done;
  end;
  TDlgWindow.DefWndProc(Msg);
end;

procedure TMyDlg.HeightScroller(var Msg: Tmessage);
Begin
  LogFont.lfHeight := HeightScroll.GetPosition;
  DoStuff;
End;

procedure TMyDlg.WidthScroller(var Msg: Tmessage);
Begin
  LogFont.lfWidth := WidthScroll.GetPosition;
  DoStuff;
End;

procedure TMyDlg.EscScroller(var Msg: Tmessage);
Begin
  LogFont.lfEscapement := EscScroll.GetPosition * 36;
  DoStuff;
End;

procedure TMyDlg.OrientScroller(var Msg: Tmessage);
Begin
  LogFont.lfOrientation := OrientScroll.GetPosition * 36;
  DoStuff;
End;

procedure TMyDlg.WeightScroller(var Msg: Tmessage);
Begin
  LogFont.lfWeight := WeightScroll.GetPosition * 10;
  DoStuff;
End;

procedure TMyDlg.Italicized(var Msg: TMessage);
Begin
  if( LogFont.lfItalic = F ) then begin
    LogFont.lfItalic := T;
    CheckDlgButton(HWindow, id_Italicized, cb_Checked);
    end
  else begin
    LogFont.lfItalic := F;
    CheckDlgButton(HWindow, id_Italicized, cb_Removed);
  end;
  DoStuff;
End;

procedure TMyDlg.Underlined(var Msg: TMessage);
Begin
  if( LogFont.lfUnderline = F ) then begin
    LogFont.lfUnderline := T;
    CheckDlgButton(HWindow, id_Underlined, cb_Checked);
    end
  else begin
    LogFont.lfUnderline := F;
    CheckDlgButton(HWindow, id_Underlined, cb_Removed);
  end;
  DoStuff;
End;

procedure TMyDlg.StrikeOut(var Msg: TMessage);
Begin
  if( LogFont.lfStrikeOut = F ) then begin
    LogFont.lfStrikeOut := T;
    CheckDlgButton(HWindow, id_StrikeOut, cb_Checked);
    end
  else begin
    LogFont.lfStrikeOut := F;
    CheckDlgButton(HWindow, id_StrikeOut, cb_Removed);
  end;
  DoStuff;
End;

procedure TMyDlg.CharSet(var Msg: TMessage);
var CharSetDlg: TCharSet;
Begin
  CharSetDlg.Init( @self.HWindow, 'CHARACTER SET');
  CharSetDlg.Execute;
  CharSetDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Output(var Msg: TMessage);
var OutputDlg: TOutput;
Begin
  OutputDlg.Init( @self.HWindow, 'OUTPUT');
  OutputDlg.Execute;
  OutputDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Quality(var Msg: TMessage);
var QualityDlg: TQuality;
Begin
  QualityDlg.Init( @self.HWindow, 'OUTPUT QUALITY');
  QualityDlg.Execute;
  QualityDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Clipping(var Msg: TMessage);
var ClippingDlg: TClipping;
Begin
  ClippingDlg.Init( @self.HWindow, 'CLIPPING');
  ClippingDlg.Execute;
  ClippingDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Pitch(var Msg: TMessage);
var PitchDlg: TPitch;
Begin
  PitchDlg.Init( @self.HWindow, 'FONT PITCH');
  PitchDlg.Execute;
  PitchDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Family(var Msg: TMessage);
var FamilyDlg: TFamily;
Begin
  FamilyDlg.Init( @self.HWindow, 'FAMILIES');
  FamilyDlg.Execute;
  FamilyDlg.Done;
  DoStuff;
End;

procedure TMyDlg.Weight(var Msg: TMessage);
var WeightDlg: TWeight;
Begin
  WeightDlg.Init( @self.HWindow, 'WEIGHTS');
  WeightDlg.Execute;
  WeightDlg.Done;
  WeightScroll.SetPosition(LogFont.lfWeight div 10);
  DoStuff;
End;

procedure TMyDlg.DoStuff;
var TheDC: HDC;
    TheIcon: hIcon;
begin
  if TheFont > 0 then DeleteObject(TheFont);
  TheFont := CreateFontIndirect(LogFont);
  TheDC := GetDC( EditBox.HWindow );
  SelectObject(TheDC, TheFont );
  SendMessage( EditBox.HWindow, wm_SetFont, TheFont, 0);
  GetTextFace(TheDC, 20, @TextFace[0]);
  StrLCat( TextFace, '                    ', 20 );
  ReleaseDC( EditBox.HWindow, TheDC );
  TheDC := GetDC( HWindow );
  TextOut(TheDC, x*42-1, y*2+8, @TextFace[0], 20);
  ReleaseDC( HWindow, TheDC );
end;

procedure TMyDlg.CleanUp;
begin
  HeightScroll.Done;
  WidthScroll.Done;
  EscScroll.Done;
  OrientScroll.Done;
  WeightScroll.Done;
  EditBox.Done;
end;

destructor TMyDlg.Done;
begin
  CleanUp;
  TDlgWindow.Done;
end;

(*:::::::::::::::::::::::::::MyApp Procedures::::::::::::::::::::::::::*)

procedure MyApp.InitMainWindow;
begin
  MainWindow := New(PMyDlg, Init(nil, 'FONT WORK'));
end;

(*:::::::::::::::::::::::::::Main Program Body:::::::::::::::::::::::::*)

var
  MainProc: MyApp;

begin
  MainProc.Init('FONT WORK');
  MainProc.Run;
  MainProc.Done;
end.