
(**********************************************************************)
(* Simple program to demonstrate how to use the FlxKey unit to obtain *)
(* user-data from encrypted registration-key file, using "embedded"   *)
(* encryption-code strings.                                           *)
(*                                                                    *)
(* NOTE: Before you can compile this program, you must first          *)
(*       compile and run the "RANDCODE.PAS" program to generate       *)
(*       the two "random" encryption-code binary data files. Then     *)
(*       run the "batch" file called "DAT2OBJ.BAT" to convert         *)
(*       these two binary data files to "object" format files.        *)
(**********************************************************************)

program Read_FlxKey_Demo2;
uses
  Crt,
  FlxKey;

type
              (* 20 character string-pointer definition.              *)
  post_20 = ^st_20;

var           (* Variable set by ReadFlxKey routine, that indicates   *)
              (* the difference in days between the current date and  *)
              (* the date encrypted into the registration-key file.   *)
  DaysOld,

              (* This variable is used to check for errors returned   *)
              (* by ReadFlxKey routine.                               *)
  ErrorCode  : word;

              (* Encryption-code string-pointers, used to decrypt the *)
              (* data in the encrypted registration-key file.         *)
  Ecode1Ptr,
  Ecode2Ptr  : post_20;

              (* This is the full path/filename of the encrypted      *)
              (* registration-key file to be decrypted.               *)
  RegKeyName : st_79;

              (* Record variable to hold the data decrypted from the  *)
              (* encrypted registration-key file.                     *)
  TempKeyRec : rc_Flx;

  {$F+}       (* Declare the following two procedures as "FAR".       *)

              (* "Fake" procedure that contains first encryption-code *)
              (* string.                                              *)
  procedure Ecode1Data; external;
  {$L ECODE1.OBJ}

              (* "Fake" procedure that contains second encryption-    *)
              (* code string.                                         *)
  procedure Ecode2Data; external;
  {$L ECODE2.OBJ}

  {$F-}       (* Turn off "FAR" declaration.                          *)

              (* Main program execution block.                        *)
BEGIN
              (* Initialize the encryption-code string pointers to    *)
              (* their data.                                          *)
  Ecode1ptr := addr(Ecode1Data);
  Ecode2ptr := addr(Ecode2Data);

              (* Clear the temporary key-record variable.             *)
  fillchar(TempKeyRec, sizeof(TempKeyRec), 0);

              (* Full path/filename for the encrypted registration-   *)
              (* key file to be decrypted.                            *)
  RegKeyName := 'DEMO2.KEY';

              (* Decrypt the registration-key file, and retreive it's *)
              (* data.                                                *)
              (* NOTE: A 10 second delay and message are present in   *)
              (*       the un-registered copy of the FlxKey unit.     *)
  ReadFlxKey(Ecode1Ptr^, Ecode2Ptr^, RegKeyName, TempKeyRec, DaysOld,
             ErrorCode);

              (* Clear the screen.                                    *)
  clrscr;
  writeln;

              (* Check for errors.                                    *)
  if (ErrorCode <> 0) then
    case (ErrorCode AND $FF) of
       1 : writeln(' Error! One or more encryption-codes is blank.');
       2 : writeln(' Error! Filename for registration-key file is blank.');
       3 : writeln(' HEAP allocation error. Unable to allocate 1024 ' +
                   'buffer.');
       4 : writeln(' BlocWrite error.');
       5 : writeln(' BlockRead error.');
       6 : writeln(' Date error. PC''s system date pre-dates ' +
                   'registration-key date.');
       7 : writeln(' Registration-key is corrupt.');

              (* I/O error!                                           *)
      16 : begin
             writeln(' I/O error = ', (ErrorCode shr 8));

              (* Standard Turbo Pascal error-codes. See TP manuals,   *)
              (* as there are many types of errors to check for.      *)
             case (ErrorCode shr 8) of
                 2 : writeln(' File not found.');
                 3 : writeln(' Path not found.');
                 4 : writeln(' Too many files open.');
                 5 : writeln(' File access denied.');
               100 : writeln(' Disk read error.');
               103 : writeln(' File not open')
             end  (* case (ErrorCode shr 8) of                        *)
           end
    end       (* case (ErrorCode AND $FF) of                          *)
  else
              (* Else NO errors occurred.                             *)
    begin
              (* Display the decrypted registration-key data.         *)
      writeln('Key is ', DaysOld, ' days old');
      writeln;
      with TempKeyRec do
        begin
          writeln(' FirstName    = ', FirstName);
          writeln(' LastName     = ', LastName);
          writeln(' Address1     = ', Address1);
          writeln(' Address2     = ', Address2);
          writeln(' Address3     = ', Address3);
          writeln(' AppName      = ', AppName);
          writeln(' Version      = ', Version);
          writeln(' Serial Num   = ', Serial);

              (* Standard TP "UnPackTime" and "PackTime" routines     *)
              (* can be used to manipulate "packed date" data.        *)
          writeln(' Packed Date  = ', Date);

          writeln(' Access Level = ', Access);

          writeln(' MiscData     = ', MiscData)

        end
    end
END.


