program Term;

{
	term.pas

	A very simple terminal driver implimented using FOSSIL
	communications functions

	Written by David Nugent, Unique Computing Pty Ltd
	as an example of how to interface to FOSSIL

	This program was compiled using Turbo Pascal 5.0/5.5
}


uses
  FLIB, Crt, Dos;

type
  UArr6 = array[0..6] of word;
  UArr8 = array[0..7] of word;
  CString = array[0..255] of byte;
  CStringPtr = ^CString;

const
  port : integer = 0;             { Default port; 0 = COM1 }
  Baud : word = 2400;             { Default baud; 2400 }
  Mask : word = (CP_PARNONE or CP_STOP1 or CP_CHLEN8); { Default comm params }
  Speeds : UArr6 = (
    300, 1200, 2400, 4800, 9600, 19200, 38400);
  Codes : UArr6 = (
    CP_B300, CP_B1200, CP_B2400, CP_B4800,
    CP_B9600, CP_B19200, CP_B38400);
  col_fg : UArr8 = (30, 34, 32, 36, 31, 35, 33, 37);
  col_bg : UArr8 = (40, 44, 42, 46, 41, 45, 43, 47);
  ALTP = $1900;
  ALTB = $3000;
  ALTF = $2100;
  ALTH = $2300;
  ALTX = $2d00;

var
  FI : FinfoType;
  TI : FTimInfo;
  FD : FDataType;
  done : boolean;
  ps : word;
  K, E : integer;
  CBrk : byte;
  ID : string[80];
  Cid : CString;

  function TimerSet(HInc : word) : longint;
  var
    Hour, Min, Sec, HSec : word;
    Year, Mon, Day, DoW : word;
  begin
    GetDate(Year, Mon, Day, DoW);
    GetTime(Hour, Min, Sec, HSec);
    TimerSet := HInc+HSec+100*(Sec+60*(Min+60*(Hour+24*DoW)));
  end;                            { TimerSet }


  function TimeUp(Marker : longint) : boolean;
  var
    Marker2 : longint;
  begin
    Marker2 := TimerSet(0);
    if (Marker-Marker2) > (24*60*60*100) then Marker2 := Marker2+(7*24*60*60*100);
    TimeUp := Marker2 >= Marker;
  end;                            { TimeUp }

  procedure Timer(HInc : word);
  var
    T : longint;
  begin
  end;                            { Timer }

  function LookUp(var A : UArr6; f : word; no : integer) : integer;
  var
    I, R : integer;
  begin
    R := -1;
    for I := 0 to no do if f = A[I] then R := I;
    LookUp := R;
  end;                            { LookUp }



  function GetLine(var Hold : string; Max : integer) : integer;
  var
    I : integer;
    K : word;
		D : string[10];
  label
    Quit;
  begin
    I := 0;                       { Init chr pointer }
    while (I < Max) and (I <> -1) do
      begin
        K := ComKbChar and 255;
        case K of
          0 : goto Quit;
          13 : goto Quit;
          10 : goto Quit;
          27 : begin
                 I := -1;
                 goto Quit;
               end;
          8 : begin
                if (I > 0) then I := I-1;
                write(chr(8), ' ', chr(8));
              end;
          else
            begin
              I := I+1;
              Hold[I] := chr(K);
							write (chr(K));
            end;
        end;
      end;
Quit:
    write(chr(13), chr(10));
    if I <> -1 then Hold[0] := chr(I)
    else Hold[0] := chr(0);
    GetLine := I;
  end;                            { GetLine }



  procedure ChgPort;
  var
    L : integer;
    Dummy, Error : word;
    newport : string[20];
  begin
    write('Change to port number (currently ', port, '): ');
    L := GetLine(newport, 20);
    if (L > 0) and (newport[1] >= '0') and (newport[1] <= '9') then
      begin
        ComPortDeInit(port);
        val(newport, port, Error);
        Dummy := ComPortInit(port, CBrk, FI);
        writeln('Port ', port, ' active');
      end
  end;                            { ChgPort }



  procedure ChgRate;
  var
    L, RateIdx : integer;
    Error, Rate : word;
    newrate : string[20];
  begin
    write('Change baud rate to (currently ', Baud, '): ');
    L := GetLine(newrate, 20);
    if (L > 0) and (newrate[1] >= '0') and (newrate[1] <= '9') then
      begin
        val(newrate, Rate, Error);
        RateIdx := LookUp(Speeds, Rate, 7);
        if RateIdx = -1 then writeln('Invalid baud rate')
        else begin
          Baud := Rate;
          Rate := Codes[RateIdx] or Mask;
          Error := ComPortSet(port, Rate);
          writeln('Baud rate set to ', Baud);
        end
      end
  end;                            { ChgRate }



  function Pputs(port : word; Chk : boolean; var St : string) : integer;
  var
    I : integer;
    S, R : word;
    T : longint;
  label
    Quit;
  begin
    for I := 1 to length(St) do
      begin
        T := TimerSet(10);
        S := ComPortStat(port);
        while (S and PS_TXEMPTY) = 0 do
          begin
            if Chk and ((S and PS_CARRIER) = 0) then
              begin
                I := NO_CARRIER;
                goto Quit;
              end;
            if TimeUp(T) then
              begin
                I := TIMEOUT;
                goto Quit;
              end;
            R := ComTxChar(port, St[I]);
          end;
      end;
Quit:
    PPuts := I;
  end;                            { Pputs }


  procedure SetColor(col : word);
  var
    Intense, Blink : boolean;
    fg, bg : word;
  begin
    Blink := (col and 128) <> 0;
    Intense := (col and 8) <> 0;
    fg := col and 7;
    bg := (col and 127) shr 4;
    write(chr(27), '[0;');
    if Blink then write('5;');
    if Intense then write('1;');
    write(col_bg[bg], ';', col_fg[fg], 'm');
  end;                            { SetColor }


  { Converts ASCIIZ 'C' string to Pascal string }

  procedure CtoPas(var Dest : string; var Src : CString);
  var
    I : integer;
  begin
    I := 0;
    while Src[I+1] <> 0 do
      begin
        I := I+1;
        Dest[I] := chr(Src[I]);
      end;
    Dest[0] := chr(I);
  end;                            { CtoPas }

  {$V-}

begin
  assign(input, 'con');
  assign(output, 'con');
  rewrite(input);
  rewrite(output);
  if ComPortInit(port, CBrk, FI) <> FSIG then
    writeln('No FOSSIL loaded or requested port unavailable!'^G)
  else begin
    if FI.maxfunc < $1B then
      begin
        writeln(chr(7), 'Incompatible FOSSIL driver: use use revision 5 or later');
        writeln('Loaded FOSSIL is Revision', FI.revision, ' Max supported function is ', FI.maxfunc, ^G);
      end
    else begin
      SetColor($0A);
      writeln('FOSSIL Terminal Test Program 1.00');
      writeln('Copyright (c) 1989, David Nugent & Unique Computing Ptd Ltd');
      ComTimer(port, TI);
      Writeln;
      SetColor($0B);
      writeln('Timer interrupt = ', TI.timerint, ', Ticks/second = ', TI.ticksecs, ', Miliseconds/tick = ', TI.milltick);
      ComDrvInfo(port, FD, sizeof(FD));
      write('Revision ', FD.specver, ' Ver ', FD.drvlvl);
      write(' RX = ', FD.rxsize, 'b(', FD.rxavail, ')');
      write(' TX = ', FD.txsize, 'b(', FD.txavail, ')');
      writeln(' Screen = ', FD.scnwid, 'x', FD.scnlen);
      ComFlowCtl(port, FC_LOCXON or FC_REMXON);
      done := false;
      Writeln;
      SetColor($07);
      while not done do
        begin
{ >> }    ps := ComPortStat(port);
{ >> }    if (ps and PS_RXCHARS) <> 0 then write(ComRxChar(port));
{ >> }    if ComKbPeek <> -1 then
{ >> }      begin
{ >> }        K := ComKbChar;
	      case K of
		ALTP : ChgPort;
		ALTB : ChgRate;
                ALTF : begin
                         ComTxPurge(port);
                         ComFlowCtl(port, 0);
                         ComRxPurge(port);
                         ComFlowCtl(port, FC_LOCXON or FC_REMXON);
                       end;
                ALTH : begin
                         write('Hanging up ...');
                         E := ComSetDtr(port, 0);
                         Timer(50);
                         E := ComSetDtr(port, 1);
                         writeln;
                       end;
                ALTX : done := true;
                else E := ComTxChar(port, chr(K));
              end;
            end;
        end;
    end;
    SetColor(WHITE);
    ComPortDeInit(port);

  end
end.
