unit FLIB;                        { Revision 5 spec FOSSIL interface unit }

interface

const
  fsig = $1954;                   { Magic number for FOSSIL }
  { Port status bits }
  ps_rxchars = $0100;             { Characters in input buffer }
  ps_rxover = $0200;              { Receive buffer overrun }
  ps_txchars = $2000;             { Transmit buffer not full }
  ps_txempty = $4000;             { Transmit buffer is empty }
  ps_carrier = $0080;             { Carrier detect is high }
  { Communications paramters }
  cp_b19200 = $0000;              { 19200 baud }
  cp_b38400 = $0020;              { 38400 baud }
  cp_b300 = $0040;                {   300 baud }
  cp_b600 = $0060;                {   600 baud }
  cp_b1200 = $0080;               {  1200 baud }
  cp_b2400 = $00a0;               {  2400 baud }
  cp_b4800 = $00c0;               {  4800 baud }
  cp_b9600 = $00e0;               {  9600 baud }
  cp_parnone = $0000;             { No parity }
  cp_parspc = $0010;              { Space/mark parity }
  cp_parodd = $0008;              { Odd parity }
  cp_pareven = $0018;             { Even parity }
  cp_stop1 = $0000;               { 1 stop bit }
  cp_stop2 = $0004;               { 2 stop bits }
  cp_chlen8 = $0003;              { 8 data bits }
  cp_chlen7 = $0002;              { 7 data bits }
  cp_chlen6 = $0001;              { 6 data bits }
  { Flow control settings }
  fc_locxon = $0001;              { Enables local Xon/Xoff }
  fc_loccts = $0002;              { Enables local Cts/Dte }
  fc_remxon = $0008;              { Enables remove Xon/Xoff }
  fc_xonoff = $0000;              { Disables all flow control }
  { Useful flags & values }
  ok = 0;
  error = -1;
  no_carrier = -2;
  timeout = -3;

type
  byteptr = ^byte;
  cstring = array[0..255] of byte;
  cstringptr = ^cstring;
  finfotype = record
								maxfunc : byte;
								revision : byte;
              end;
  finfoptr = ^finfotype;
  ftiminfo = record
               timerint : byte;   { Timer interrupt number }
               ticksecs : byte;   { Number of timer ticks per second }
               milltick : byte;   { Number miliseconds per timer tick }
             end;
  ftimptr = ^ftiminfo;
  fdatatype = record
                stsize : word;    (* Offset 0 (Word) = Structure size *)
                specver : byte;   (*        2 (byte) = FOSSIL spec version *)
								drvlvl : byte;		(*				3 (byte) = Driver rev level *)
								drvid : byteptr;	(*				4 (dwrd) = Pointer to ASCII ID *)
                rxsize : word;    (*        8 (Word) = Input buffer size *)
                rxavail : word;   (*       0A (Word) = Bytes avail (input) *)
                txsize : word;    (*       0C (Word) = Output buffer size *)
                txavail : word;   (*       0E (Word) = Bytes avail (output) *)
                scnwid : byte;    (*       10 (byte) = Screen width, chars *)
                scnlen : byte;    (*       11 (byte) = Screen height, chars *)
                baud : word;      (*       12 (Word) = Baud rate mask *)
              end;
  fdataptr = ^fdatatype;

function comportstat(port : word) : word;
function comrxchar(port : word) : char;
function comrxpeek(port : word) : char;
function comkbpeek : integer;
function comkbchar : integer;
function comportinit(port : word;
                     var flagptr : byte;
                     var infoptr : finfotype) : word;
procedure comportdeinit(port : word);
function comportset(port : word;
                    parms : word) : word;
function comsetdtr(port : word;
                   state : word) : word;
procedure comflowctl(port : word;
                     mask : word);
function combrkchk(port : word;
                   mask : word) : word;
procedure comtxbrk(port : word;
                   flag : word);
procedure comdrvinfo(port : word;
                     var fdata : fdatatype; sz : integer);
function comtxchar(port : word;
                   ch : char) : word;
function comtxchrnw(port : word) : word;
procedure comrxpurge(port : word);
procedure comtxflush(port : word);
procedure comtxpurge(port : word);
function comrxblk(port : word;
                  bp : byteptr;
                  cnt : word) : word;
function comtxblk(port : word;
                  bp : byteptr;
                  cnt : word) : word;
procedure comcdwatch(port : word;
                     flag : word);
procedure comreboot(flag : word);
procedure comtimer(port : word; var ftime : ftiminfo);
function cominstfunc(flag : word;
                     userfunc : pointer) : word;

  {$L FOS_SPC.OBJ}
  {$L FOS_BLK.OBJ}
  {$L FOS_BUF.OBJ}
  {$L FOS_CHIO.OBJ}
  {$L FOS_CTL.OBJ}
  {$L FOS_KBD.OBJ}
  {$L FOS_TIME.OBJ}



implementation

  function comportstat(port : word) : word; external;
  function comrxchar(port : word) : char; external;
  function comrxpeek(port : word) : char; external;
	function comkbpeek : integer; external;
	function comkbchar : integer; external;
  function comportinit(port : word;
                       var flagptr : byte;
  var infoptr : finfotype) : word; external;
  procedure comportdeinit(port : word); external;
  function comportset(port : word;
  parms : word) : word; external;
  function comsetdtr(port : word;
  state : word) : word; external;
  procedure comflowctl(port : word;
  mask : word); external;
  function combrkchk(port : word;
  mask : word) : word; external;
  procedure comtxbrk(port : word;
  flag : word); external;
  procedure comdrvinfo(port : word;
  var fdata : fdatatype; sz : integer); external;
  function comtxchar(port : word;
  ch : char) : word; external;
  function comtxchrnw(port : word) : word; external;
  procedure comrxpurge(port : word); external;
  procedure comtxflush(port : word); external;
  procedure comtxpurge(port : word); external;
  function comrxblk(port : word;
                    bp : byteptr;
  cnt : word) : word; external;
  function comtxblk(port : word;
                    bp : byteptr;
  cnt : word) : word; external;
  procedure comcdwatch(port : word;
  flag : word); external;
  procedure comreboot(flag : word); external;
  procedure comtimer(port : word; var ftime : ftiminfo); external;
  function cominstfunc(flag : word;
  userfunc : pointer) : word; external;

end.
