;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;
;;	FOSSIL Interface Macros
;;
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; For TASM
ifdef ??version
;	masm51
;	quirks
endif


FOSSIL	equ	14h			; Communications software interrupt

FSIG	equ	1954H			; Magic number
SETBRK	equ	4f50h			; Set

comms	MACRO	func, port
ifnb	<func>
	mov	AH, FOSSIL_&func
  ifnb	<port>
	mov	DX, port
  endif
endif
	int	FOSSIL
	ENDM

; Fossil function numbers (Revision 5)

FOSSIL_setport		equ	00h	; Setup communication parameters
FOSSIL_txwait		equ	01h	; Transmit after wait for room
FOSSIL_rxwait		equ	02h	; Receive after wait for available
FOSSIL_portstat		equ	03h	; Get port status
FOSSIL_initport		equ     04h	; Initialise communications port
FOSSIL_deinitport	equ	05h	; DeInitialise communications port
FOSSIL_dtrctl		equ	06h	; Change state of DTR
FOSSIL_timer		equ	07h	; Get information about timer
FOSSIL_outflush		equ	08h	; Flush transmit buffer (wait until empty)
FOSSIL_outpurge		equ	09h	; Purge transmit buffer of pending output
FOSSIL_inpurge		equ	0ah	; Purge transmit buffer of pending output
FOSSIL_txnowait		equ	0bh	; Transmit character, no wait
FOSSIL_rxnowait		equ	0ch	; Receive character, no wait
FOSSIL_kbnowait		equ	0dh	; Read keyboard, no wait
FOSSIL_kbwait		equ	0eh	; Read keyboard, wait for character
FOSSIL_flowctl		equ	0fh	; Enable/disable flow control
FOSSIL_brkcheck		equ	10h	; Enable/disable break check
FOSSIL_setcur		equ	11h	; Set cursor position
FOSSIL_getcur		equ	12h	; Get cursos position
FOSSIL_wransi		equ	13h	; Write character with ansi support
FOSSIL_cdetect		equ	14h	; Carrier detect watchdog control
FOSSIL_wrchar		equ	15h	; Write character
FOSSIL_insttimer	equ	16h	; Insert/delete function from timer chain
FOSSIL_reboot		equ	17h	; Reboot machine
FOSSIL_rxblock		equ	18h	; Read a block of bytes
FOSSIL_txblock		equ	19h	; Write a block of bytes
FOSSIL_break		equ	1ah	; Start/stop break signal transmit
FOSSIL_drvinfo		equ 	1bh	; Get driver info
FOSSIL_instAPI		equ     7eh	; Install API
FOSSIL_deinstAPI	equ     7fh	; Deinstall API

finfo	STRUC
  maxfunc	db ?	; Maximum function number supported
  revfoss	db ?	; FOSSIL revision number
finfo	ENDS

tinfo	STRUC
  timerint db ?		; Timer tick interrupt number
  ticksecs db ?		; Number of timer ticks per second
  milltick db ?		; Number of milliseconds per timer tick
tinfo	ENDS

fossildata	STRUC
  fdsize	dw ?	; Offset 0 (word) = Structure size
  specver	db ?	;        2 (byte) = FOSSIL spec version
  drvlvl	db ?	;        3 (byte) = Driver rev level
  drvid		dd ?	;        4 (dwrd) = Pointer to ASCII ID
  rxsize	dw ?	;        8 (word) = Input buffer size
  rxavail	dw ?	;       0A (word) = Bytes avail (input)
  txsize	dw ?	;       0C (word) = Output buffer size
  txavail	dw ?	;       0E (word) = Bytes avail (output)
  scnwid	db ?	;       10 (byte) = Screen width, chars
  scnlen	db ?	;       11 (byte) = Screen height, chars
  bdmask	db ?	;       12 (byte) = Baud rate mask
fossildata	ENDS

